/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.LogUtils;
import org.springframework.beans.BeanWrapperImpl;

public class WebSecurityUtils {
    private static final Pattern ILLEGAL_IN_INTEGER = Pattern.compile("[^0-9+-]");
    private static final Pattern ILLEGAL_IN_FLOAT = Pattern.compile("[^0-9.Ee+-]");
    private static final Pattern ILLEGAL_IN_COLUMN_NAME_PATTERN = Pattern.compile("[^A-Za-z0-9_]");
    private static final Pattern scriptPattern = Pattern.compile("script", 2);

    public static String[] sanitizeString(String[] raw) {
        for (int i = 0; i < raw.length; ++i) {
            raw[i] = WebSecurityUtils.sanitizeString(raw[i]);
        }
        return raw;
    }

    public static String sanitizeString(String raw) {
        return WebSecurityUtils.sanitizeString(raw, false);
    }

    public static String sanitizeString(String raw, boolean allowHTML) {
        if (raw == null || raw.length() == 0) {
            return raw;
        }
        Matcher scriptMatcher = scriptPattern.matcher(raw);
        String next = scriptMatcher.replaceAll("&#x73;cript");
        if (!allowHTML) {
            next = next.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
        }
        return next;
    }

    public static int[] safeParseInt(String[] dirty) throws NumberFormatException {
        int[] clean = new int[dirty.length];
        for (int i = 0; i < dirty.length; ++i) {
            String cleanString = ILLEGAL_IN_INTEGER.matcher(dirty[i]).replaceAll("");
            clean[i] = Integer.parseInt(cleanString);
        }
        return clean;
    }

    public static int safeParseInt(String dirty) throws NumberFormatException {
        String clean = ILLEGAL_IN_INTEGER.matcher(dirty).replaceAll("");
        return Integer.parseInt(clean);
    }

    public static long safeParseLong(String dirty) throws NumberFormatException {
        String clean = ILLEGAL_IN_INTEGER.matcher(dirty).replaceAll("");
        return Long.parseLong(clean);
    }

    public static float safeParseFloat(String dirty) throws NumberFormatException {
        String clean = ILLEGAL_IN_FLOAT.matcher(dirty).replaceAll("");
        return Float.parseFloat(clean);
    }

    public static double safeParseDouble(String dirty) throws NumberFormatException {
        String clean = ILLEGAL_IN_FLOAT.matcher(dirty).replaceAll("");
        return Double.parseDouble(clean);
    }

    public static String sanitizeDbColumnName(String dirty) {
        return ILLEGAL_IN_COLUMN_NAME_PATTERN.matcher(dirty).replaceAll("");
    }

    public static Object sanitizeBeanStringProperties(Object bean, Set<String> allowHtmlFields) {
        PropertyDescriptor[] descriptions;
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(bean.getClass());
        for (PropertyDescriptor description : descriptions = beanWrapper.getPropertyDescriptors()) {
            if (!description.getReadMethod().getReturnType().equals(String.class)) continue;
            try {
                boolean allowHTML = false;
                if (allowHtmlFields != null && allowHtmlFields.contains(description.getName().toLowerCase())) {
                    allowHTML = true;
                }
                LogUtils.debugf(WebSecurityUtils.class, (String)"Try to sanitize string %s in %s with html %b", (Object[])new Object[]{description.getName(), bean.getClass(), allowHTML});
                description.getWriteMethod().invoke(bean, WebSecurityUtils.sanitizeString((String)description.getReadMethod().invoke(bean, new Object[0]), allowHTML));
            }
            catch (IllegalArgumentException e) {
                LogUtils.errorf(WebSecurityUtils.class, (String)"Illegal argument by sanitize object %s on property %s. Error %s", (Object[])new Object[]{description.getName(), bean.getClass(), e.getMessage()});
            }
            catch (IllegalAccessException e) {
                LogUtils.errorf(WebSecurityUtils.class, (String)"Illegal access by sanitize object %s on property %s. Error %s", (Object[])new Object[]{description.getName(), bean.getClass(), e.getMessage()});
            }
            catch (InvocationTargetException e) {
                LogUtils.errorf(WebSecurityUtils.class, (String)"Invocation target exception by sanitize object %s on property %s. Error %s", (Object[])new Object[]{description.getName(), bean.getClass(), e.getMessage()});
            }
        }
        return bean;
    }
}

