/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.vmware;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOExceptionWithCause;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.url.GenericURLConnection;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.vmware.VmwareImportRequest;
import org.opennms.netmgt.provision.service.vmware.VmwareImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareRequisitionUrlConnection
extends GenericURLConnection {
    private static final Logger logger = LoggerFactory.getLogger(VmwareRequisitionUrlConnection.class);
    private final VmwareImportRequest importRequest;

    public VmwareRequisitionUrlConnection(URL url) throws MalformedURLException, RemoteException {
        super(url);
        logger.debug("Initializing URL Connection for host {}", (Object)url.getHost());
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("host", url.getHost());
        requestParameters.put("path", url.getPath());
        if (url.getUserInfo() != null && !url.getUserInfo().isEmpty()) {
            logger.warn("Old user credentials handling scheme detected. I'm gonna use it but you'd better adapt your URL to the new query parameter scheme 'vmware://<vcenter_server_fqdn>?username=<username>;password=<password>;....'");
            requestParameters.put("username", this.getUsername());
            requestParameters.put("password", this.getPassword());
        }
        requestParameters.putAll(this.getQueryArgs());
        this.importRequest = new VmwareImportRequest(requestParameters);
    }

    protected Requisition getExistingRequisition(String foreignSource) {
        Requisition curReq = null;
        try {
            ForeignSourceRepository repository = (ForeignSourceRepository)BeanUtils.getBean((String)"daoContext", (String)"deployedForeignSourceRepository", ForeignSourceRepository.class);
            if (repository != null) {
                curReq = repository.getRequisition(foreignSource);
            }
        }
        catch (Exception e) {
            logger.warn("Can't retrieve requisition {}", (Object)foreignSource, (Object)e);
        }
        return curReq;
    }

    public void connect() {
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayInputStream stream = null;
        try {
            Requisition existingRequisition = this.getExistingRequisition(this.importRequest.getForeignSource());
            this.importRequest.setExistingRequisition(existingRequisition);
            VmwareImporter importer = new VmwareImporter(this.importRequest);
            stream = new ByteArrayInputStream(this.jaxBMarshal(importer.getRequisition()).getBytes());
        }
        catch (Throwable e) {
            logger.warn("Problem getting input stream: '{}'", e);
            throw new IOExceptionWithCause("Problem getting input stream: " + e, e);
        }
        return stream;
    }

    private String jaxBMarshal(Requisition r) throws JAXBException {
        return JaxbUtils.marshal((Object)r);
    }

    public VmwareImportRequest getImportRequest() {
        return this.importRequest;
    }
}

