/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.google.common.base.Strings;
import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.mo.HostSystem;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collection.api.AbstractRemoteServiceCollector;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.vmware.VmwareServer;
import org.opennms.netmgt.config.vmware.cim.Attrib;
import org.opennms.netmgt.config.vmware.cim.VmwareCimCollection;
import org.opennms.netmgt.config.vmware.cim.VmwareCimGroup;
import org.opennms.netmgt.dao.VmwareCimDatacollectionConfigDao;
import org.opennms.netmgt.dao.VmwareConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.service.vmware.VmwareImporter;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.vmware.VmwareViJavaAccess;
import org.sblim.wbem.cim.CIMObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class VmwareCimCollector
extends AbstractRemoteServiceCollector {
    private static Map<String, ValueModifier> valueModifiers = new HashMap<String, ValueModifier>();
    private static final Logger logger;
    private static final Map<String, Class<?>> TYPE_MAP;
    private NodeDao m_nodeDao = null;
    private TransactionTemplate m_transactionTemplate = null;
    private VmwareCimDatacollectionConfigDao m_vmwareCimDatacollectionConfigDao;
    private VmwareConfigDao m_vmwareConfigDao = null;
    private static Map<Integer, String> sensorTypeMapping;
    private static Map<Integer, String> rateUnitMapping;
    private static Map<Integer, String> baseUnitMapping;

    public VmwareCimCollector() {
        super(TYPE_MAP);
    }

    public void initialize() throws CollectionInitializationException {
        if (this.m_nodeDao == null) {
            this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        }
        if (this.m_nodeDao == null) {
            logger.error("Node dao should be a non-null value.");
        }
        if (this.m_vmwareCimDatacollectionConfigDao == null) {
            this.m_vmwareCimDatacollectionConfigDao = (VmwareCimDatacollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareCimDatacollectionConfigDao", VmwareCimDatacollectionConfigDao.class);
        }
        if (this.m_nodeDao == null) {
            logger.error("vmwareCimDatacollectionConfigDao should be a non-null value.");
        }
        if (this.m_vmwareConfigDao == null) {
            this.m_vmwareConfigDao = (VmwareConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareConfigDao", VmwareConfigDao.class);
        }
        if (this.m_transactionTemplate == null) {
            this.m_transactionTemplate = (TransactionTemplate)BeanUtils.getBean((String)"daoContext", (String)"transactionTemplate", TransactionTemplate.class);
        }
    }

    public Map<String, Object> getRuntimeAttributes(final CollectionAgent agent, final Map<String, Object> parameters) {
        final HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        this.m_transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus transactionStatus) {
                OnmsNode onmsNode = (OnmsNode)VmwareCimCollector.this.m_nodeDao.get((Serializable)Integer.valueOf(agent.getNodeId()));
                if (onmsNode == null) {
                    throw new IllegalArgumentException(String.format("VmwareCollector: No node found with id: %d", agent.getNodeId()));
                }
                String vmwareManagementServer = VmwareImporter.getManagementServer(onmsNode);
                if (Strings.isNullOrEmpty((String)vmwareManagementServer)) {
                    throw new IllegalArgumentException(String.format("VmwareCollector: No management server is set on node with id %d.", onmsNode.getId()));
                }
                runtimeAttributes.put("managementServer", vmwareManagementServer);
                String vmwareManagedObjectId = onmsNode.getForeignId();
                if (Strings.isNullOrEmpty((String)vmwareManagedObjectId)) {
                    throw new IllegalArgumentException(String.format("VmwareCollector: No foreign id is set on node with id %d.", onmsNode.getId()));
                }
                runtimeAttributes.put("managedObjectId", vmwareManagedObjectId);
                String collectionName = ParameterMap.getKeyedString((Map)parameters, (String)"collection", (String)ParameterMap.getKeyedString((Map)parameters, (String)"vmware-collection", null));
                VmwareCimCollection collection = VmwareCimCollector.this.m_vmwareCimDatacollectionConfigDao.getVmwareCimCollection(collectionName);
                if (collection == null) {
                    throw new IllegalArgumentException(String.format("VmwareCollector: No collection found with name '%s'.", collectionName));
                }
                runtimeAttributes.put("vmwareCollection", collection);
                Map<String, VmwareServer> serverMap = VmwareCimCollector.this.m_vmwareConfigDao.getServerMap();
                if (serverMap == null) {
                    throw new IllegalStateException(String.format("VmwareCollector: Error getting vmware-config.xml's server map.", new Object[0]));
                }
                VmwareServer vmwareServer = serverMap.get(vmwareManagementServer);
                if (vmwareServer == null) {
                    throw new IllegalStateException(String.format("VmwareCollector: Error getting credentials for VMware management server: %s", vmwareManagementServer));
                }
                runtimeAttributes.put("vmwareServer", vmwareServer);
                return null;
            }
        });
        return runtimeAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        VmwareCimCollection collection = (VmwareCimCollection)parameters.get("vmwareCollection");
        String vmwareManagementServer = (String)parameters.get("managementServer");
        String vmwareManagedObjectId = (String)parameters.get("managedObjectId");
        VmwareServer vmwareServer = (VmwareServer)parameters.get("vmwareServer");
        CollectionSetBuilder builder = new CollectionSetBuilder(agent);
        builder.withStatus(CollectionStatus.FAILED);
        VmwareViJavaAccess vmwareViJavaAccess = new VmwareViJavaAccess(vmwareServer);
        if (collection.getVmwareCimGroup().length < 1) {
            logger.info("No groups to collect. Returning empty collection set.");
            builder.withStatus(CollectionStatus.SUCCEEDED);
            return builder.build();
        }
        try {
            vmwareViJavaAccess.connect();
        }
        catch (MalformedURLException e) {
            logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
            return builder.build();
        }
        catch (RemoteException e) {
            logger.warn("Error connecting VMware management server '{}': '{}' exception: {} cause: '{}'", new Object[]{vmwareManagementServer, e.getMessage(), e.getClass().getName(), e.getCause()});
            return builder.build();
        }
        int timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)3000);
        if (!vmwareViJavaAccess.setTimeout(timeout)) {
            logger.warn("Error setting connection timeout for VMware management server '{}'", (Object)vmwareManagementServer);
        }
        HostSystem hostSystem = vmwareViJavaAccess.getHostSystemByManagedObjectId(vmwareManagedObjectId);
        String powerState = null;
        if (hostSystem == null) {
            logger.debug("hostSystem=null");
        } else {
            HostRuntimeInfo hostRuntimeInfo = hostSystem.getRuntime();
            if (hostRuntimeInfo == null) {
                logger.debug("hostRuntimeInfo=null");
            } else {
                HostSystemPowerState hostSystemPowerState = hostRuntimeInfo.getPowerState();
                if (hostSystemPowerState == null) {
                    logger.debug("hostSystemPowerState=null");
                } else {
                    powerState = hostSystemPowerState.toString();
                }
            }
        }
        logger.debug("The power state for host system '{}' is '{}'", (Object)vmwareManagedObjectId, powerState);
        if ("poweredOn".equals(powerState)) {
            HashMap<String, List<CIMObject>> cimObjects = new HashMap<String, List<CIMObject>>();
            for (VmwareCimGroup vmwareCimGroup : collection.getVmwareCimGroup()) {
                List<CIMObject> cimList;
                String cimClass = vmwareCimGroup.getCimClass();
                if (!cimObjects.containsKey(cimClass)) {
                    cimList = null;
                    try {
                        cimList = vmwareViJavaAccess.queryCimObjects(hostSystem, cimClass, InetAddressUtils.str((InetAddress)agent.getAddress()));
                    }
                    catch (Exception e) {
                        logger.warn("Error retrieving CIM values from host system '{}'. Error message: '{}'", (Object)vmwareManagedObjectId, (Object)e.getMessage());
                        CollectionSetDTO collectionSetDTO = builder.build();
                        return collectionSetDTO;
                    }
                    finally {
                        vmwareViJavaAccess.disconnect();
                    }
                    cimObjects.put(cimClass, cimList);
                }
                if ((cimList = (List<CIMObject>)cimObjects.get(cimClass)) == null) {
                    logger.warn("Error getting objects of CIM class '{}' from host system '{}'", (Object)cimClass, (Object)vmwareManagedObjectId);
                    continue;
                }
                String keyAttribute = vmwareCimGroup.getKey();
                String attributeValue = vmwareCimGroup.getValue();
                String instanceAttribute = vmwareCimGroup.getInstance();
                for (CIMObject cimObject : cimList) {
                    String cimObjectValue;
                    boolean addObject = false;
                    addObject = keyAttribute != null && attributeValue != null ? attributeValue.equals(cimObjectValue = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, keyAttribute)) : true;
                    if (!addObject) continue;
                    String instance = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, instanceAttribute);
                    NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
                    DeferredGenericTypeResource resource = new DeferredGenericTypeResource(nodeResource, vmwareCimGroup.getResourceType(), instance);
                    for (Attrib attrib : vmwareCimGroup.getAttrib()) {
                        AttributeType type = attrib.getType();
                        String value = vmwareViJavaAccess.getPropertyOfCimObject(cimObject, attrib.getName());
                        if (valueModifiers.containsKey(attrib.getName())) {
                            String modifiedValue = valueModifiers.get(attrib.getName()).modifyValue(attrib.getName(), value, cimObject, vmwareViJavaAccess);
                            logger.debug("Applying value modifier for instance value " + attrib.getName() + "[" + instance + "]='" + value + "' => '" + modifiedValue + "' for node " + agent.getNodeId());
                            value = modifiedValue;
                        }
                        builder.withAttribute((Resource)resource, vmwareCimGroup.getName(), attrib.getAlias(), value, type);
                    }
                }
            }
            builder.withStatus(CollectionStatus.SUCCEEDED);
        }
        vmwareViJavaAccess.disconnect();
        return builder.build();
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_vmwareCimDatacollectionConfigDao.getRrdRepository(collectionName);
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    static {
        valueModifiers.put("SensorType", new ValueModifier(){

            @Override
            public String modifyValue(String name, String value, CIMObject cimObject, VmwareViJavaAccess vmwareViJavaAccess) {
                String modifiedValue;
                if (value != null && (modifiedValue = (String)sensorTypeMapping.get(Integer.valueOf(value))) != null) {
                    return modifiedValue;
                }
                return "null";
            }
        });
        valueModifiers.put("BaseUnits", new ValueModifier(){

            @Override
            public String modifyValue(String name, String value, CIMObject cimObject, VmwareViJavaAccess vmwareViJavaAccess) {
                String modifiedValue;
                if (value != null && (modifiedValue = (String)baseUnitMapping.get(Integer.valueOf(value))) != null) {
                    return modifiedValue;
                }
                return "null";
            }
        });
        valueModifiers.put("RateUnits", new ValueModifier(){

            @Override
            public String modifyValue(String name, String value, CIMObject cimObject, VmwareViJavaAccess vmwareViJavaAccess) {
                String modifiedValue;
                if (value != null && (modifiedValue = (String)rateUnitMapping.get(Integer.valueOf(value))) != null) {
                    return modifiedValue;
                }
                return "null";
            }
        });
        ValueModifier currentReadingModifier = new ValueModifier(){

            @Override
            public String modifyValue(String name, String value, CIMObject cimObject, VmwareViJavaAccess vmwareViJavaAccess) {
                if (value == null) {
                    return null;
                }
                return this.applyUnitModifier(value, vmwareViJavaAccess.getPropertyOfCimObject(cimObject, "UnitModifier"));
            }

            private String applyUnitModifier(String attributeValue, String unitModifier) {
                return String.valueOf(Double.valueOf(attributeValue) * Math.pow(10.0, Double.valueOf(unitModifier)));
            }
        };
        valueModifiers.put("CurrentReading", currentReadingModifier);
        valueModifiers.put("UpperThresholdCritical", currentReadingModifier);
        valueModifiers.put("LowerThresholdCritical", currentReadingModifier);
        valueModifiers.put("UpperThresholdNonCritical", currentReadingModifier);
        valueModifiers.put("LowerThresholdNonCritical", currentReadingModifier);
        valueModifiers.put("UpperThresholdFatal", currentReadingModifier);
        valueModifiers.put("LowerThresholdFatal", currentReadingModifier);
        valueModifiers.put("MaxReadable", currentReadingModifier);
        valueModifiers.put("MinReadable", currentReadingModifier);
        logger = LoggerFactory.getLogger(VmwareCimCollector.class);
        TYPE_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Class<VmwareCimCollection>>("vmwareCollection", VmwareCimCollection.class), new AbstractMap.SimpleEntry<String, Class<VmwareServer>>("vmwareServer", VmwareServer.class)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Class)e.getValue())));
        sensorTypeMapping = new HashMap<Integer, String>();
        sensorTypeMapping.put(0, "Unknown");
        sensorTypeMapping.put(1, "Other");
        sensorTypeMapping.put(2, "Temperature");
        sensorTypeMapping.put(3, "Voltage");
        sensorTypeMapping.put(4, "Current");
        sensorTypeMapping.put(5, "Tachometer");
        sensorTypeMapping.put(6, "Counter");
        sensorTypeMapping.put(7, "Switch");
        sensorTypeMapping.put(8, "Lock");
        sensorTypeMapping.put(9, "Humidity");
        sensorTypeMapping.put(10, "Smoke Detection");
        sensorTypeMapping.put(11, "Presence");
        sensorTypeMapping.put(12, "Air Flow");
        sensorTypeMapping.put(13, "Power Consumption");
        sensorTypeMapping.put(14, "Power Production");
        sensorTypeMapping.put(15, "Pressure");
        sensorTypeMapping.put(16, "Intrusion");
        sensorTypeMapping.put(17, "DMTF Reserved");
        sensorTypeMapping.put(18, "Vendor Reserved");
        rateUnitMapping = new HashMap<Integer, String>();
        rateUnitMapping.put(0, "None");
        rateUnitMapping.put(1, "Per MicroSecond");
        rateUnitMapping.put(2, "Per MilliSecond");
        rateUnitMapping.put(3, "Per Second");
        rateUnitMapping.put(4, "Per Minute");
        rateUnitMapping.put(5, "Per Hour");
        rateUnitMapping.put(6, "Per Day");
        rateUnitMapping.put(7, "Per Week");
        rateUnitMapping.put(8, "Per Month");
        rateUnitMapping.put(9, "Per Year");
        baseUnitMapping = new HashMap<Integer, String>();
        baseUnitMapping.put(0, "Unknown");
        baseUnitMapping.put(1, "Other");
        baseUnitMapping.put(2, "Degrees C");
        baseUnitMapping.put(3, "Degrees F");
        baseUnitMapping.put(4, "Degrees K");
        baseUnitMapping.put(5, "Volts");
        baseUnitMapping.put(6, "Amps");
        baseUnitMapping.put(7, "Watts");
        baseUnitMapping.put(8, "Joules");
        baseUnitMapping.put(9, "Coulombs");
        baseUnitMapping.put(10, "VA");
        baseUnitMapping.put(11, "Nits");
        baseUnitMapping.put(12, "Lumens");
        baseUnitMapping.put(13, "Lux");
        baseUnitMapping.put(14, "Candelas");
        baseUnitMapping.put(15, "kPa");
        baseUnitMapping.put(16, "PSI");
        baseUnitMapping.put(17, "Newtons");
        baseUnitMapping.put(18, "CFM");
        baseUnitMapping.put(19, "RPM");
        baseUnitMapping.put(20, "Hertz");
        baseUnitMapping.put(21, "Seconds");
        baseUnitMapping.put(22, "Minutes");
        baseUnitMapping.put(23, "Hours");
        baseUnitMapping.put(24, "Days");
        baseUnitMapping.put(25, "Weeks");
        baseUnitMapping.put(26, "Mils");
        baseUnitMapping.put(27, "Inches");
        baseUnitMapping.put(28, "Feet");
        baseUnitMapping.put(29, "Cubic Inches");
        baseUnitMapping.put(30, "Cubic Feet");
        baseUnitMapping.put(31, "Meters");
        baseUnitMapping.put(32, "Cubic Centimeters");
        baseUnitMapping.put(33, "Cubic Meters");
        baseUnitMapping.put(34, "Liters");
        baseUnitMapping.put(35, "Fluid Ounces");
        baseUnitMapping.put(36, "Radians");
        baseUnitMapping.put(37, "Steradians");
        baseUnitMapping.put(38, "Revolutions");
        baseUnitMapping.put(39, "Cycles");
        baseUnitMapping.put(40, "Gravities");
        baseUnitMapping.put(41, "Ounces");
        baseUnitMapping.put(42, "Pounds");
        baseUnitMapping.put(43, "Foot-Pounds");
        baseUnitMapping.put(44, "Ounce-Inches");
        baseUnitMapping.put(45, "Gauss");
        baseUnitMapping.put(46, "Gilberts");
        baseUnitMapping.put(47, "Henries");
        baseUnitMapping.put(48, "Farads");
        baseUnitMapping.put(49, "Ohms");
        baseUnitMapping.put(50, "Siemens");
        baseUnitMapping.put(51, "Moles");
        baseUnitMapping.put(52, "Becquerels");
        baseUnitMapping.put(53, "PPM (parts/million)");
        baseUnitMapping.put(54, "Decibels");
        baseUnitMapping.put(55, "DbA");
        baseUnitMapping.put(56, "DbC");
        baseUnitMapping.put(57, "Grays");
        baseUnitMapping.put(58, "Sieverts");
        baseUnitMapping.put(59, "Color Temperature Degrees K");
        baseUnitMapping.put(60, "Bits");
        baseUnitMapping.put(61, "Bytes");
        baseUnitMapping.put(62, "Words (data)");
        baseUnitMapping.put(63, "DoubleWords");
        baseUnitMapping.put(64, "QuadWords");
        baseUnitMapping.put(65, "Percentage");
        baseUnitMapping.put(66, "Pascals");
    }

    private static interface ValueModifier {
        public String modifyValue(String var1, String var2, CIMObject var3, VmwareViJavaAccess var4);
    }
}

