/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.vmware.cim;

import java.io.File;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.vmware.cim.VmwareCimCollectionResource;
import org.opennms.netmgt.model.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareCimMultiInstanceCollectionResource
extends VmwareCimCollectionResource {
    private final Logger logger = LoggerFactory.getLogger((String)("OpenNMS.VMware." + VmwareCimMultiInstanceCollectionResource.class.getName()));
    private final String m_inst;
    private final String m_name;

    public VmwareCimMultiInstanceCollectionResource(CollectionAgent agent, String instance, String name) {
        super(agent);
        this.m_inst = instance;
        this.m_name = name;
    }

    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, this.getParent());
        File typeDir = new File(nodeDir, this.m_name);
        File instDir = new File(typeDir, this.m_inst.replaceAll("/", "_").replaceAll("\\s+", "_").replaceAll(":", "_").replaceAll("\\\\", "_").replaceAll("[\\[\\]]", "_"));
        this.logger.debug("getResourceDir: '{}'", (Object)instDir);
        return instDir;
    }

    @Override
    public String getResourceTypeName() {
        return this.m_name;
    }

    @Override
    public String getInstance() {
        return this.m_inst;
    }

    public String toString() {
        return "Node[" + this.m_agent.getNodeId() + "]/type[" + this.m_name + "]/instance[" + this.m_inst + "]";
    }
}

