/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.vmware;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.vmware.VmwareRequisitionUrlConnection;

public class VmwareRequisitionTool {
    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        CommandLine cmd = parser.parse(options, args);
        List arguments = cmd.getArgList();
        if (arguments.size() < 1) {
            VmwareRequisitionTool.usage(options, cmd);
            System.exit(1);
        }
        String urlString = (String)arguments.remove(0);
        URL url = new URL(urlString.replaceFirst("vmware", "http"));
        VmwareRequisitionUrlConnection c = new VmwareRequisitionUrlConnection(url){

            @Override
            protected Requisition getExistingRequisition() {
                File req = new File(ConfigFileConstants.getFilePathString(), "imports" + File.separator + this.m_foreignSource + ".xml");
                if (req.exists()) {
                    return (Requisition)JaxbUtils.unmarshal(Requisition.class, (File)req);
                }
                return null;
            }
        };
        c.connect();
        InputStream is = c.getInputStream();
        if (is == null) {
            System.err.println("Couldn't generate requisition from " + urlString);
            System.exit(1);
        } else {
            System.out.println(IOUtils.toString((InputStream)is, (String)"UTF-8"));
        }
    }

    private static void usage(Options options, CommandLine cmd, String error, Exception e) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(System.out);
        if (error != null) {
            pw.println("An error occurred: " + error + "\n");
        }
        formatter.printHelp("Usage: VmwareRequisitionTool vmware://username:password@host[/foreign-source]?keyA=valueA;keyB=valueB;...", options);
        if (e != null) {
            pw.println(e.getMessage());
            e.printStackTrace(pw);
        }
        pw.close();
    }

    private static void usage(Options options, CommandLine cmd) {
        VmwareRequisitionTool.usage(options, cmd, null, null);
    }
}

