/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.io.File;
import java.util.List;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.netmgt.config.vmware.cim.VmwareCimCollection;
import org.opennms.netmgt.config.vmware.cim.VmwareCimDatacollectionConfig;
import org.opennms.netmgt.dao.VmwareCimDatacollectionConfigDao;
import org.opennms.netmgt.model.RrdRepository;

public class VmwareCimDatacollectionConfigDaoJaxb
extends AbstractJaxbConfigDao<VmwareCimDatacollectionConfig, VmwareCimDatacollectionConfig>
implements VmwareCimDatacollectionConfigDao {
    public VmwareCimDatacollectionConfigDaoJaxb() {
        super(VmwareCimDatacollectionConfig.class, "Vmware Cim Data Collection Configuration");
    }

    @Override
    public VmwareCimDatacollectionConfig getConfig() {
        return (VmwareCimDatacollectionConfig)this.getContainer().getObject();
    }

    public VmwareCimDatacollectionConfig translateConfig(VmwareCimDatacollectionConfig jaxbConfig) {
        return jaxbConfig;
    }

    @Override
    public VmwareCimCollection getVmwareCimCollection(String collectionName) {
        VmwareCimCollection[] collections = this.getConfig().getVmwareCimCollection();
        VmwareCimCollection collection = null;
        for (VmwareCimCollection coll : collections) {
            if (!coll.getName().equalsIgnoreCase(collectionName)) continue;
            collection = coll;
            break;
        }
        if (collection == null) {
            throw new IllegalArgumentException("getVmwareCimCollection: collection name: " + collectionName + " specified in collectd configuration not found in Vmware collection configuration.");
        }
        return collection;
    }

    @Override
    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdPath()));
        repo.setRraList(this.getRRAList(collectionName));
        repo.setStep(this.getStep(collectionName));
        repo.setHeartBeat(2 * this.getStep(collectionName));
        return repo;
    }

    private int getStep(String cName) {
        VmwareCimCollection collection = this.getVmwareCimCollection(cName);
        if (collection != null) {
            return collection.getRrd().getStep();
        }
        return -1;
    }

    private List<String> getRRAList(String cName) {
        VmwareCimCollection collection = this.getVmwareCimCollection(cName);
        if (collection != null) {
            return collection.getRrd().getRraCollection();
        }
        return null;
    }

    @Override
    public String getRrdPath() {
        String rrdPath = this.getConfig().getRrdRepository();
        if (rrdPath == null) {
            throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
        }
        if (rrdPath.endsWith(File.separator)) {
            rrdPath = rrdPath.substring(0, rrdPath.length() - File.separator.length());
        }
        return rrdPath;
    }
}

