/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.vmware.cim;

import org.opennms.netmgt.collectd.AbstractCollectionAttribute;
import org.opennms.netmgt.collectd.vmware.cim.VmwareCimCollectionResource;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionAttributeType;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.ServiceParameters;

public class VmwareCimCollectionAttribute
extends AbstractCollectionAttribute
implements CollectionAttribute {
    private String m_alias;
    private String m_value;
    private VmwareCimCollectionResource m_resource;
    private CollectionAttributeType m_attribType;

    public VmwareCimCollectionAttribute(VmwareCimCollectionResource resource, CollectionAttributeType attribType, String alias, String value) {
        this.m_resource = resource;
        this.m_attribType = attribType;
        this.m_alias = alias;
        this.m_value = value;
    }

    public CollectionAttributeType getAttributeType() {
        return this.m_attribType;
    }

    public String getName() {
        return this.m_alias;
    }

    public String getMetricIdentifier() {
        return "VmwareCim_" + this.m_attribType.getName();
    }

    public String getNumericValue() {
        return this.m_value;
    }

    public CollectionResource getResource() {
        return this.m_resource;
    }

    public String getStringValue() {
        return this.m_value;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public String getType() {
        return this.m_attribType.getType();
    }

    public String toString() {
        return "VmwareCimCollectionAttribute " + this.m_alias + "=" + this.m_value;
    }
}

