/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

public final class Base64 {
    private static final char[] BASE64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] BASE64_VALUES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    private static final char BASE64_PAD = '=';

    public static char[] encodeBase64(byte[] data) {
        int destlen = (data.length + 2) / 3 * 4;
        char[] dest = new char[destlen];
        int destndx = 0;
        for (int i = 0; i < data.length; i += 3) {
            int j;
            int quantum = 0;
            int pad = 0;
            int bytes = data.length - i;
            if (bytes >= 1) {
                quantum = data[i] < 0 ? 256 + data[i] : data[i];
                pad = 2;
            }
            quantum <<= 8;
            if (bytes >= 2) {
                quantum |= data[i + 1] < 0 ? 256 + data[i + 1] : data[i + 1];
                pad = 1;
            }
            quantum <<= 8;
            if (bytes > 2) {
                quantum |= data[i + 2] < 0 ? 256 + data[i + 2] : data[i + 2];
                pad = 0;
            }
            for (j = 3; j >= pad; --j) {
                int ndx = quantum >> j * 6 & 0x3F;
                dest[destndx++] = BASE64_CHARS[ndx];
            }
            for (j = pad; j > 0; --j) {
                dest[destndx++] = 61;
            }
        }
        return dest;
    }

    public static byte[] decodeBase64(char[] data) {
        if (data.length == 0) {
            return new byte[0];
        }
        if (data.length % 4 != 0) {
            throw new IllegalArgumentException("Invalid base64 encoding, improper length");
        }
        int rawlen = data.length / 4 * 3;
        for (int i = 1; i <= 2; ++i) {
            if (data[data.length - i] != '=') continue;
            --rawlen;
        }
        byte[] rawdata = new byte[rawlen];
        int rawndx = 0;
        int quantum = 0;
        for (int i = 0; i < data.length; ++i) {
            int c;
            if (i % 4 == 0 && i > 0) {
                c = quantum >> 16 & 0xFF;
                rawdata[rawndx++] = (byte)(c > 127 ? c - 256 : c);
                c = quantum >> 8 & 0xFF;
                rawdata[rawndx++] = (byte)(c > 127 ? c - 256 : c);
                c = quantum & 0xFF;
                rawdata[rawndx++] = (byte)(c > 127 ? c - 256 : c);
                quantum = 0;
            }
            quantum <<= 6;
            c = data[i];
            if (c >= BASE64_VALUES.length || BASE64_VALUES[c] == -1) {
                throw new IllegalArgumentException("Invalid character in decode stream");
            }
            quantum |= BASE64_VALUES[c];
        }
        int c = quantum >> 16 & 0xFF;
        rawdata[rawndx++] = (byte)(c > 127 ? c - 256 : c);
        if (rawndx < rawlen) {
            c = quantum >> 8 & 0xFF;
            rawdata[rawndx++] = (byte)(c > 127 ? c - 256 : c);
        }
        if (rawndx < rawlen) {
            c = quantum & 0xFF;
            rawdata[rawndx++] = (byte)(c > 127 ? c - 256 : c);
        }
        return rawdata;
    }

    private Base64() {
    }
}

