/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.RelaxedX509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SocketUtils.class);

    public static Socket wrapSocketInSslContext(Socket socket) throws IOException {
        return SocketUtils.wrapSocketInSslContext(socket, null, null);
    }

    public static SSLSocket wrapSocketInSslContext(Socket socket, String protocol) throws IOException {
        return SocketUtils.wrapSocketInSslContext(socket, protocol, null);
    }

    public static SSLSocket wrapSocketInSslContext(Socket socket, String protocol, String[] cipherSuites) throws IOException {
        TrustManager[] tm = new TrustManager[]{new RelaxedX509ExtendedTrustManager()};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance(protocol == null ? "SSL" : protocol);
            sslContext.init(null, tm, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("wrapSocket: Error wrapping socket, throwing runtime exception", (Throwable)e);
            throw new IllegalStateException("No such algorithm in SSLSocketFactory: " + e);
        }
        catch (KeyManagementException e) {
            LOG.error("wrapSocket: Error wrapping socket, throwing runtime exception", (Throwable)e);
            throw new IllegalStateException("Key management exception in SSLSocketFactory: " + e);
        }
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        InetAddress inetAddress = socket.getInetAddress();
        String hostAddress = InetAddressUtils.str(inetAddress);
        SSLSocket wrappedSocket = (SSLSocket)socketFactory.createSocket(socket, hostAddress, socket.getPort(), true);
        if (cipherSuites != null && cipherSuites.length > 0) {
            wrappedSocket.setEnabledCipherSuites(cipherSuites);
        }
        return wrappedSocket;
    }
}

