/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.LogUtils;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public abstract class InetAddressUtils {
    public static final InetAddress UNPINGABLE_ADDRESS;
    public static final InetAddress UNPINGABLE_ADDRESS_IPV6;

    public static InetAddress getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LogUtils.warnf(InetAddressUtils.class, (Throwable)e, (String)"getLocalHostAddress: Could not lookup the host address for the local host machine, address set to '127.0.0.1'.", (Object[])new Object[0]);
            return InetAddressUtils.addr("127.0.0.1");
        }
    }

    public static String getLocalHostAddressAsString() {
        String localhost = InetAddressUtils.str(InetAddressUtils.getLocalHostAddress());
        return localhost == null ? "127.0.0.1" : localhost;
    }

    public static String getLocalHostName() {
        InetAddress localHostAddress = InetAddressUtils.getLocalHostAddress();
        if (localHostAddress == null) {
            LogUtils.warnf(InetAddressUtils.class, (String)"getLocalHostName: Could not lookup the host name for the local host machine, name set to 'localhost'.", (Object[])new Object[0]);
            return "localhost";
        }
        return localHostAddress.getHostName();
    }

    public static String incr(String address) throws UnknownHostException {
        return InetAddressUtils.toIpAddrString(InetAddressUtils.incr(InetAddressUtils.toIpAddrBytes(address)));
    }

    public static byte[] incr(byte[] address) throws UnknownHostException {
        BigInteger addr = new BigInteger(1, address).add(BigInteger.ONE);
        return InetAddressUtils.convertBigIntegerIntoInetAddress(addr).getAddress();
    }

    public static String decr(String address) throws UnknownHostException {
        return InetAddressUtils.toIpAddrString(InetAddressUtils.decr(InetAddressUtils.toIpAddrBytes(address)));
    }

    public static byte[] decr(byte[] address) throws UnknownHostException {
        BigInteger addr = new BigInteger(1, address).subtract(BigInteger.ONE);
        return InetAddressUtils.convertBigIntegerIntoInetAddress(addr).getAddress();
    }

    public static InetAddress getInetAddress(int[] octets, int offset, int length) {
        byte[] addressBytes = new byte[length];
        for (int i = 0; i < addressBytes.length; ++i) {
            addressBytes[i] = Integer.valueOf(octets[i + offset]).byteValue();
        }
        return InetAddressUtils.getInetAddress(addressBytes);
    }

    public static InetAddress getInetAddress(byte[] ipAddrOctets) {
        try {
            return InetAddress.getByAddress(ipAddrOctets);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IPAddress " + ipAddrOctets + " with length " + ipAddrOctets.length);
        }
    }

    public static InetAddress getInetAddress(String dottedNotation) {
        try {
            return InetAddress.getByName(dottedNotation);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IPAddress " + dottedNotation);
        }
    }

    public static InetAddress resolveHostname(String hostname, boolean preferInet6Address) throws UnknownHostException {
        return InetAddressUtils.resolveHostname(hostname, preferInet6Address, true);
    }

    public static InetAddress resolveHostname(String hostname, boolean preferInet6Address, boolean throwException) throws UnknownHostException {
        InetAddress retval = null;
        if ("localhost".equals(hostname)) {
            return preferInet6Address ? InetAddress.getByName("::1") : InetAddress.getByName("127.0.0.1");
        }
        try {
            ArrayList<InetAddress> v4Addresses = new ArrayList<InetAddress>();
            try {
                Record[] aRecs = new Lookup(hostname, 1).run();
                if (aRecs != null) {
                    for (Record aRec : aRecs) {
                        if (!(aRec instanceof ARecord)) continue;
                        InetAddress addr = ((ARecord)aRec).getAddress();
                        if (addr instanceof Inet4Address) {
                            v4Addresses.add(addr);
                            continue;
                        }
                        throw new UnknownHostException("Non-IPv4 address found via A record DNS lookup of host: " + hostname + ": " + addr.toString());
                    }
                }
            }
            catch (TextParseException e) {
                UnknownHostException ex = new UnknownHostException("Could not perform A record lookup for host: " + hostname);
                ex.initCause(e);
                throw ex;
            }
            ArrayList<InetAddress> v6Addresses = new ArrayList<InetAddress>();
            try {
                Record[] quadARecs = new Lookup(hostname, 28).run();
                if (quadARecs != null) {
                    for (Record quadARec : quadARecs) {
                        InetAddress addr = ((AAAARecord)quadARec).getAddress();
                        if (!(addr instanceof Inet6Address)) {
                            throw new UnknownHostException("Non-IPv6 address found via AAAA record DNS lookup of host: " + hostname + ": " + addr.toString());
                        }
                        v6Addresses.add(addr);
                    }
                }
            }
            catch (TextParseException e) {
                UnknownHostException ex = new UnknownHostException("Could not perform AAAA record lookup for host: " + hostname);
                ex.initCause(e);
                throw ex;
            }
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            if (preferInet6Address) {
                addresses.addAll(v6Addresses);
                addresses.addAll(v4Addresses);
            } else {
                addresses.addAll(v4Addresses);
                addresses.addAll(v6Addresses);
            }
            Iterator i$ = addresses.iterator();
            while (i$.hasNext()) {
                InetAddress address;
                retval = address = (InetAddress)i$.next();
                if ((preferInet6Address || !(retval instanceof Inet4Address)) && (!preferInet6Address || !(retval instanceof Inet6Address))) continue;
                break;
            }
            if (preferInet6Address && !(retval instanceof Inet6Address)) {
                throw new UnknownHostException("No IPv6 address could be found for the hostname: " + hostname);
            }
        }
        catch (UnknownHostException e) {
            if (throwException) {
                throw e;
            }
            return null;
        }
        return retval;
    }

    public static byte[] toIpAddrBytes(String dottedNotation) {
        return InetAddressUtils.getInetAddress(dottedNotation).getAddress();
    }

    public static String toIpAddrString(InetAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("Cannot convert null InetAddress to a string");
        }
        byte[] address = addr.getAddress();
        if (address == null) {
            throw new IllegalArgumentException("InetAddress instance violates contract by returning a null address from getAddress()");
        }
        if (addr instanceof Inet4Address) {
            return InetAddressUtils.toIpAddrString(address);
        }
        if (addr instanceof Inet6Address) {
            Inet6Address addr6 = (Inet6Address)addr;
            StringBuilder sb = new StringBuilder(InetAddressUtils.toIpAddrString(address));
            if (addr6.getScopeId() != 0) {
                sb.append("%").append(addr6.getScopeId());
            }
            return sb.toString();
        }
        throw new IllegalArgumentException("Unknown type of InetAddress: " + addr.getClass().getName());
    }

    public static String toIpAddrString(byte[] addr) {
        if (addr.length == 4) {
            return InetAddressUtils.getInetAddress(addr).getHostAddress();
        }
        if (addr.length == 16) {
            return String.format("%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x", addr[0], addr[1], addr[2], addr[3], addr[4], addr[5], addr[6], addr[7], addr[8], addr[9], addr[10], addr[11], addr[12], addr[13], addr[14], addr[15]).intern();
        }
        throw new IllegalArgumentException("IP address has an illegal number of bytes: " + addr.length);
    }

    public static InetAddress getLowestInetAddress(List<InetAddress> addresses) {
        byte[] originalBytes;
        if (addresses == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        InetAddress lowest = null;
        byte[] lowestBytes = originalBytes = InetAddressUtils.toIpAddrBytes("ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        ByteArrayComparator comparator = new ByteArrayComparator();
        for (InetAddress temp : addresses) {
            byte[] tempBytes = temp.getAddress();
            if (comparator.compare(tempBytes, lowestBytes) >= 0) continue;
            lowestBytes = tempBytes;
            lowest = temp;
        }
        return comparator.compare(originalBytes, lowestBytes) == 0 ? null : lowest;
    }

    public static BigInteger difference(String addr1, String addr2) {
        return InetAddressUtils.difference(InetAddressUtils.getInetAddress(addr1), InetAddressUtils.getInetAddress(addr2));
    }

    public static BigInteger difference(InetAddress addr1, InetAddress addr2) {
        return new BigInteger(1, addr1.getAddress()).subtract(new BigInteger(1, addr2.getAddress()));
    }

    public static boolean isInetAddressInRange(byte[] laddr, String beginString, String endString) {
        byte[] begin = InetAddressUtils.toIpAddrBytes(beginString);
        byte[] end = InetAddressUtils.toIpAddrBytes(endString);
        return InetAddressUtils.isInetAddressInRange(laddr, begin, end);
    }

    public static boolean isInetAddressInRange(String addrString, String beginString, String endString) {
        byte[] begin;
        ByteArrayComparator comparator = new ByteArrayComparator();
        byte[] addr = InetAddressUtils.toIpAddrBytes(addrString);
        if (comparator.compare(addr, begin = InetAddressUtils.toIpAddrBytes(beginString)) > 0) {
            byte[] end = InetAddressUtils.toIpAddrBytes(endString);
            return comparator.compare(addr, end) <= 0;
        }
        return comparator.compare(addr, begin) == 0;
    }

    public static boolean inSameScope(InetAddress addr1, InetAddress addr2) {
        if (addr1 instanceof Inet4Address) {
            return addr2 instanceof Inet4Address;
        }
        if (addr2 instanceof Inet4Address) {
            return false;
        }
        return new Integer(((Inet6Address)addr1).getScopeId()).compareTo(((Inet6Address)addr2).getScopeId()) == 0;
    }

    public static boolean isInetAddressInRange(byte[] addr, byte[] begin, byte[] end) {
        ByteArrayComparator comparator = new ByteArrayComparator();
        if (comparator.compare(addr, begin) > 0) {
            return comparator.compare(addr, end) <= 0;
        }
        return comparator.compare(addr, begin) == 0;
    }

    public static boolean isInetAddressInRange(String ipAddr, byte[] begin, byte[] end) {
        return InetAddressUtils.isInetAddressInRange(InetAddressUtils.toIpAddrBytes(ipAddr), begin, end);
    }

    public static InetAddress convertBigIntegerIntoInetAddress(BigInteger i) throws UnknownHostException {
        if (i.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("BigInteger is negative, cannot convert into an IP address: " + i.toString());
        }
        byte[] bytes = i.toByteArray();
        if (bytes.length == 0) {
            return InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
        }
        if (bytes.length <= 4) {
            byte[] addressBytes = new byte[4];
            int k = 3;
            int j = bytes.length - 1;
            while (j >= 0) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 5 && bytes[0] == 0) {
            byte[] addressBytes = new byte[4];
            int k = 3;
            int j = bytes.length - 1;
            while (j >= 1) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 16) {
            byte[] addressBytes = new byte[16];
            int k = 15;
            int j = bytes.length - 1;
            while (j >= 0) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 17 && bytes[0] == 0) {
            byte[] addressBytes = new byte[16];
            int k = 15;
            int j = bytes.length - 1;
            while (j >= 1) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        throw new IllegalArgumentException("BigInteger is too large to convert into an IP address: " + i.toString());
    }

    public static InetAddress addr(String ipAddrString) {
        return ipAddrString == null ? null : InetAddressUtils.getInetAddress(ipAddrString.trim());
    }

    public static String normalize(String ipAddrString) {
        return ipAddrString == null ? null : InetAddressUtils.toIpAddrString(InetAddressUtils.addr(ipAddrString.trim()));
    }

    public static String str(InetAddress addr) {
        return addr == null ? null : InetAddressUtils.toIpAddrString(addr);
    }

    public static BigInteger toInteger(InetAddress ipAddress) {
        return new BigInteger(1, ipAddress.getAddress());
    }

    public static String toOid(InetAddress addr) {
        if (addr == null) {
            return null;
        }
        if (addr instanceof Inet4Address) {
            return InetAddressUtils.str(addr);
        }
        if (addr instanceof Inet6Address) {
            byte[] buf = addr.getAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < buf.length; ++i) {
                sb.append(buf[i] & 0xFF);
                if (i == buf.length - 1) continue;
                sb.append(".");
            }
            return sb.toString();
        }
        LogUtils.debugf(InetAddressUtils.class, (String)"don't know how to handle %s", (Object[])new Object[]{addr});
        return null;
    }

    public static byte[] macAddressStringToBytes(String macAddress) {
        if (macAddress == null) {
            throw new IllegalArgumentException("Cannot decode null MAC address");
        }
        byte[] contents = new byte[6];
        String[] digits = macAddress.split(":");
        if (digits.length != 6) {
            if (macAddress.length() == 12) {
                digits = new String[]{macAddress.substring(0, 2), macAddress.substring(2, 4), macAddress.substring(4, 6), macAddress.substring(6, 8), macAddress.substring(8, 10), macAddress.substring(10)};
            } else {
                throw new IllegalArgumentException("Cannot decode MAC address: " + macAddress);
            }
        }
        for (int i = 0; i < 6; ++i) {
            contents[i] = Integer.decode("0x" + digits[i]).byteValue();
        }
        return contents;
    }

    public static String macAddressBytesToString(byte[] macAddress) {
        if (macAddress.length != 6) {
            throw new IllegalArgumentException("Cannot decode MAC address: " + macAddress);
        }
        return String.format("%02x%02x%02x%02x%02x%02x", macAddress[0], macAddress[1], macAddress[2], macAddress[3], macAddress[4], macAddress[5]);
    }

    public static String normalizeMacAddress(String macAddress) {
        return InetAddressUtils.macAddressBytesToString(InetAddressUtils.macAddressStringToBytes(macAddress));
    }

    static {
        try {
            UNPINGABLE_ADDRESS = InetAddress.getByAddress(new byte[]{-64, 0, 2, 123});
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
        try {
            UNPINGABLE_ADDRESS_IPV6 = InetAddress.getByName("fd25:28a0:ba2f:6b78:0000:0000:0000:0001");
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public static enum AddressType {
        IPv4,
        IPv6;

    }
}

