/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.concurrent;

public final class QuantumSemaphore {
    private final long m_lQuantum;
    private final long m_lMaxValue;
    private long m_lCurValue;
    private long m_lastReset;

    private long timeSinceReset() {
        long now = System.currentTimeMillis();
        return now - this.m_lastReset;
    }

    private void reset() {
        this.m_lCurValue = this.m_lMaxValue;
        this.m_lastReset = System.currentTimeMillis();
    }

    public QuantumSemaphore(long maxValue, long quantum) {
        this.m_lQuantum = quantum;
        this.m_lMaxValue = maxValue;
        this.m_lCurValue = maxValue;
        this.m_lastReset = System.currentTimeMillis();
    }

    public synchronized boolean acquire() throws InterruptedException {
        boolean bRC = false;
        long ms = this.m_lQuantum - this.timeSinceReset();
        if (ms < 0L) {
            this.reset();
        } else if (this.m_lCurValue == 0L && ms > 0L) {
            Thread.sleep(ms);
            this.reset();
        }
        if (this.m_lCurValue > 0L) {
            --this.m_lCurValue;
            bRC = true;
        }
        return bRC;
    }

    public long getMaxValue() {
        return this.m_lMaxValue;
    }
}

