/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.opennms.core.utils.ByteArrayComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InetAddressUtils {
    public static String incr(String address) throws UnknownHostException {
        return InetAddressUtils.toIpAddrString(InetAddressUtils.incr(InetAddressUtils.toIpAddrBytes(address)));
    }

    public static byte[] incr(byte[] address) throws UnknownHostException {
        BigInteger addr = new BigInteger(1, address);
        addr = addr.add(new BigInteger("1"));
        return InetAddressUtils.convertBigIntegerIntoInetAddress(addr).getAddress();
    }

    public static String decr(String address) throws UnknownHostException {
        return InetAddressUtils.toIpAddrString(InetAddressUtils.decr(InetAddressUtils.toIpAddrBytes(address)));
    }

    public static byte[] decr(byte[] address) throws UnknownHostException {
        BigInteger addr = new BigInteger(1, address);
        addr = addr.subtract(new BigInteger("1"));
        return InetAddressUtils.convertBigIntegerIntoInetAddress(addr).getAddress();
    }

    public static InetAddress getInetAddress(byte[] ipAddrOctets) {
        try {
            return InetAddress.getByAddress(ipAddrOctets);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IPAddress " + ipAddrOctets + " with length " + ipAddrOctets.length);
        }
    }

    public static InetAddress getInetAddress(String dottedNotation) {
        try {
            return InetAddress.getByName(dottedNotation);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IPAddress " + dottedNotation);
        }
    }

    public static byte[] toIpAddrBytes(String dottedNotation) {
        return InetAddressUtils.getInetAddress(dottedNotation).getAddress();
    }

    public static String toIpAddrString(InetAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("Cannot convert null InetAddress to a string");
        }
        byte[] address = addr.getAddress();
        if (address == null) {
            throw new IllegalArgumentException("InetAddress instance violates contract by returning a null address from getAddress()");
        }
        if (addr instanceof Inet4Address) {
            return InetAddressUtils.toIpAddrString(address);
        }
        if (addr instanceof Inet6Address) {
            Inet6Address addr6 = (Inet6Address)addr;
            if (addr6.getScopeId() == 0) {
                return InetAddressUtils.toIpAddrString(address);
            }
            return InetAddressUtils.toIpAddrString(address) + "%" + addr6.getScopeId();
        }
        throw new IllegalArgumentException("Unknown type of InetAddress: " + addr.getClass().getName());
    }

    public static String toIpAddrString(byte[] addr) {
        if (addr.length == 4) {
            return InetAddressUtils.getInetAddress(addr).getHostAddress();
        }
        if (addr.length == 16) {
            return String.format("%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x", addr[0], addr[1], addr[2], addr[3], addr[4], addr[5], addr[6], addr[7], addr[8], addr[9], addr[10], addr[11], addr[12], addr[13], addr[14], addr[15]);
        }
        throw new IllegalArgumentException("IP address has an illegal number of bytes: " + addr.length);
    }

    public static InetAddress getLowestInetAddress(List<InetAddress> addresses) {
        if (addresses == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        InetAddress lowest = null;
        byte[] lowestBytes = new byte[]{0, 0, 0, 0};
        ByteArrayComparator comparator = new ByteArrayComparator();
        for (InetAddress temp : addresses) {
            byte[] tempBytes = temp.getAddress();
            if (comparator.compare(tempBytes, lowestBytes) >= 0) continue;
            lowestBytes = tempBytes;
            lowest = temp;
        }
        return lowest;
    }

    public static BigInteger difference(String addr1, String addr2) {
        return new BigInteger(InetAddressUtils.getInetAddress(addr1).getAddress()).subtract(new BigInteger(InetAddressUtils.getInetAddress(addr2).getAddress()));
    }

    public static boolean isInetAddressInRange(String addrString, String beginString, String endString) {
        byte[] begin;
        ByteArrayComparator comparator = new ByteArrayComparator();
        byte[] addr = InetAddressUtils.toIpAddrBytes(addrString);
        if (comparator.compare(addr, begin = InetAddressUtils.toIpAddrBytes(beginString)) > 0) {
            byte[] end = InetAddressUtils.toIpAddrBytes(endString);
            return comparator.compare(addr, end) <= 0;
        }
        return comparator.compare(addr, begin) == 0;
    }

    public static boolean isInetAddressInRange(byte[] addr, byte[] begin, byte[] end) {
        ByteArrayComparator comparator = new ByteArrayComparator();
        if (comparator.compare(addr, begin) > 0) {
            return comparator.compare(addr, end) <= 0;
        }
        return comparator.compare(addr, begin) == 0;
    }

    public static InetAddress convertBigIntegerIntoInetAddress(BigInteger i) throws UnknownHostException {
        if (i.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("BigInteger is negative, cannot convert into an IP address: " + i.toString());
        }
        byte[] bytes = i.toByteArray();
        if (bytes.length == 0) {
            return InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
        }
        if (bytes.length <= 4) {
            byte[] addressBytes = new byte[4];
            int k = 3;
            int j = bytes.length - 1;
            while (j >= 0) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 5 && bytes[0] == 0) {
            byte[] addressBytes = new byte[4];
            int k = 3;
            int j = bytes.length - 1;
            while (j >= 1) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 16) {
            byte[] addressBytes = new byte[16];
            int k = 15;
            int j = bytes.length - 1;
            while (j >= 0) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        if (bytes.length <= 17 && bytes[0] == 0) {
            byte[] addressBytes = new byte[16];
            int k = 15;
            int j = bytes.length - 1;
            while (j >= 1) {
                addressBytes[k] = bytes[j];
                --j;
                --k;
            }
            return InetAddress.getByAddress(addressBytes);
        }
        throw new IllegalArgumentException("BigInteger is too large to convert into an IP address: " + i.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AddressType {
        IPv4,
        IPv6;

    }
}

