//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2002-2003 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified 
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
// 
// Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
//      OpenNMS Licensing       <license@opennms.org>
//      http://www.opennms.org/
//      http://www.opennms.com/
//
//
// Tab Size = 8
//
//

package org.opennms.core.queue;

/**
 * <p>
 * This interface is used to define a queue with <em>First
 * In, First Out</em>
 * semantics that has a maximum input size. The base interface class defines the
 * methods for preforming the first in, first out queue algorithm. This
 * interface is used to mark an implementation as having a maximum size in the
 * number of elements that can be added to the queue.
 * </p>
 *
 * <p>
 * Once the maximum size is reached it is up to the implementation to determine
 * if it should block the adding thread, or generate an exception.
 * </p>
 *
 * @author <a href="mailto:weave@oculan.com">Brian Weaver </a>
 * @author <a href="http://www.opennms.org/">OpenNMS </a>
 * @author <a href="mailto:weave@oculan.com">Brian Weaver </a>
 * @author <a href="http://www.opennms.org/">OpenNMS </a>
 * @version $Id: $
 */
public interface BoundedFifoQueue<T> extends FifoQueue<T> {
    /**
     * Returns the maximum number of elements that can be contained in the FIFO
     * queue.
     *
     * @return The maximum number of elements storable in the queue.
     */
    public int maxSize();

    /**
     * Returns true if the queue has reached the maximum number of elements it
     * can hold.
     *
     * @return True if the queue is at maximum capacity.
     */
    public boolean isFull();
}
