/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

public class IPLike {
    private IPLike() {
    }

    public static boolean matches(String address, String pattern) {
        String[] hostOctets = address.split("\\.", 0);
        String[] matchOctets = pattern.split("\\.", 0);
        for (int i = 0; i < 4; ++i) {
            if (IPLike.matchNumericListOrRange(hostOctets[i], matchOctets[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean matchNumericListOrRange(String value, String patterns) {
        String[] patternList;
        for (String element : patternList = patterns.split(",", 0)) {
            if (!IPLike.matchRange(value, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchRange(String value, String pattern) {
        int dashCount = IPLike.countChar('-', pattern);
        if ("*".equals(pattern)) {
            return true;
        }
        if (dashCount == 0) {
            return value.equals(pattern);
        }
        if (dashCount > 1) {
            return false;
        }
        if (dashCount == 1) {
            String[] ar = pattern.split("-");
            int rangeBegin = Integer.parseInt(ar[0]);
            int rangeEnd = Integer.parseInt(ar[1]);
            int ip = Integer.parseInt(value);
            return ip >= rangeBegin && ip <= rangeEnd;
        }
        return false;
    }

    public static int countChar(char charIn, String stingIn) {
        int charCount = 0;
        int charIndex = 0;
        for (int i = 0; i < stingIn.length(); ++i) {
            charIndex = stingIn.indexOf(charIn, i);
            if (charIndex == -1) continue;
            ++charCount;
            i = charIndex + 1;
        }
        return charCount;
    }
}

