/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpListFromUrl {
    private static final String COMMENT_STR = " #";
    private static final char COMMENT_CHAR = '#';

    public static List<String> parse(String url) {
        ArrayList<String> iplist = new ArrayList<String>();
        try {
            URL fileURL = new URL(url);
            InputStream file = fileURL.openStream();
            if (file != null) {
                BufferedReader buffer = new BufferedReader(new InputStreamReader(file));
                String ipLine = null;
                String specIP = null;
                while ((ipLine = buffer.readLine()) != null) {
                    if ((ipLine = ipLine.trim()).length() == 0 || ipLine.charAt(0) == '#') continue;
                    int comIndex = ipLine.indexOf(COMMENT_STR);
                    if (comIndex == -1) {
                        specIP = ipLine;
                    } else {
                        specIP = ipLine.substring(0, comIndex);
                        ipLine = ipLine.trim();
                    }
                    iplist.add(specIP);
                }
                buffer.close();
            } else {
                IpListFromUrl.log().warn((Object)("URL does not exist: " + url.toString()));
            }
        }
        catch (MalformedURLException e) {
            IpListFromUrl.log().error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        catch (FileNotFoundException e) {
            IpListFromUrl.log().error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        catch (IOException e) {
            IpListFromUrl.log().error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        return iplist;
    }

    private static Category log() {
        return ThreadCategory.getInstance(IpListFromUrl.class);
    }
}

