/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPSorter {
    static long byteToLong(byte b) {
        long r = b;
        if (r < 0L) {
            r += 256L;
        }
        return r;
    }

    public static long convertToLong(byte[] addr) {
        if (addr == null) {
            throw new IllegalArgumentException("The passed array must not be null");
        }
        long address = 0L;
        for (int i = 0; i < addr.length; ++i) {
            address <<= 8;
            address |= IPSorter.byteToLong(addr[i]);
        }
        return address;
    }

    public static long convertToLong(String ipAddressString) {
        long result = 0L;
        int octet = 0;
        byte[] buf = ipAddressString.getBytes();
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] == 46) {
                result = result << 8 | (long)octet;
                octet = 0;
                continue;
            }
            octet = octet * 10 + (buf[i] - 48);
        }
        return result << 8 | (long)octet;
    }

    public static InetAddress getLowestInetAddress(InetAddress[] addresses) {
        if (addresses == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return IPSorter.getLowestInetAddress(Arrays.asList(addresses));
    }

    public static InetAddress getLowestInetAddress(List<InetAddress> addresses) {
        if (addresses == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        InetAddress lowest = null;
        long lowestLong = Long.MAX_VALUE;
        for (InetAddress temp : addresses) {
            long tempLong = IPSorter.convertToLong(temp.getAddress());
            if (tempLong >= lowestLong) continue;
            lowestLong = tempLong;
            lowest = temp;
        }
        return lowest;
    }
}

