/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteringIterator<T>
implements Iterator<T>,
Iterable<T> {
    private PeekableIterator<T> m_it;

    public FilteringIterator(Iterable<T> iterable) {
        this(iterable.iterator());
    }

    public FilteringIterator(Iterator<T> iterator) {
        this.m_it = new PeekableIterator<T>(iterator);
    }

    @Override
    public boolean hasNext() {
        this.skipNonMatching();
        return this.m_it.hasNext();
    }

    private void skipNonMatching() {
        while (this.m_it.hasNext() && !this.matches(this.m_it.peek())) {
            this.m_it.next();
        }
    }

    protected abstract boolean matches(T var1);

    @Override
    public T next() {
        this.skipNonMatching();
        return this.m_it.next();
    }

    @Override
    public void remove() {
        this.m_it.remove();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PeekableIterator<T>
    implements Iterator<T> {
        Iterator<T> m_it;
        T m_peeked = null;

        public PeekableIterator(Iterator<T> it) {
            this.m_it = it;
        }

        @Override
        public boolean hasNext() {
            return this.m_peeked != null || this.m_it.hasNext();
        }

        @Override
        public T next() {
            if (this.m_peeked != null) {
                T next = this.m_peeked;
                this.m_peeked = null;
                return next;
            }
            return this.m_it.next();
        }

        public T peek() {
            if (this.m_peeked == null && this.m_it.hasNext()) {
                this.m_peeked = this.m_it.next();
            }
            return this.m_peeked;
        }

        @Override
        public void remove() {
            this.m_it.remove();
        }
    }
}

