/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opennms.core.utils.IteratorIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcSet<E>
extends AbstractSet<E> {
    LinkedHashSet<E> m_added = new LinkedHashSet();
    LinkedHashSet<E> m_entries = new LinkedHashSet();
    LinkedHashSet<E> m_removed = new LinkedHashSet();

    public JdbcSet(Collection<E> c) {
        this.m_entries.addAll(c);
    }

    public JdbcSet() {
    }

    protected void setElements(Collection<E> c) {
        this.m_entries.addAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return new JdbcSetIterator(this.m_entries.iterator(), this.m_added.iterator());
    }

    @Override
    public int size() {
        return this.m_added.size() + this.m_entries.size();
    }

    @Override
    public boolean add(E o) {
        if (this.contains(o)) {
            return false;
        }
        this.m_added.add(o);
        return true;
    }

    public Set<E> getRemoved() {
        return this.m_removed;
    }

    public Set<E> getAdded() {
        return this.m_added;
    }

    public Set<E> getRemaining() {
        return this.m_entries;
    }

    public void reset() {
        this.m_entries.addAll(this.m_added);
        this.m_added.clear();
        this.m_removed.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JdbcSetIterator
    extends IteratorIterator<E> {
        private E m_last;

        public JdbcSetIterator(Iterator<E> entriesIter, Iterator<E> addedIter) {
            super(entriesIter, addedIter);
        }

        @Override
        public E next() {
            this.m_last = super.next();
            return this.m_last;
        }

        @Override
        public void remove() {
            JdbcSet.this.m_removed.add(this.m_last);
            super.remove();
        }
    }
}

