/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.log4j.Category;
import org.opennms.core.utils.JavaMailerConfig;
import org.opennms.core.utils.JavaMailerException;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.ThreadCategory;
import org.springframework.util.StringUtils;

public class JavaMailer {
    private static final String DEFAULT_FROM_ADDRESS = "root@[127.0.0.1]";
    private static final String DEFAULT_MAIL_HOST = "127.0.0.1";
    private static final boolean DEFAULT_AUTHENTICATE = false;
    private static final String DEFAULT_AUTHENTICATE_USER = "opennms";
    private static final String DEFAULT_AUTHENTICATE_PASSWORD = "opennms";
    private static final String DEFAULT_MAILER = "smtpsend";
    private static final String DEFAULT_TRANSPORT = "smtp";
    private static final boolean DEFAULT_MAILER_DEBUG = true;
    private static final boolean DEFAULT_USE_JMTA = true;
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private static final String DEFAULT_CHARSET = "us-ascii";
    private static final String DEFAULT_ENCODING = "7-bit";
    private static final boolean DEFAULT_STARTTLS_ENABLE = false;
    private static final boolean DEFAULT_QUIT_WAIT = true;
    private static final int DEFAULT_SMTP_PORT = 25;
    private static final boolean DEFAULT_SMTP_SSL_ENABLE = false;
    private Session m_session = null;
    private Properties m_mailProps;
    private boolean m_debug;
    private String m_mailHost;
    private boolean m_useJMTA;
    private String m_mailer;
    private String m_transport;
    private String m_from;
    private boolean m_authenticate;
    private String m_user;
    private String m_password;
    private String m_contentType;
    private String m_charSet;
    private String m_encoding;
    private boolean m_startTlsEnabled;
    private boolean m_quitWait;
    private int m_smtpPort;
    private boolean m_smtpSsl;
    private String m_to;
    private String m_subject;
    private String m_messageText;
    private String m_fileName;

    public JavaMailer(Properties javamailProps) throws JavaMailerException {
        try {
            this.configureProperties(javamailProps);
        }
        catch (IOException e) {
            throw new JavaMailerException("Failed to construct mailer", e);
        }
        this.m_session = Session.getInstance((Properties)this.getMailProps(), (Authenticator)this.createAuthenticator());
    }

    public JavaMailer() throws JavaMailerException {
        this(new Properties());
    }

    private void configureProperties(Properties javamailProps) throws IOException {
        this.m_mailProps = JavaMailerConfig.getProperties();
        this.m_mailProps.putAll((Map<?, ?>)javamailProps);
        this.m_debug = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.debug", true);
        this.m_mailHost = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.mailHost", DEFAULT_MAIL_HOST);
        this.m_useJMTA = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.useJMTA", true);
        this.m_mailer = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.mailer", DEFAULT_MAILER);
        this.m_transport = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.transport", DEFAULT_TRANSPORT);
        this.m_from = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.fromAddress", DEFAULT_FROM_ADDRESS);
        this.m_authenticate = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.authenticate", false);
        this.m_user = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.authenticateUser", "opennms");
        this.m_password = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.authenticatePassword", "opennms");
        this.m_contentType = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.messageContentType", DEFAULT_CONTENT_TYPE);
        this.m_charSet = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.charset", DEFAULT_CHARSET);
        this.m_encoding = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.encoding", DEFAULT_ENCODING);
        this.m_startTlsEnabled = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.starttls.enable", false);
        this.m_quitWait = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.quitwait", true);
        this.m_smtpPort = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.smtpport", 25);
        this.m_smtpSsl = PropertiesUtils.getProperty(this.m_mailProps, "org.opennms.core.utils.smtpssl.enable", false);
        if (!this.m_mailProps.containsKey("mail.smtp.auth")) {
            this.m_mailProps.setProperty("mail.smtp.auth", String.valueOf(this.isAuthenticate()));
        }
        if (!this.m_mailProps.containsKey("mail.smtp.starttls.enable")) {
            this.m_mailProps.setProperty("mail.smtp.starttls.enable", String.valueOf(this.isStartTlsEnabled()));
        }
        if (!this.m_mailProps.containsKey("mail.smtp.quitwait")) {
            this.m_mailProps.setProperty("mail.smtp.quitwait", String.valueOf(this.isQuitWait()));
        }
        if (!this.m_mailProps.containsKey("mail.smtp.port")) {
            this.m_mailProps.setProperty("mail.smtp.port", String.valueOf(this.getSmtpPort()));
        }
        if (this.isSmtpSsl()) {
            if (!this.m_mailProps.containsKey("mail.smtps.auth")) {
                this.m_mailProps.setProperty("mail.smtps.auth", String.valueOf(this.isAuthenticate()));
            }
            if (!this.m_mailProps.containsKey("mail.smtps.socketFactory.class")) {
                this.m_mailProps.setProperty("mail.smtps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            if (!this.m_mailProps.containsKey("mail.smtps.socketFactory.port")) {
                this.m_mailProps.setProperty("mail.smtps.socketFactory.port", String.valueOf(this.getSmtpPort()));
            }
        }
        if (!this.m_mailProps.containsKey("mail.smtp.quitwait")) {
            this.m_mailProps.setProperty("mail.smtp.quitwait", "true");
        }
    }

    public void mailSend() throws JavaMailerException {
        this.log().debug((Object)this.createSendLogMsg());
        this.sendMessage(this.buildMessage());
    }

    public Authenticator createAuthenticator() {
        Authenticator auth = this.isAuthenticate() ? new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(JavaMailer.this.getUser(), JavaMailer.this.getPassword());
            }
        } : null;
        return auth;
    }

    public Message buildMessage() throws JavaMailerException {
        try {
            this.checkEnvelopeAndContents();
            Message message = this.initializeMessage();
            String encodedText = MimeUtility.encodeText((String)this.getMessageText(), (String)this.m_charSet, (String)this.m_encoding);
            if (this.getFileName() == null) {
                message.setContent((Object)encodedText, this.m_contentType + "; charset=" + this.m_charSet);
            } else {
                MimeBodyPart bp = new MimeBodyPart();
                bp.setContent((Object)encodedText, this.m_contentType + "; charset=" + this.m_charSet);
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)bp);
                mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)this.createFileAttachment(new File(this.getFileName())));
                message.setContent((Multipart)mp);
            }
            message.setHeader("X-Mailer", this.getMailer());
            message.setSentDate(new Date());
            message.saveChanges();
            return message;
        }
        catch (AddressException e) {
            this.log().error((Object)"Java Mailer Addressing exception: ", (Throwable)e);
            throw new JavaMailerException("Java Mailer Addressing exception: ", e);
        }
        catch (MessagingException e) {
            this.log().error((Object)"Java Mailer messaging exception: ", (Throwable)e);
            throw new JavaMailerException("Java Mailer messaging exception: ", e);
        }
        catch (UnsupportedEncodingException e) {
            this.log().error((Object)"Java Mailer messaging exception: ", (Throwable)e);
            throw new JavaMailerException("Java Mailer encoding exception: ", e);
        }
    }

    private Message initializeMessage() throws MessagingException, AddressException {
        MimeMessage message = new MimeMessage(this.getSession());
        message.setFrom((Address)new InternetAddress(this.getFrom()));
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.getTo(), (boolean)false));
        message.setSubject(this.getSubject());
        return message;
    }

    private String createSendLogMsg() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\tTo: ");
        sb.append(this.getTo());
        sb.append("\n\tFrom: ");
        sb.append(this.getFrom());
        sb.append("\n\tSubject is: ");
        sb.append(this.getSubject());
        sb.append("\n\tFile: ");
        sb.append(this.getFileName() != null ? this.getFileName() : "no file attached");
        sb.append("\n\n");
        sb.append(this.getMessageText());
        sb.append("\n");
        return sb.toString();
    }

    public MimeBodyPart createFileAttachment(File file) throws MessagingException, JavaMailerException {
        if (!file.exists()) {
            this.log().error((Object)("File attachment '" + file.getAbsolutePath() + "' does not exist."));
            throw new JavaMailerException("File attachment '" + file.getAbsolutePath() + "' does not exist.");
        }
        if (!file.canRead()) {
            this.log().error((Object)("File attachment '" + file.getAbsolutePath() + "' is not readable."));
            throw new JavaMailerException("File attachment '" + file.getAbsolutePath() + "' is not readable.");
        }
        MimeBodyPart bodyPart = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(file);
        bodyPart.setDataHandler(new DataHandler((DataSource)fds));
        bodyPart.setFileName(fds.getName());
        return bodyPart;
    }

    private void checkEnvelopeAndContents() throws JavaMailerException {
        if (this.getFrom() == null) {
            throw new JavaMailerException("Cannot have a null from address.");
        }
        if ("".equals(this.getFrom())) {
            throw new JavaMailerException("Cannot have an empty from address.");
        }
        if (this.getTo() == null) {
            throw new JavaMailerException("Cannot have a null to address.");
        }
        if ("".equals(this.getTo())) {
            throw new JavaMailerException("Cannot have an empty to address.");
        }
        if (this.getSubject() == null) {
            throw new JavaMailerException("Cannot have a null subject.");
        }
        if ("".equals(this.getSubject())) {
            throw new JavaMailerException("Cannot have an empty subject.");
        }
        if (this.getMessageText() == null) {
            throw new JavaMailerException("Cannot have a null messageText.");
        }
        if ("".equals(this.getMessageText())) {
            throw new JavaMailerException("Cannot have an empty messageText.");
        }
    }

    public void sendMessage(Message message) throws JavaMailerException {
        Transport t = null;
        try {
            t = this.getSession().getTransport(this.getTransport());
            this.log().debug((Object)("for transport name '" + this.getTransport() + "' got: " + t.getClass().getName() + "@" + Integer.toHexString(t.hashCode())));
            LoggingTransportListener listener = new LoggingTransportListener(this.log());
            t.addTransportListener((TransportListener)listener);
            if (t.getURLName().getProtocol().equals("mta")) {
                this.log().debug((Object)"transport is 'mta', not trying to connect()");
            } else if (this.isAuthenticate()) {
                this.log().debug((Object)("authenticating to " + this.getMailHost()));
                t.connect(this.getMailHost(), this.getSmtpPort(), this.getUser(), this.getPassword());
            } else {
                this.log().debug((Object)("not authenticating to " + this.getMailHost()));
                t.connect(this.getMailHost(), this.getSmtpPort(), null, null);
            }
            t.sendMessage(message, message.getAllRecipients());
            listener.assertAllMessagesDelivered();
        }
        catch (NoSuchProviderException e) {
            this.log().error((Object)("Couldn't get a transport: " + (Object)((Object)e)), (Throwable)e);
            throw new JavaMailerException("Couldn't get a transport: " + (Object)((Object)e), e);
        }
        catch (MessagingException e) {
            this.log().error((Object)("Java Mailer messaging exception: " + (Object)((Object)e)), (Throwable)e);
            throw new JavaMailerException("Java Mailer messaging exception: " + (Object)((Object)e), e);
        }
        finally {
            try {
                if (t != null && t.isConnected()) {
                    t.close();
                }
            }
            catch (MessagingException e) {
                throw new JavaMailerException("Java Mailer messaging exception on transport close: " + (Object)((Object)e), e);
            }
        }
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public boolean isUseJMTA() {
        return this.m_useJMTA;
    }

    public void setUseJMTA(boolean useMTA) {
        this.m_useJMTA = useMTA;
    }

    public String getFrom() {
        return this.m_from;
    }

    public void setFrom(String from) {
        this.m_from = from;
    }

    public boolean isAuthenticate() {
        return this.m_authenticate;
    }

    public void setAuthenticate(boolean authenticate) {
        this.m_authenticate = authenticate;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getMailHost() {
        return this.m_mailHost;
    }

    public void setMailHost(String mail_host) {
        this.m_mailHost = mail_host;
    }

    public String getMailer() {
        return this.m_mailer;
    }

    public void setMailer(String mailer) {
        this.m_mailer = mailer;
    }

    public String getMessageText() {
        return this.m_messageText;
    }

    public void setMessageText(String messageText) {
        this.m_messageText = messageText;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    public String getTo() {
        return this.m_to;
    }

    public void setTo(String to) {
        this.m_to = to;
    }

    public String getTransport() {
        if (this.isUseJMTA()) {
            return "mta";
        }
        return this.m_transport;
    }

    public void setTransport(String transport) {
        this.m_transport = transport;
    }

    public boolean isDebug() {
        return this.m_debug;
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
        if (this.isDebug()) {
            this.m_session.setDebugOut(new PrintStream(new LoggingByteArrayOutputStream(this.log()), true));
        }
        this.m_session.setDebug(this.isDebug());
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public Session getSession() {
        return this.m_session;
    }

    public void setSession(Session session) {
        this.m_session = session;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public void setContentType(String contentType) {
        this.m_contentType = contentType;
    }

    public String getCharSet() {
        return this.m_charSet;
    }

    public void setCharSet(String charSet) {
        this.m_charSet = charSet;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    public boolean isStartTlsEnabled() {
        return this.m_startTlsEnabled;
    }

    public void setStartTlsEnabled(boolean startTlsEnabled) {
        this.m_startTlsEnabled = startTlsEnabled;
    }

    public boolean isQuitWait() {
        return this.m_quitWait;
    }

    public void setQuitWait(boolean quitWait) {
        this.m_quitWait = quitWait;
    }

    public int getSmtpPort() {
        return this.m_smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.m_smtpPort = smtpPort;
    }

    public boolean isSmtpSsl() {
        return this.m_smtpSsl;
    }

    public void setSmtpSsl(boolean smtpSsl) {
        this.m_smtpSsl = smtpSsl;
    }

    public Properties getMailProps() {
        return this.m_mailProps;
    }

    public static class LoggingTransportListener
    implements TransportListener {
        private Category m_category;
        private List<Address> m_invalidAddresses = new ArrayList<Address>();
        private List<Address> m_validSentAddresses = new ArrayList<Address>();
        private List<Address> m_validUnsentAddresses = new ArrayList<Address>();

        public LoggingTransportListener(Category category) {
            this.m_category = category;
        }

        public void messageDelivered(TransportEvent event) {
            this.logEvent("message delivered", event);
        }

        public void messageNotDelivered(TransportEvent event) {
            this.logEvent("message not delivered", event);
        }

        public void messagePartiallyDelivered(TransportEvent event) {
            this.logEvent("message partially delivered", event);
        }

        private void logEvent(String message, TransportEvent event) {
            if (event.getInvalidAddresses() != null && event.getInvalidAddresses().length > 0) {
                this.m_invalidAddresses.addAll(Arrays.asList(event.getInvalidAddresses()));
                this.m_category.error((Object)(message + ": invalid addresses: " + StringUtils.arrayToDelimitedString((Object[])event.getInvalidAddresses(), (String)", ")));
            }
            if (event.getValidSentAddresses() != null && event.getValidSentAddresses().length > 0) {
                this.m_validSentAddresses.addAll(Arrays.asList(event.getValidSentAddresses()));
                this.m_category.debug((Object)(message + ": valid sent addresses: " + StringUtils.arrayToDelimitedString((Object[])event.getValidSentAddresses(), (String)", ")));
            }
            if (event.getValidUnsentAddresses() != null && event.getValidUnsentAddresses().length > 0) {
                this.m_validUnsentAddresses.addAll(Arrays.asList(event.getValidUnsentAddresses()));
                this.m_category.error((Object)(message + ": valid unsent addresses: " + StringUtils.arrayToDelimitedString((Object[])event.getValidUnsentAddresses(), (String)", ")));
            }
        }

        public boolean hasAnythingBeenReceived() {
            return this.m_invalidAddresses.size() != 0 || this.m_validSentAddresses.size() != 0 || this.m_validUnsentAddresses.size() != 0;
        }

        public void assertAllMessagesDelivered() throws JavaMailerException {
            for (int i = 0; i < 10 && !this.hasAnythingBeenReceived(); ++i) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_invalidAddresses.size() == 0 && this.m_validUnsentAddresses.size() == 0) {
                return;
            }
            throw new JavaMailerException("Not all messages delivered:\n\t" + this.m_validSentAddresses.size() + " messages were sent to valid addresses: " + StringUtils.collectionToDelimitedString(this.m_validSentAddresses, (String)", ") + "\n" + "\t" + this.m_validUnsentAddresses.size() + " messages were not sent to valid addresses: " + StringUtils.collectionToDelimitedString(this.m_validUnsentAddresses, (String)", ") + "\n" + "\t" + this.m_invalidAddresses.size() + " messages had invalid addresses: " + StringUtils.collectionToDelimitedString(this.m_invalidAddresses, (String)", "));
        }
    }

    public static class LoggingByteArrayOutputStream
    extends ByteArrayOutputStream {
        private Category m_category;

        public LoggingByteArrayOutputStream(Category category) {
            this.m_category = category;
        }

        public void flush() throws IOException {
            super.flush();
            String buffer = this.toString().replaceAll("\n", "");
            if (buffer.length() > 0) {
                this.m_category.debug((Object)buffer);
            }
            this.reset();
        }
    }
}

