/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionMath {
    public static long countNull(List list) {
        long count = 0L;
        for (Object entry : list) {
            if (entry != null) continue;
            ++count;
        }
        return count;
    }

    public static long countNotNull(List list) {
        return (long)list.size() - CollectionMath.countNull(list);
    }

    public static Number percentNull(List<? extends Number> list) {
        return CollectionMath.percentNullBigDecimal(CollectionMath.convertNumberToBigDecimal(list));
    }

    private static BigDecimal percentNullBigDecimal(List<BigDecimal> list) {
        if (list.size() > 0) {
            return new BigDecimal(CollectionMath.countNull(list)).divide(new BigDecimal(list.size()), 16, 6).multiply(new BigDecimal(100));
        }
        return null;
    }

    public static Number percentNotNull(List<? extends Number> list) {
        return CollectionMath.percentNotNullBigDecimal(CollectionMath.convertNumberToBigDecimal(list));
    }

    private static BigDecimal percentNotNullBigDecimal(List<BigDecimal> list) {
        if (list.size() > 0) {
            return new BigDecimal(CollectionMath.countNotNull(list)).divide(new BigDecimal(list.size()), 16, 6).multiply(new BigDecimal(100));
        }
        return null;
    }

    public static Number average(List<? extends Number> list) {
        return CollectionMath.averageBigDecimal(CollectionMath.convertNumberToBigDecimal(list));
    }

    private static BigDecimal averageBigDecimal(List<BigDecimal> list) {
        BigDecimal total = new BigDecimal(0);
        List<BigDecimal> notNullEntries = CollectionMath.getNotNullEntries(list);
        if (notNullEntries.size() == 0) {
            return null;
        }
        for (BigDecimal entry : notNullEntries) {
            total = total.add(entry);
        }
        return total.divide(new BigDecimal(notNullEntries.size()), 16, 6);
    }

    public static Number median(List<? extends Number> list) {
        return CollectionMath.medianBigDecimal(CollectionMath.convertNumberToBigDecimal(list));
    }

    private static BigDecimal medianBigDecimal(List<BigDecimal> list) {
        List<BigDecimal> notNullEntries = CollectionMath.getNotNullEntries(list);
        Collections.sort(notNullEntries);
        if (notNullEntries.size() == 0) {
            return null;
        }
        if (notNullEntries.size() % 2 == 0) {
            BigDecimal value1 = notNullEntries.get(notNullEntries.size() / 2);
            BigDecimal value2 = notNullEntries.get(notNullEntries.size() / 2 - 1);
            return value1.add(value2).divide(new BigDecimal(2), 16, 6);
        }
        return notNullEntries.get(notNullEntries.size() / 2);
    }

    private static List<BigDecimal> convertNumberToBigDecimal(List<? extends Number> c) {
        ArrayList<BigDecimal> bd = new ArrayList<BigDecimal>();
        for (Number number : c) {
            if (number != null) {
                bd.add(new BigDecimal(number.doubleValue()));
                continue;
            }
            bd.add(null);
        }
        return bd;
    }

    private static List<BigDecimal> getNotNullEntries(List<BigDecimal> list) {
        ArrayList<BigDecimal> s = new ArrayList<BigDecimal>();
        for (BigDecimal entry : list) {
            if (entry == null) continue;
            s.add(entry);
        }
        return s;
    }
}

