/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;

public class Vault {
    protected static Properties properties = new Properties(System.getProperties());
    protected static String homeDir = "/opt/opennms/";
    private static DataSource s_dataSource;

    private Vault() {
    }

    public static void setDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        s_dataSource = dataSource;
    }

    public static DataSource getDataSource() throws SQLException {
        if (s_dataSource == null) {
            throw new IllegalStateException("You must set a DataSource before requesting a data source.");
        }
        return s_dataSource;
    }

    public static Connection getDbConnection() throws SQLException {
        if (s_dataSource == null) {
            throw new IllegalStateException("You must set a DataSource before requesting a database connection.");
        }
        return s_dataSource.getConnection();
    }

    public static void releaseDbConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public static void setProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Vault.properties = properties;
        Enumeration<Object> keys = properties.keys();
        Properties sysProps = System.getProperties();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            sysProps.put(key, properties.get(key));
        }
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static void setHomeDir(String homeDir) {
        if (homeDir == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Vault.homeDir = homeDir;
        properties.setProperty("opennms.home", homeDir);
        System.setProperty("opennms.home", homeDir);
    }

    public static String getHomeDir() {
        return homeDir;
    }

    public static boolean supplementSystemPropertiesFromKey(String key) {
        boolean loadedOK = true;
        String path = System.getProperty(key);
        if (path != null) {
            StringTokenizer files = new StringTokenizer(path, File.pathSeparator);
            while (files.hasMoreTokens()) {
                try {
                    File pfile = new File(files.nextToken());
                    if (!pfile.exists() || !pfile.isFile()) continue;
                    Properties p = new Properties();
                    FileInputStream is = new FileInputStream(pfile);
                    try {
                        p.load(is);
                    }
                    catch (IOException ioE) {
                        throw ioE;
                    }
                    finally {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException ioE) {}
                    }
                    for (Map.Entry<Object, Object> e : p.entrySet()) {
                        if (System.getProperty((String)e.getKey()) != null) continue;
                        System.setProperty((String)e.getKey(), (String)e.getValue());
                    }
                }
                catch (IOException ioE) {
                    loadedOK = false;
                }
            }
        }
        return loadedOK;
    }
}

