/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.resource.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.opennms.core.resource.db.DbConnectionFactory;

public class SimpleDbConnectionFactory
implements DbConnectionFactory {
    protected String url = null;
    protected String username = null;
    protected String password = null;
    protected Properties properties = null;

    public void init(String dbUrl, String dbDriver, String username, String password) throws ClassNotFoundException, SQLException {
        if (dbUrl == null || dbDriver == null || username == null || password == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Class.forName(dbDriver);
        this.url = dbUrl;
        this.username = username;
        this.password = password;
    }

    public void destroy() {
        this.url = null;
        this.username = null;
        this.password = null;
        this.properties = null;
    }

    public Connection getConnection() throws SQLException {
        if (this.url == null) {
            throw new IllegalArgumentException("This database factory has not been initialized or has been destroyed.");
        }
        Connection connection = null;
        connection = this.properties != null ? DriverManager.getConnection(this.url, this.properties) : (this.username != null && this.password != null ? DriverManager.getConnection(this.url, this.username, this.password) : DriverManager.getConnection(this.url));
        return connection;
    }

    public void releaseConnection(Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        connection.close();
    }
}

