/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class StringUtils {
    static final boolean s_headless = Boolean.getBoolean("java.awt.headless");
    static final Pattern s_windowsDrive = Pattern.compile("^[A-Za-z]\\:\\\\");

    public static String[] createCommandArray(String s, char delim) {
        if (s == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (s.indexOf(delim) != -1) {
            throw new IllegalArgumentException("String parameter cannot already contain delimiter character: " + delim);
        }
        char[] chars = s.toCharArray();
        boolean inquote = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\"') {
                inquote = !inquote;
                continue;
            }
            if (inquote && chars[i] == ' ') {
                buffer.append(delim);
                continue;
            }
            buffer.append(chars[i]);
        }
        s = buffer.toString();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(s);
        while (tokenizer.hasMoreTokens()) {
            arrayList.add(tokenizer.nextElement().toString());
        }
        String[] list = arrayList.toArray(new String[arrayList.size()]);
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].replace(delim, ' ');
        }
        return list;
    }

    public static String truncate(String name, int length) {
        if (name.length() <= length) {
            return name;
        }
        return name.substring(0, length);
    }

    public static boolean isLocalWindowsPath(String path) {
        if (File.separatorChar != '\\') {
            return false;
        }
        if (path.length() < 3) {
            return false;
        }
        char colon = path.charAt(1);
        char slash = path.charAt(2);
        if (colon != ':') {
            return false;
        }
        if (slash != '\\' && slash != '/') {
            return false;
        }
        String drive = path.substring(0, 3);
        if (s_headless) {
            return s_windowsDrive.matcher(drive).matches();
        }
        File file = new File(drive);
        return FileSystemView.getFileSystemView().isFileSystemRoot(file);
    }

    public static String prettyXml(String xml) throws UnsupportedEncodingException, TransformerException {
        StringWriter out = new StringWriter();
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult result = new StreamResult(out);
        StreamSource source = new StreamSource(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        transformer.transform(source, result);
        return out.toString().trim();
    }
}

