/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileSystemView;

public class StringUtils {
    public static String[] createCommandArray(String s, char delim) {
        if (s == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (s.indexOf(delim) != -1) {
            throw new IllegalArgumentException("String parameter cannot already contain delimiter character: " + delim);
        }
        char[] chars = s.toCharArray();
        boolean inquote = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\"') {
                inquote = !inquote;
                continue;
            }
            if (inquote && chars[i] == ' ') {
                buffer.append(delim);
                continue;
            }
            buffer.append(chars[i]);
        }
        s = buffer.toString();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(s);
        while (tokenizer.hasMoreTokens()) {
            arrayList.add(tokenizer.nextElement().toString());
        }
        String[] list = arrayList.toArray(new String[arrayList.size()]);
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].replace(delim, ' ');
        }
        return list;
    }

    public static String truncate(String name, int length) {
        if (name.length() <= length) {
            return name;
        }
        return name.substring(0, length);
    }

    public static boolean isLocalWindowsPath(String path) {
        if (File.separatorChar != '\\') {
            return false;
        }
        if (path.length() < 3) {
            return false;
        }
        char colon = path.charAt(1);
        char slash = path.charAt(2);
        if (colon != ':') {
            return false;
        }
        if (slash != '\\' && slash != '/') {
            return false;
        }
        File file = new File(path.substring(0, 3));
        System.err.println("file = " + file);
        return FileSystemView.getFileSystemView().isFileSystemRoot(file);
    }
}

