/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.queue;

import java.util.Deque;
import java.util.LinkedList;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;

public class FifoQueueImpl<T>
implements FifoQueue<T> {
    private final Deque<T> m_delegate = new LinkedList<T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(T element) throws FifoQueueException, InterruptedException {
        Deque<T> deque = this.m_delegate;
        synchronized (deque) {
            this.m_delegate.addLast(element);
            this.m_delegate.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T element, long timeout) throws FifoQueueException, InterruptedException {
        Deque<T> deque = this.m_delegate;
        synchronized (deque) {
            this.m_delegate.addLast(element);
            this.m_delegate.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove() throws FifoQueueException, InterruptedException {
        Deque<T> deque = this.m_delegate;
        synchronized (deque) {
            while (this.m_delegate.isEmpty()) {
                this.m_delegate.wait();
            }
            return this.m_delegate.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(long timeout) throws FifoQueueException, InterruptedException {
        T rval = null;
        Deque<T> deque = this.m_delegate;
        synchronized (deque) {
            if (this.m_delegate.isEmpty()) {
                long start = System.currentTimeMillis();
                long diff = 0L;
                do {
                    this.m_delegate.wait(timeout - diff);
                } while ((diff = System.currentTimeMillis() - start) < timeout && this.m_delegate.isEmpty());
            }
            if (!this.m_delegate.isEmpty()) {
                rval = this.m_delegate.removeFirst();
            }
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Deque<T> deque = this.m_delegate;
        synchronized (deque) {
            return this.m_delegate.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Deque<T> deque = this.m_delegate;
        synchronized (deque) {
            return this.m_delegate.isEmpty();
        }
    }
}

