/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationTestUtils
extends Assert {
    private static final String POM_FILE = "pom.xml";
    private static final String DAEMON_DIRECTORY = "opennms-daemon";

    public static URL getUrlForResource(Object obj, String resource) {
        URL url = ConfigurationTestUtils.getClass(obj).getResource(resource);
        ConfigurationTestUtils.assertNotNull((String)("could not get resource '" + resource + "' as a URL"), (Object)url);
        return url;
    }

    private static Class<? extends Object> getClass(Object obj) {
        return obj != null ? obj.getClass() : ConfigurationTestUtils.class.getClass();
    }

    public static File getFileForResource(Object obj, String resource) {
        URL url = ConfigurationTestUtils.getUrlForResource(obj, resource);
        String path = url.getFile();
        ConfigurationTestUtils.assertNotNull((String)("could not get resource '" + resource + "' as a file"), (Object)path);
        File file = new File(path);
        ConfigurationTestUtils.assertTrue((String)("could not get resource '" + resource + "' as a file--the file at path '" + path + "' does not exist"), (boolean)file.exists());
        return file;
    }

    public static Reader getReaderForResource(Object obj, String resource) {
        return new InputStreamReader(ConfigurationTestUtils.getInputStreamForResource(obj, resource));
    }

    public static InputStream getInputStreamForResource(Object obj, String resource) {
        ConfigurationTestUtils.assertFalse((String)"obj should not be an instance of java.lang.Class; you usually want to use 'this'", (boolean)(obj instanceof Class));
        InputStream is = ConfigurationTestUtils.getClass(obj).getResourceAsStream(resource);
        ConfigurationTestUtils.assertNotNull((String)("could not get resource '" + resource + "' as an input stream"), (Object)is);
        return is;
    }

    public static Reader getReaderForResourceWithReplacements(Object obj, String resource, String[] ... replacements) throws IOException {
        String newConfig = ConfigurationTestUtils.getConfigForResourceWithReplacements(obj, resource, replacements);
        return new StringReader(newConfig);
    }

    public static InputStream getInputStreamForResourceWithReplacements(Object obj, String resource, String[] ... replacements) throws IOException {
        String newConfig = ConfigurationTestUtils.getConfigForResourceWithReplacements(obj, resource, replacements);
        return new ByteArrayInputStream(newConfig.getBytes());
    }

    public static String getConfigForResourceWithReplacements(Object obj, String resource, String[] ... replacements) throws IOException {
        String line;
        Reader inputReader = ConfigurationTestUtils.getReaderForResource(obj, resource);
        BufferedReader bufferedReader = new BufferedReader(inputReader);
        StringBuffer buffer = new StringBuffer();
        while ((line = bufferedReader.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        String newConfig = buffer.toString();
        for (String[] replacement : replacements) {
            newConfig = newConfig.replaceAll(replacement[0], replacement[1]);
        }
        return newConfig;
    }

    public static Reader getReaderForConfigFile(String configFile) throws FileNotFoundException {
        return new InputStreamReader(ConfigurationTestUtils.getInputStreamForConfigFile(configFile));
    }

    public static InputStream getInputStreamForConfigFile(String configFile) throws FileNotFoundException {
        return new FileInputStream(ConfigurationTestUtils.getFileForConfigFile(configFile));
    }

    public static File getFileForConfigFile(String configFile) {
        File file = new File(ConfigurationTestUtils.getDaemonEtcDirectory(), configFile);
        ConfigurationTestUtils.assertTrue((String)("configuration file '" + configFile + "' does not exist at " + file.getAbsolutePath()), (boolean)file.exists());
        return file;
    }

    public static File getDaemonEtcDirectory() {
        String etcPath = "src" + File.separator + "main" + File.separator + "filtered" + File.separator + "etc";
        return new File(ConfigurationTestUtils.getDaemonProjectDirectory(), etcPath);
    }

    public static void setRelativeHomeDirectory(String relativeHomeDirectory) {
        ConfigurationTestUtils.setAbsoluteHomeDirectory(new File(ConfigurationTestUtils.getCurrentDirectory().getAbsolutePath(), relativeHomeDirectory).getAbsolutePath());
    }

    public static void setAbsoluteHomeDirectory(String absoluteHomeDirectory) {
        System.setProperty("opennms.home", absoluteHomeDirectory);
    }

    public static File getTopProjectDirectory() {
        File currentDirectory = ConfigurationTestUtils.getCurrentDirectory();
        File pomFile = new File(currentDirectory, POM_FILE);
        ConfigurationTestUtils.assertTrue((String)("pom.xml in current directory should exist: " + pomFile.getAbsolutePath()), (boolean)pomFile.exists());
        return ConfigurationTestUtils.findTopProjectDirectory(currentDirectory);
    }

    private static File getCurrentDirectory() {
        File currentDirectory = new File(System.getProperty("user.dir"));
        ConfigurationTestUtils.assertTrue((String)("current directory should exist: " + currentDirectory.getAbsolutePath()), (boolean)currentDirectory.exists());
        ConfigurationTestUtils.assertTrue((String)("current directory should be a directory: " + currentDirectory.getAbsolutePath()), (boolean)currentDirectory.isDirectory());
        return currentDirectory;
    }

    public static File getDaemonProjectDirectory() {
        File topLevelDirectory = ConfigurationTestUtils.getTopProjectDirectory();
        File daemonDirectory = new File(topLevelDirectory, DAEMON_DIRECTORY);
        if (!daemonDirectory.exists()) {
            throw new IllegalStateException("Could not find a opennms-daemon in the location top-level directory: " + topLevelDirectory);
        }
        File pomFile = new File(daemonDirectory, POM_FILE);
        ConfigurationTestUtils.assertTrue((String)("pom.xml in opennms-daemon directory should exist: " + pomFile.getAbsolutePath()), (boolean)pomFile.exists());
        return daemonDirectory;
    }

    private static File findTopProjectDirectory(File currentDirectory) {
        File buildFile = new File(currentDirectory, "build.sh");
        if (buildFile.exists()) {
            File pomFile = new File(currentDirectory, POM_FILE);
            ConfigurationTestUtils.assertTrue((String)("pom.xml in opennms-daemon directory should exist: " + pomFile.getAbsolutePath()), (boolean)pomFile.exists());
            return currentDirectory;
        }
        File parentDirectory = currentDirectory.getParentFile();
        if (parentDirectory == null || parentDirectory == currentDirectory) {
            return null;
        }
        return ConfigurationTestUtils.findTopProjectDirectory(parentDirectory);
    }

    public static void setRrdBinary(String path) {
        System.setProperty("rrd.binary", path);
    }

    public static void setRelativeRrdBaseDirectory(String relativePath) {
        File rrdDir = new File(ConfigurationTestUtils.getCurrentDirectory(), relativePath);
        if (!rrdDir.exists()) {
            rrdDir.mkdirs();
        }
        System.setProperty("rrd.base.dir", rrdDir.getAbsolutePath());
    }
}

