/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test.mock;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggingEvent;

public class MockLogAppender
extends AppenderSkeleton {
    private static List<LoggingEvent> s_events = null;
    private static Level s_logLevel = Level.ALL;

    public MockLogAppender() {
        MockLogAppender.resetEvents();
        MockLogAppender.resetLogLevel();
    }

    public synchronized void doAppend(LoggingEvent event) {
        super.doAppend(event);
        MockLogAppender.receivedLogLevel(event.getLevel());
    }

    protected void append(LoggingEvent event) {
        s_events.add(event);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public static void resetEvents() {
        s_events = Collections.synchronizedList(new LinkedList());
    }

    public static LoggingEvent[] getEvents() {
        return s_events.toArray(new LoggingEvent[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggingEvent[] getEventsGreaterOrEqual(Level level) {
        LinkedList<LoggingEvent> matching = new LinkedList<LoggingEvent>();
        List<LoggingEvent> list = s_events;
        synchronized (list) {
            for (LoggingEvent event : s_events) {
                if (!event.getLevel().isGreaterOrEqual((Priority)level)) continue;
                matching.add(event);
            }
        }
        return matching.toArray(new LoggingEvent[0]);
    }

    public static void setupLogging() {
        MockLogAppender.setupLogging(true);
    }

    public static void setupLogging(boolean toConsole) {
        String level = System.getProperty("mock.logLevel", "DEBUG");
        MockLogAppender.setupLogging(toConsole, level);
    }

    public static void setupLogging(boolean toConsole, String level) {
        MockLogAppender.resetLogLevel();
        Properties logConfig = new Properties();
        String consoleAppender = toConsole ? ", CONSOLE" : "";
        logConfig.put("log4j.appender.CONSOLE", "org.apache.log4j.ConsoleAppender");
        logConfig.put("log4j.appender.CONSOLE.layout", "org.apache.log4j.PatternLayout");
        logConfig.put("log4j.appender.CONSOLE.layout.ConversionPattern", "%d %-5p [%t] %c: %m%n");
        logConfig.put("log4j.appender.MOCK", MockLogAppender.class.getName());
        logConfig.put("log4j.appender.MOCK.layout", "org.apache.log4j.PatternLayout");
        logConfig.put("log4j.appender.MOCK.layout.ConversionPattern", "%-5p [%t] %c: %m%n");
        logConfig.put("log4j.rootCategory", level + consoleAppender + ", MOCK");
        logConfig.put("log4j.logger.org.apache.commons.httpclient.HttpMethodBase", "ERROR");
        logConfig.put("log4j.logger.org.snmp4j", "ERROR");
        logConfig.put("log4j.logger.org.snmp4j.agent", "ERROR");
        logConfig.put("log4j.logger.org.hibernate.cfg.AnnotationBinder", "ERROR" + consoleAppender + ", MOCK");
        PropertyConfigurator.configure((Properties)logConfig);
    }

    public static boolean isLoggingSetup() {
        return s_events != null;
    }

    public static void receivedLogLevel(Level level) {
        if (level.isGreaterOrEqual((Priority)s_logLevel)) {
            s_logLevel = level;
        }
    }

    public static void resetLogLevel() {
        s_logLevel = Level.ALL;
    }

    public static boolean noWarningsOrHigherLogged() {
        return Level.INFO.isGreaterOrEqual((Priority)s_logLevel);
    }

    public static void assertNotGreaterOrEqual(Level level) throws AssertionFailedError {
        if (!MockLogAppender.isLoggingSetup()) {
            throw new AssertionFailedError("MockLogAppender has not been initialized");
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        LoggingEvent[] events = MockLogAppender.getEventsGreaterOrEqual(level);
        if (events.length == 0) {
            return;
        }
        StringBuffer message = new StringBuffer("Log messages at or greater than the log level " + level.toString() + " received:");
        for (LoggingEvent event : events) {
            message.append("\n\t[" + event.getLevel().toString() + "] " + event.getLoggerName() + ": " + event.getMessage());
        }
        throw new AssertionFailedError(message.toString());
    }

    public static void assertNoWarningsOrGreater() throws AssertionFailedError {
        MockLogAppender.assertNotGreaterOrEqual(Level.WARN);
    }
}

