/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class VersionSettingTestSuite
extends TestSuite {
    int m_version;

    public VersionSettingTestSuite(int version) {
        this.m_version = version;
    }

    public VersionSettingTestSuite(Class theClass, String name, int version) {
        super(theClass, name);
        this.m_version = version;
        this.checkForVersionMethod(theClass);
    }

    public VersionSettingTestSuite(Class theClass, int version) {
        super(theClass);
        this.m_version = version;
        this.checkForVersionMethod(theClass);
    }

    public VersionSettingTestSuite(String name, int version) {
        super(name);
        this.m_version = version;
    }

    private void checkForVersionMethod(final Class theClass) {
        try {
            theClass.getMethod("setVersion", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            this.addTest((Test)new TestCase("warning"){

                protected void runTest() {
                    1.fail((String)("Unable to locate setVersion method in class " + theClass.getName()));
                }
            });
        }
    }

    public void runTest(Test test, TestResult result) {
        this.setVersion(test);
        super.runTest(test, result);
    }

    private void setVersion(Test test) {
        try {
            Method m = test.getClass().getMethod("setVersion", Integer.TYPE);
            m.invoke((Object)test, new Integer(this.m_version));
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

