/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

class Snmp4JValue
implements SnmpValue {
    Variable m_value;

    Snmp4JValue(Variable value) {
        if (value == null) {
            new NullPointerException("value attribute cannot be null");
        }
        this.m_value = value;
    }

    Snmp4JValue(int syntax, byte[] bytes) {
        switch (syntax) {
            case 2: {
                BigInteger val = new BigInteger(bytes);
                this.m_value = new Integer32(val.intValue());
                break;
            }
            case 65: {
                BigInteger val = new BigInteger(bytes);
                this.m_value = new Counter32(val.longValue());
                break;
            }
            case 70: {
                BigInteger val = new BigInteger(bytes);
                this.m_value = new Counter64(val.longValue());
                break;
            }
            case 67: {
                BigInteger val = new BigInteger(bytes);
                this.m_value = new TimeTicks(val.longValue());
                break;
            }
            case 66: {
                BigInteger val = new BigInteger(bytes);
                this.m_value = new UnsignedInteger32(val.longValue());
                break;
            }
            case 64: {
                try {
                    InetAddress addr = InetAddress.getByAddress(bytes);
                    this.m_value = new IpAddress(addr);
                    break;
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("unable to create InetAddress from bytes: " + e.getMessage());
                }
            }
            case 6: {
                this.m_value = new OID(new String(bytes));
                break;
            }
            case 4: {
                this.m_value = new OctetString(bytes);
                break;
            }
            case 68: {
                this.m_value = new Opaque(bytes);
                break;
            }
            case 5: {
                this.m_value = new Null();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid syntax " + syntax);
            }
        }
        if (this.m_value == null) {
            new IllegalArgumentException("value object created from syntax " + syntax + " is null");
        }
    }

    public byte[] getBytes() {
        switch (this.m_value.getSyntax()) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                return this.toBigInteger().toByteArray();
            }
            case 64: {
                return this.toInetAddress().getAddress();
            }
            case 6: {
                return this.toSnmpObjId().toString().getBytes();
            }
            case 4: {
                return ((OctetString)this.m_value).getValue();
            }
            case 68: {
                return ((Opaque)this.m_value).getValue();
            }
            case 5: {
                return new byte[0];
            }
        }
        throw new IllegalArgumentException("cannot convert " + this.m_value + " to a byte array");
    }

    public int getType() {
        return this.m_value.getSyntax();
    }

    public boolean isEndOfMib() {
        return this.m_value.getSyntax() == 130;
    }

    public boolean isNumeric() {
        switch (this.m_value.getSyntax()) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                return true;
            }
        }
        return false;
    }

    public int toInt() {
        switch (this.m_value.getSyntax()) {
            case 70: {
                return (int)((Counter64)this.m_value).getValue();
            }
            case 2: {
                return ((Integer32)this.m_value).getValue();
            }
            case 65: 
            case 66: 
            case 67: {
                return (int)((UnsignedInteger32)this.m_value).getValue();
            }
        }
        return Integer.parseInt(this.m_value.toString());
    }

    public long toLong() {
        switch (this.m_value.getSyntax()) {
            case 70: {
                return ((Counter64)this.m_value).getValue();
            }
            case 2: {
                return ((Integer32)this.m_value).getValue();
            }
            case 65: 
            case 66: 
            case 67: {
                return ((UnsignedInteger32)this.m_value).getValue();
            }
            case 4: {
                return this.convertStringToLong();
            }
        }
        return Long.parseLong(this.m_value.toString());
    }

    private long convertStringToLong() {
        return Double.valueOf(this.m_value.toString()).longValue();
    }

    public String toDisplayString() {
        switch (this.m_value.getSyntax()) {
            case 6: {
                return SnmpObjId.get((int[])((OID)this.m_value).getValue()).toString();
            }
            case 67: {
                return Long.toString(this.toLong());
            }
            case 4: {
                return this.toStringDottingCntrlChars(((OctetString)this.m_value).getValue());
            }
        }
        return this.m_value.toString();
    }

    private String toStringDottingCntrlChars(byte[] value) {
        byte[] results = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            results[i] = Character.isISOControl((char)value[i]) ? 46 : value[i];
        }
        return new String(results);
    }

    public InetAddress toInetAddress() {
        switch (this.m_value.getSyntax()) {
            case 64: {
                return ((IpAddress)this.m_value).getInetAddress();
            }
        }
        throw new IllegalArgumentException("cannot convert " + this.m_value + " to an InetAddress");
    }

    public String toHexString() {
        switch (this.m_value.getSyntax()) {
            case 4: {
                return ((OctetString)this.m_value).toHexString().replaceAll(":", "");
            }
        }
        throw new IllegalArgumentException("cannot convert " + this.m_value + " to a HexString");
    }

    public String toString() {
        return this.toDisplayString();
    }

    public BigInteger toBigInteger() {
        switch (this.m_value.getSyntax()) {
            case 70: {
                Counter64 cnt = (Counter64)this.m_value;
                if (cnt.getValue() > 0L) {
                    return BigInteger.valueOf(cnt.getValue());
                }
                return new BigInteger(cnt.toString());
            }
            case 2: {
                return BigInteger.valueOf(((Integer32)this.m_value).getValue());
            }
            case 65: 
            case 66: 
            case 67: {
                return BigInteger.valueOf(((UnsignedInteger32)this.m_value).getValue());
            }
        }
        return new BigInteger(this.m_value.toString());
    }

    public SnmpObjId toSnmpObjId() {
        switch (this.m_value.getSyntax()) {
            case 6: {
                return SnmpObjId.get((int[])((OID)this.m_value).getValue());
            }
        }
        throw new IllegalArgumentException("cannot convert " + this.m_value + " to an SnmpObjId");
    }

    public boolean isDisplayable() {
        if (this.isNumeric()) {
            return true;
        }
        if (this.getType() == 6 || this.getType() == 64) {
            return true;
        }
        if (this.getType() == 4) {
            return this.allBytesDisplayable(this.getBytes());
        }
        return false;
    }

    private boolean allBytesDisplayable(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if ((b >= 32 || b == 9 || b == 10 || b == 13 || b == 0) && b != 127) continue;
            return false;
        }
        return true;
    }

    public boolean isNull() {
        return this.getType() == 5;
    }

    public Variable getVariable() {
        return this.m_value;
    }

    public boolean isError() {
        switch (this.getType()) {
            case 128: 
            case 129: {
                return true;
            }
        }
        return false;
    }
}

