/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueFactory;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JAgentConfig;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JTrapNotifier;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JV1TrapBuilder;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JV2TrapBuilder;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValue;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValueFactory;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JWalker;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class Snmp4JStrategy
implements SnmpStrategy {
    private static Map<TrapNotificationListener, RegistrationInfo> s_registrations = new HashMap<TrapNotificationListener, RegistrationInfo>();
    private static boolean s_initialized = false;
    private Snmp4JValueFactory m_valueFactory;

    private static void initialize() {
        if (s_initialized) {
            return;
        }
        MPv3.setEnterpriseID((int)5813);
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        if (System.getProperty("org.snmp4j.smisyntaxes", null) != null) {
            SNMP4JSettings.setExtensibilityEnabled((boolean)true);
        }
        if (Boolean.getBoolean("org.opennms.snmp.snmp4j.forwardRuntimeExceptions")) {
            SNMP4JSettings.setForwardRuntimeExceptions((boolean)true);
        }
        s_initialized = true;
    }

    public Snmp4JStrategy() {
        Snmp4JStrategy.initialize();
    }

    public SnmpWalker createWalker(SnmpAgentConfig snmpAgentConfig, String name, CollectionTracker tracker) {
        return new Snmp4JWalker(new Snmp4JAgentConfig(snmpAgentConfig), name, tracker);
    }

    public SnmpValue[] getBulk(SnmpAgentConfig agentConfig, SnmpObjId[] oid) {
        throw new UnsupportedOperationException("Snmp4JStrategy.getBulk not yet implemented.");
    }

    public SnmpValue set(SnmpAgentConfig agentConfig, SnmpObjId oid, SnmpValue value) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("set: OID: " + oid + " value: " + value.toString() + " for Agent: " + agentConfig));
        }
        SnmpObjId[] oids = new SnmpObjId[]{oid};
        SnmpValue[] values = new SnmpValue[]{value};
        SnmpValue[] retvalues = this.set(agentConfig, oids, values);
        return retvalues[0];
    }

    public SnmpValue[] set(SnmpAgentConfig agentConfig, SnmpObjId[] oids, SnmpValue[] values) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("set: OIDs: " + oids + " values: " + values + " for Agent: " + agentConfig));
        }
        return this.buildAndSendPdu(agentConfig, -93, oids, values);
    }

    public SnmpValue get(SnmpAgentConfig agentConfig, SnmpObjId oid) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("get: OID: " + oid + " for Agent:" + agentConfig));
        }
        SnmpObjId[] oids = new SnmpObjId[]{oid};
        SnmpValue[] retvalues = this.get(agentConfig, oids);
        return retvalues[0];
    }

    public SnmpValue[] get(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("get: OID: " + oids + " for Agent:" + agentConfig));
        }
        return this.buildAndSendPdu(agentConfig, -96, oids, null);
    }

    public SnmpValue getNext(SnmpAgentConfig agentConfig, SnmpObjId oid) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("getNext: OID: " + oid + " for Agent:" + agentConfig));
        }
        SnmpObjId[] oids = new SnmpObjId[]{oid};
        SnmpValue[] retvalues = this.getNext(agentConfig, oids);
        return retvalues[0];
    }

    public SnmpValue[] getNext(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("getNext: OID: " + oids + " for Agent:" + agentConfig));
        }
        return this.buildAndSendPdu(agentConfig, -95, oids, null);
    }

    private SnmpValue[] buildAndSendPdu(SnmpAgentConfig agentConfig, int type, SnmpObjId[] oids, SnmpValue[] values) {
        Snmp4JAgentConfig snmp4jAgentConfig = new Snmp4JAgentConfig(agentConfig);
        PDU pdu = this.buildPdu(snmp4jAgentConfig, type, oids, values);
        if (pdu == null) {
            return null;
        }
        return this.send(snmp4jAgentConfig, pdu, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SnmpValue[] send(Snmp4JAgentConfig agentConfig, PDU pdu, boolean expectResponse) {
        Snmp session;
        try {
            session = agentConfig.createSnmpSession();
        }
        catch (IOException e) {
            this.log().error((Object)("send: Could not create SNMP session for agent " + agentConfig + ": " + e), (Throwable)e);
            return new SnmpValue[]{null};
        }
        try {
            if (expectResponse) {
                try {
                    session.listen();
                }
                catch (IOException e) {
                    this.log().error((Object)("send: error setting up listener for SNMP responses: " + e), (Throwable)e);
                    SnmpValue[] snmpValueArray = new SnmpValue[]{null};
                    this.closeQuietly(session);
                    return snmpValueArray;
                }
            }
            ResponseEvent responseEvent = session.send(pdu, agentConfig.getTarget());
            if (expectResponse) {
                SnmpValue[] snmpValueArray = this.processResponse(agentConfig, responseEvent);
                return snmpValueArray;
            }
            SnmpValue[] snmpValueArray = null;
            return snmpValueArray;
        }
        finally {
            this.closeQuietly(session);
        }
    }

    protected PDU buildPdu(Snmp4JAgentConfig agentConfig, int pduType, SnmpObjId[] oids, SnmpValue[] values) {
        PDU pdu = agentConfig.createPdu(pduType);
        if (values == null) {
            for (SnmpObjId oid : oids) {
                pdu.add(new VariableBinding(new OID(oid.toString())));
            }
        } else {
            if (oids.length != values.length) {
                Exception e = new Exception("This is a bogus exception so we can get a stack backtrace");
                this.log().error((Object)("PDU to prepare has object values but not the same number as there are OIDs.  There are " + oids.length + " OIDs and " + values.length + " object values."), (Throwable)e);
                return null;
            }
            for (int i = 0; i < oids.length; ++i) {
                pdu.add(new VariableBinding(new OID(oids[i].toString()), new Snmp4JValue(values[i].getType(), values[i].getBytes()).getVariable()));
            }
        }
        if (pdu.getVariableBindings().size() != oids.length) {
            Exception e = new Exception("This is a bogus exception so we can get a stack backtrace");
            this.log().error((Object)("Prepared PDU does not have as many variable bindings as there are OIDs.  There are " + oids.length + " OIDs and " + pdu.getVariableBindings() + " variable bindings."), (Throwable)e);
            return null;
        }
        return pdu;
    }

    private SnmpValue[] processResponse(Snmp4JAgentConfig agentConfig, ResponseEvent responseEvent) throws IOException {
        SnmpValue[] retvalues = new SnmpValue[]{null};
        if (responseEvent.getResponse() == null) {
            this.log().warn((Object)("send: Timeout.  Agent: " + agentConfig));
        } else if (responseEvent.getResponse().get(0).getSyntax() == 5) {
            retvalues[0] = null;
        } else if (responseEvent.getError() != null) {
            this.log().warn((Object)("send: Error during get operation.  Error: " + responseEvent.getError().getLocalizedMessage()));
        } else if (responseEvent.getResponse().getType() == -88) {
            this.log().warn((Object)("send: Error during get operation.  Report returned with varbinds: " + responseEvent.getResponse().getVariableBindings()));
        } else if (responseEvent.getResponse().getVariableBindings().size() < 1) {
            this.log().warn((Object)"send: Received PDU with 0 varbinds.");
        } else {
            retvalues = this.convertResponseToValues(responseEvent);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("send: Snmp operation successful. Value: " + retvalues));
            }
        }
        return retvalues;
    }

    private SnmpValue[] convertResponseToValues(ResponseEvent responseEvent) {
        SnmpValue[] retvalues = new Snmp4JValue[responseEvent.getResponse().getVariableBindings().size()];
        for (int i = 0; i < retvalues.length; ++i) {
            retvalues[i] = new Snmp4JValue(responseEvent.getResponse().get(i).getVariable());
        }
        return retvalues;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public SnmpValueFactory getValueFactory() {
        if (this.m_valueFactory == null) {
            this.m_valueFactory = new Snmp4JValueFactory();
        }
        return this.m_valueFactory;
    }

    public void registerForTraps(TrapNotificationListener listener, TrapProcessorFactory processorFactory, int snmpTrapPort) throws IOException {
        RegistrationInfo info = new RegistrationInfo(listener, snmpTrapPort);
        Snmp4JTrapNotifier m_trapHandler = new Snmp4JTrapNotifier(listener, processorFactory);
        info.setHandler(m_trapHandler);
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping(new UdpAddress(snmpTrapPort));
        info.setTransportMapping((TransportMapping)transport);
        Snmp snmp = new Snmp((TransportMapping)transport);
        snmp.addCommandResponder((CommandResponder)m_trapHandler);
        info.setSession(snmp);
        s_registrations.put(listener, info);
        snmp.listen();
    }

    public void unregisterForTraps(TrapNotificationListener listener, int snmpTrapPort) throws IOException {
        RegistrationInfo info = s_registrations.remove(listener);
        this.closeQuietly(info.getSession());
    }

    public SnmpV1TrapBuilder getV1TrapBuilder() {
        return new Snmp4JV1TrapBuilder(this);
    }

    public SnmpTrapBuilder getV2TrapBuilder() {
        return new Snmp4JV2TrapBuilder(this);
    }

    protected SnmpAgentConfig buildAgentConfig(String address, int port, String community, PDU pdu) throws UnknownHostException {
        SnmpAgentConfig config = new SnmpAgentConfig();
        config.setAddress(InetAddress.getByName(address));
        config.setPort(port);
        config.setVersion(pdu instanceof PDUv1 ? 1 : 2);
        return config;
    }

    public void sendTest(String agentAddress, int port, String community, PDU pdu) {
        for (RegistrationInfo info : s_registrations.values()) {
            if (port != info.getPort()) continue;
            Snmp snmp = info.getSession();
            MessageDispatcher dispatcher = snmp.getMessageDispatcher();
            TransportMapping transport = info.getTransportMapping();
            int securityModel = pdu instanceof PDUv1 ? 1 : 2;
            int messageModel = pdu instanceof PDUv1 ? 0 : 1;
            CommandResponderEvent e = new CommandResponderEvent(dispatcher, transport, (Address)new IpAddress(agentAddress), messageModel, securityModel, community.getBytes(), 1, new PduHandle(), pdu, 1000, null);
            info.getHandler().processPdu(e);
        }
    }

    private void closeQuietly(Snmp session) {
        if (session == null) {
            return;
        }
        try {
            session.close();
        }
        catch (IOException e) {
            ThreadCategory.getInstance(Snmp4JStrategy.class).error((Object)("error closing SNMP connection: " + e), (Throwable)e);
        }
    }

    public static class RegistrationInfo {
        public TrapNotificationListener m_listener;
        int m_trapPort;
        Snmp m_trapSession;
        Snmp4JTrapNotifier m_trapHandler;
        private TransportMapping m_transportMapping;

        RegistrationInfo(TrapNotificationListener listener, int trapPort) {
            if (listener == null) {
                throw new NullPointerException("listener is null");
            }
            this.m_listener = listener;
            this.m_trapPort = trapPort;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RegistrationInfo) {
                RegistrationInfo info = (RegistrationInfo)obj;
                return this.m_listener == info.m_listener && this.m_trapPort == info.m_trapPort;
            }
            return false;
        }

        public int hashCode() {
            return this.m_listener.hashCode() ^ this.m_trapPort;
        }

        public void setSession(Snmp trapSession) {
            this.m_trapSession = trapSession;
        }

        public Snmp getSession() {
            return this.m_trapSession;
        }

        public void setHandler(Snmp4JTrapNotifier trapHandler) {
            this.m_trapHandler = trapHandler;
        }

        public Snmp4JTrapNotifier getHandler() {
            return this.m_trapHandler;
        }

        public int getPort() {
            return this.m_trapPort;
        }

        public void setTransportMapping(TransportMapping transport) {
            this.m_transportMapping = transport;
        }

        public TransportMapping getTransportMapping() {
            return this.m_transportMapping;
        }
    }
}

