/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.io.IOException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JAgentConfig;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValue;
import org.opennms.netmgt.snmp.snmp4j.SnmpHelpers;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class Snmp4JWalker
extends SnmpWalker {
    private Snmp m_session;
    private Target m_tgt;
    private ResponseListener m_listener;
    private Snmp4JAgentConfig m_agentConfig;

    public Snmp4JWalker(Snmp4JAgentConfig agentConfig, String name, CollectionTracker tracker) {
        super(agentConfig.getInetAddress(), name, agentConfig.getMaxVarsPerPdu(), tracker);
        this.m_agentConfig = agentConfig;
        this.m_tgt = agentConfig.getTarget();
        this.m_listener = new Snmp4JResponseListener();
    }

    public void start() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Walking " + this.getName() + " for " + this.getAddress() + " using version " + SnmpHelpers.versionString(this.getVersion()) + " with config: " + this.m_agentConfig));
        }
        super.start();
    }

    protected SnmpWalker.WalkerPduBuilder createPduBuilder(int maxVarsPerPdu) {
        return this.getVersion() == 0 ? new GetNextBuilder(maxVarsPerPdu) : new GetBulkBuilder(maxVarsPerPdu);
    }

    protected void sendNextPdu(SnmpWalker.WalkerPduBuilder pduBuilder) throws IOException {
        Snmp4JPduBuilder snmp4JPduBuilder = (Snmp4JPduBuilder)pduBuilder;
        if (this.m_session == null) {
            this.m_session = SnmpHelpers.createSnmpSession(this.m_agentConfig);
            this.m_session.listen();
        }
        this.log().debug((Object)("Sending tracker pdu of size " + snmp4JPduBuilder.getPdu().size()));
        this.m_session.send(snmp4JPduBuilder.getPdu(), this.m_tgt, null, this.m_listener);
    }

    protected int getVersion() {
        return this.m_tgt.getVersion();
    }

    protected void close() throws IOException {
        if (this.m_session != null) {
            this.m_session.close();
            this.m_session = null;
        }
    }

    private final Category log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    public class Snmp4JResponseListener
    implements ResponseListener {
        public void processResponse(PDU response) {
            try {
                Snmp4JWalker.this.log().debug((Object)("Received a tracker pdu of type " + PDU.getTypeString((int)response.getType()) + " from " + Snmp4JWalker.this.getAddress() + " of size " + response.size() + " errorStatus = " + response.getErrorStatusText() + " errorIndex = " + response.getErrorIndex()));
                if (response.getType() != -88) {
                    if (!Snmp4JWalker.this.processErrors(response.getErrorStatus(), response.getErrorIndex())) {
                        for (int i = 0; i < response.size(); ++i) {
                            VariableBinding vb = response.get(i);
                            SnmpObjId receivedOid = SnmpObjId.get((int[])vb.getOid().getValue());
                            Snmp4JValue val = new Snmp4JValue(vb.getVariable());
                            Snmp4JWalker.this.processResponse(receivedOid, val);
                        }
                    }
                    Snmp4JWalker.this.buildAndSendNextPdu();
                } else {
                    Snmp4JWalker.this.handleAuthError("A REPORT Pdu was returned from the agent.  This is most likely an authentication problem.  Please check the config");
                }
            }
            catch (Throwable e) {
                Snmp4JWalker.this.handleFatalError(e);
            }
        }

        public void onResponse(ResponseEvent responseEvent) {
            Snmp4JWalker.this.m_session.cancel(responseEvent.getRequest(), (ResponseListener)this);
            if (responseEvent.getError() instanceof InterruptedException) {
                Snmp4JWalker.this.log().debug((Object)("Interruption event.  We have probably tried to close the session due to an error: " + responseEvent.getError()));
            } else if (responseEvent.getResponse() == null) {
                Snmp4JWalker.this.handleTimeout(Snmp4JWalker.this.getName() + ": snmpTimeoutError for: " + Snmp4JWalker.this.getAddress());
            } else if (responseEvent.getError() != null) {
                Snmp4JWalker.this.handleError(Snmp4JWalker.this.getName() + ": snmpInternalError: " + responseEvent.getError() + " for: " + Snmp4JWalker.this.getAddress());
            } else {
                this.processResponse(responseEvent.getResponse());
            }
        }
    }

    public class GetBulkBuilder
    extends Snmp4JPduBuilder {
        private PDU m_bulkPdu;

        public GetBulkBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
            this.reset();
        }

        public void reset() {
            this.m_bulkPdu = SnmpHelpers.createPDU(Snmp4JWalker.this.getVersion());
            this.m_bulkPdu.setType(-91);
        }

        public PDU getPdu() {
            return this.m_bulkPdu;
        }

        public void addOid(SnmpObjId snmpObjId) {
            VariableBinding varBind = new VariableBinding(new OID(snmpObjId.getIds()));
            this.m_bulkPdu.add(varBind);
        }

        public void setNonRepeaters(int numNonRepeaters) {
            this.m_bulkPdu.setNonRepeaters(numNonRepeaters);
        }

        public void setMaxRepetitions(int maxRepetitions) {
            this.m_bulkPdu.setMaxRepetitions(maxRepetitions);
        }
    }

    public class GetNextBuilder
    extends Snmp4JPduBuilder {
        private PDU m_nextPdu;

        private GetNextBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
            this.m_nextPdu = null;
            this.reset();
        }

        public void reset() {
            this.m_nextPdu = SnmpHelpers.createPDU(Snmp4JWalker.this.getVersion());
            this.m_nextPdu.setType(-95);
        }

        public PDU getPdu() {
            return this.m_nextPdu;
        }

        public void addOid(SnmpObjId snmpObjId) {
            VariableBinding varBind = new VariableBinding(new OID(snmpObjId.getIds()));
            this.m_nextPdu.add(varBind);
        }

        public void setNonRepeaters(int numNonRepeaters) {
        }

        public void setMaxRepetitions(int maxRepititions) {
        }
    }

    public static abstract class Snmp4JPduBuilder
    extends SnmpWalker.WalkerPduBuilder {
        public Snmp4JPduBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
        }

        public abstract PDU getPdu();
    }
}

