/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.scan.snmp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.provision.ScanContext;
import org.opennms.netmgt.provision.Scanner;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SingleInstanceTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.springframework.util.Assert;

public class AbstractSnmpScanner
implements Scanner {
    private String m_name = null;
    private SnmpAgentConfigFactory m_snmpAgentConfigFactory = null;
    private List<SnmpExchange> m_exchangeCollection = null;

    protected AbstractSnmpScanner(String name) {
        this.m_name = name;
        this.m_exchangeCollection = new ArrayList<SnmpExchange>();
    }

    public String getName() {
        return this.m_name;
    }

    public void setSnmpAgentConfigFactory(SnmpAgentConfigFactory snmpPeerFactory) {
        this.m_snmpAgentConfigFactory = snmpPeerFactory;
    }

    public void init() {
        Assert.notNull((Object)this.m_snmpAgentConfigFactory, (String)"snmpAgentConfigFactory must be set");
        this.onInit();
    }

    protected void onInit() {
    }

    public void scan(ScanContext context) throws InterruptedException {
        InetAddress agentAddress = context.getAgentAddress("SNMP");
        if (agentAddress == null) {
            return;
        }
        SnmpAgentConfig agentConfig = this.m_snmpAgentConfigFactory.getAgentConfig(agentAddress);
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)this.getName(), (CollectionTracker)this.createCollectionTracker(context));
        walker.start();
        walker.waitFor();
    }

    private CollectionTracker createCollectionTracker(ScanContext scanContext) {
        ArrayList<CollectionTracker> trackers = new ArrayList<CollectionTracker>();
        for (SnmpExchange exchange : this.m_exchangeCollection) {
            trackers.add(exchange.createTracker(scanContext));
        }
        return new AggregateTracker(trackers);
    }

    protected SnmpExchange getSingleInstance(final String base, final String inst) {
        SnmpExchange exchange = new SnmpExchange(){
            Storer m_storer;

            @Override
            public CollectionTracker createTracker(final ScanContext scanContext) {
                return new SingleInstanceTracker(base, inst){

                    protected void storeResult(SnmpResult res) {
                        m_storer.storeResult(scanContext, res);
                    }
                };
            }

            @Override
            public void andStoreIn(Storer storer) {
                this.m_storer = storer;
            }
        };
        this.m_exchangeCollection.add(exchange);
        return exchange;
    }

    public static interface SnmpExchange {
        public CollectionTracker createTracker(ScanContext var1);

        public void andStoreIn(Storer var1);
    }

    public static interface Storer {
        public void storeResult(ScanContext var1, SnmpResult var2);
    }
}

