/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.SnmpAssetAdapterConfig;
import org.opennms.netmgt.config.SnmpAssetAdapterConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpAssetAdapterConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpAssetAdapterConfigFactory.class);
    private final SnmpAssetAdapterConfigManager m_config;

    public SnmpAssetAdapterConfigFactory() throws IOException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_ASSET_ADAPTER_CONFIG_FILE_NAME);
        LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
        FileInputStream reader = new FileInputStream(cfgFile);
        this.m_config = new SnmpAssetAdapterConfigManager(cfgFile.lastModified(), reader);
        IOUtils.closeQuietly((InputStream)reader);
    }

    public void reload() throws IOException {
        this.m_config.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(String xml) throws IOException {
        this.m_config.getWriteLock().lock();
        try {
            if (xml != null) {
                long timestamp = System.currentTimeMillis();
                File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_ASSET_ADAPTER_CONFIG_FILE_NAME);
                LOG.debug("saveXml: saving config file at {}: {}", (Object)timestamp, (Object)cfgFile.getPath());
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), StandardCharsets.UTF_8);
                fileWriter.write(xml);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
                LOG.debug("saveXml: finished saving config file: {}", (Object)cfgFile.getPath());
            }
        }
        finally {
            this.m_config.getWriteLock().unlock();
        }
    }

    public SnmpAssetAdapterConfig getInstance() {
        this.m_config.getReadLock().lock();
        try {
            SnmpAssetAdapterConfigManager snmpAssetAdapterConfigManager = this.m_config;
            return snmpAssetAdapterConfigManager;
        }
        finally {
            this.m_config.getReadLock().unlock();
        }
    }
}

