/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.SnmpAssetAdapterConfig;
import org.opennms.netmgt.config.snmpAsset.adapter.AssetField;
import org.opennms.netmgt.config.snmpAsset.adapter.MibObj;
import org.opennms.netmgt.config.snmpAsset.adapter.MibObjs;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.model.events.snmp.SyntaxToEvent;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimpleQueuedProvisioningAdapter;
import org.opennms.netmgt.provision.SimplerQueuedProvisioningAdapter;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.util.Assert;

@EventListener(name="SnmpAssetProvisioningAdapter")
public class SnmpAssetProvisioningAdapter
extends SimplerQueuedProvisioningAdapter
implements InitializingBean {
    private NodeDao m_nodeDao;
    private EventForwarder m_eventForwarder;
    private SnmpAssetAdapterConfig m_config;
    private SnmpAgentConfigFactory m_snmpConfigDao;
    public static final String NAME = "SnmpAssetProvisioningAdapter";

    public SnmpAssetProvisioningAdapter() {
        super(NAME);
        this.setDelay(300L);
        this.setTimeUnit(TimeUnit.SECONDS);
    }

    SimpleQueuedProvisioningAdapter.AdapterOperationSchedule createScheduleForNode(int nodeId, SimpleQueuedProvisioningAdapter.AdapterOperationType adapterOperationType) {
        SimpleQueuedProvisioningAdapter.AdapterOperationSchedule aos = new SimpleQueuedProvisioningAdapter.AdapterOperationSchedule(this.m_delay, 60L, 3, this.m_timeUnit);
        SnmpAssetProvisioningAdapter.log().info("createScheduleForNode: Scheduling " + adapterOperationType + " for nodeid " + nodeId + " with schedule: " + aos);
        return aos;
    }

    public boolean isNodeReady(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        boolean readyState = false;
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)op.getNodeId());
        if (node != null && node.getSysObjectId() != null) {
            readyState = true;
        }
        return readyState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddNode(int nodeId) throws ProvisioningAdapterException {
        SnmpAssetProvisioningAdapter.log().debug("doAdd: adding nodeid: " + nodeId);
        final OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        Assert.notNull((Object)node, (String)("doAdd: failed to return node for given nodeId:" + nodeId));
        InetAddress ipaddress = (InetAddress)this.m_template.execute((TransactionCallback)new TransactionCallback<InetAddress>(){

            public InetAddress doInTransaction(TransactionStatus arg0) {
                return SnmpAssetProvisioningAdapter.this.getIpForNode(node);
            }
        });
        SnmpAgentConfig agentConfig = null;
        agentConfig = this.m_snmpConfigDao.getAgentConfig(ipaddress);
        OnmsAssetRecord asset = node.getAssetRecord();
        this.m_config.getReadLock().lock();
        try {
            for (AssetField field : this.m_config.getAssetFieldsForAddress(ipaddress, node.getSysObjectId())) {
                try {
                    String value = SnmpAssetProvisioningAdapter.fetchSnmpAssetString(agentConfig, field.getMibObjs(), field.getFormatString());
                    if (SnmpAssetProvisioningAdapter.log().isDebugEnabled()) {
                        SnmpAssetProvisioningAdapter.log().debug("doAdd: Setting asset field \"" + field.getName() + "\" to value: " + value);
                    }
                    BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)asset);
                    try {
                        wrapper.setPropertyValue(field.getName(), (Object)value);
                    }
                    catch (BeansException e) {
                        SnmpAssetProvisioningAdapter.log().warn("doAdd: Could not set property \"" + field.getName() + "\" on asset object: " + e.getMessage(), (Throwable)e);
                    }
                }
                catch (MissingFormatArgumentException e) {
                    SnmpAssetProvisioningAdapter.log().warn("doAdd: Could not set value for asset field \"" + field.getName() + "\": " + e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            this.m_config.getReadLock().unlock();
        }
        node.setAssetRecord(asset);
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    private static String fetchSnmpAssetString(SnmpAgentConfig agentConfig, MibObjs mibObjs, String formatString) throws MissingFormatArgumentException {
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<SnmpObjId> objs = new ArrayList<SnmpObjId>();
        for (MibObj mibobj : mibObjs.getMibObj()) {
            aliases.add(mibobj.getAlias());
            objs.add(SnmpObjId.get((String)mibobj.getOid()));
        }
        SnmpValue[] values = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId[])objs.toArray(new SnmpObjId[0]));
        if (values.length == aliases.size()) {
            Properties substitutions = new Properties();
            boolean foundAValue = false;
            for (int i = 0; i < values.length; ++i) {
                if (values[i].isError()) continue;
                foundAValue = true;
                Parm parm = SyntaxToEvent.processSyntax((String)((String)aliases.get(i)), (SnmpValue)values[i]);
                substitutions.setProperty((String)aliases.get(i), parm.getValue().getContent());
            }
            if (!foundAValue) {
                if (SnmpAssetProvisioningAdapter.log().isDebugEnabled()) {
                    SnmpAssetProvisioningAdapter.log().debug("fetchSnmpAssetString: Failed to fetch any SNMP values for system " + agentConfig.toString());
                }
                throw new MissingFormatArgumentException("fetchSnmpAssetString: Failed to fetch any SNMP values for system " + agentConfig.toString());
            }
            SnmpAssetProvisioningAdapter.log().debug("fetchSnmpAssetString: Fetched asset properties from SNMP agent:\n" + SnmpAssetProvisioningAdapter.formatPropertiesAsString(substitutions));
            if (objs.size() != substitutions.size()) {
                SnmpAssetProvisioningAdapter.log().warn("fetchSnmpAssetString: Unexpected number of properties returned from SNMP GET:\n" + SnmpAssetProvisioningAdapter.formatPropertiesAsString(substitutions));
            }
            return PropertiesUtils.substitute((String)formatString, (Properties[])new Properties[]{substitutions});
        }
        SnmpAssetProvisioningAdapter.log().warn("fetchSnmpAssetString: Invalid number of SNMP parameters returned: " + values.length + " != " + aliases.size());
        throw new MissingFormatArgumentException("fetchSnmpAssetString: Invalid number of SNMP parameters returned: " + values.length + " != " + aliases.size());
    }

    protected static String formatPropertiesAsString(Properties props) {
        StringBuffer propertyValues = new StringBuffer();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            propertyValues.append("  ");
            propertyValues.append(entry.getKey().toString());
            propertyValues.append(" => ");
            propertyValues.append(entry.getValue().toString());
            propertyValues.append("\n");
        }
        return propertyValues.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdateNode(int nodeId) throws ProvisioningAdapterException {
        SnmpAssetProvisioningAdapter.log().debug("doUpdate: updating nodeid: " + nodeId);
        final OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        Assert.notNull((Object)node, (String)("doUpdate: failed to return node for given nodeId:" + nodeId));
        InetAddress ipaddress = (InetAddress)this.m_template.execute((TransactionCallback)new TransactionCallback<InetAddress>(){

            public InetAddress doInTransaction(TransactionStatus arg0) {
                return SnmpAssetProvisioningAdapter.this.getIpForNode(node);
            }
        });
        SnmpAgentConfig agentConfig = this.m_snmpConfigDao.getAgentConfig(ipaddress);
        OnmsAssetRecord asset = node.getAssetRecord();
        this.m_config.getReadLock().lock();
        try {
            for (AssetField field : this.m_config.getAssetFieldsForAddress(ipaddress, node.getSysObjectId())) {
                try {
                    String value = SnmpAssetProvisioningAdapter.fetchSnmpAssetString(agentConfig, field.getMibObjs(), field.getFormatString());
                    if (SnmpAssetProvisioningAdapter.log().isDebugEnabled()) {
                        SnmpAssetProvisioningAdapter.log().debug("doUpdate: Setting asset field \"" + field.getName() + "\" to value: " + value);
                    }
                    BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)asset);
                    try {
                        wrapper.setPropertyValue(field.getName(), (Object)value);
                    }
                    catch (BeansException e) {
                        SnmpAssetProvisioningAdapter.log().warn("doUpdate: Could not set property \"" + field.getName() + "\" on asset object: " + e.getMessage(), (Throwable)e);
                    }
                }
                catch (MissingFormatArgumentException e) {
                    SnmpAssetProvisioningAdapter.log().warn("doUpdate: Could not set value for asset field \"" + field.getName() + "\": " + e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            this.m_config.getReadLock().unlock();
        }
        node.setAssetRecord(asset);
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    public void doNotifyConfigChange(int nodeId) throws ProvisioningAdapterException {
        SnmpAssetProvisioningAdapter.log().debug("doNodeConfigChanged: nodeid: " + nodeId);
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public SnmpAgentConfigFactory getSnmpPeerFactory() {
        return this.m_snmpConfigDao;
    }

    public void setSnmpPeerFactory(SnmpAgentConfigFactory snmpConfigDao) {
        this.m_snmpConfigDao = snmpConfigDao;
    }

    public SnmpAssetAdapterConfig getSnmpAssetAdapterConfig() {
        return this.m_config;
    }

    public void setSnmpAssetAdapterConfig(SnmpAssetAdapterConfig mConfig) {
        this.m_config = mConfig;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(SnmpAssetProvisioningAdapter.class);
    }

    public String getName() {
        return NAME;
    }

    private InetAddress getIpForNode(OnmsNode node) {
        LogUtils.debugf((Object)((Object)this), (String)"getIpForNode: node: %s Foreign Source: %s", (Object[])new Object[]{node.getNodeId(), node.getForeignSource()});
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        InetAddress ipaddr = InetAddressUtils.getLocalHostAddress();
        if (primaryInterface == null) {
            SnmpAssetProvisioningAdapter.log().debug("getIpForNode: found null SNMP Primary Interface, getting interfaces");
            Set ipInterfaces = node.getIpInterfaces();
            for (OnmsIpInterface onmsIpInterface : ipInterfaces) {
                SnmpAssetProvisioningAdapter.log().debug("getIpForNode: trying Interface with id: " + onmsIpInterface.getId());
                if (InetAddressUtils.str((InetAddress)onmsIpInterface.getIpAddress()) != null) {
                    ipaddr = onmsIpInterface.getIpAddress();
                    continue;
                }
                SnmpAssetProvisioningAdapter.log().debug("getIpForNode: found null ip address on Interface with id: " + onmsIpInterface.getId());
            }
        } else {
            SnmpAssetProvisioningAdapter.log().debug("getIpForNode: found SNMP Primary Interface");
            if (InetAddressUtils.str((InetAddress)primaryInterface.getIpAddress()) != null) {
                ipaddr = primaryInterface.getIpAddress();
            } else {
                SnmpAssetProvisioningAdapter.log().debug("getIpForNode: found null ip address on Primary Interface");
            }
        }
        return ipaddr;
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event event) {
        if (this.isReloadConfigEventTarget(event)) {
            LogUtils.debugf((Object)((Object)this), (String)"Reloading the SNMP asset adapter configuration", (Object[])new Object[0]);
            try {
                this.m_config.update();
            }
            catch (Throwable e) {
                LogUtils.infof((Object)((Object)this), (Throwable)e, (String)"Unable to reload SNMP asset adapter configuration", (Object[])new Object[0]);
            }
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        for (Parm parm : event.getParmCollection()) {
            if (!"daemonName".equals(parm.getParmName()) || !"Provisiond.SnmpAssetProvisioningAdapter".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        SnmpAssetProvisioningAdapter.log().debug("isReloadConfigEventTarget: Provisiond.SnmpAssetProvisioningAdapter was target of reload event: " + isTarget);
        return isTarget;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

