/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.core.web.HttpClientWrapperConfigHelper;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSlackCompatibleNotificationStrategy
implements NotificationStrategy {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSlackCompatibleNotificationStrategy.class);
    private final List<Argument> m_arguments = Lists.newArrayList();

    protected abstract String getChannelPropertyName();

    protected abstract String getIconEmojiPropertyName();

    protected abstract String getIconUrlPropertyName();

    protected abstract String getUsernamePropertyName();

    protected abstract String getUrlPropertyName();

    protected abstract String getUseSystemProxyPropertyName();

    protected abstract String decorateMessageBody(String var1);

    protected abstract String decorateMessageSubject(String var1);

    protected abstract String formatWebhookErrorResponse(int var1, String var2);

    protected void setArguments(List<Argument> arguments) {
        this.m_arguments.clear();
        this.m_arguments.addAll(arguments);
    }

    public int send(List<Argument> arguments) {
        String url;
        if (arguments != null) {
            this.setArguments(arguments);
        }
        if ((url = this.getUrl()) == null) {
            LOG.error("send: url must not be null");
            return 1;
        }
        String iconUrl = this.getIconUrl();
        String iconEmoji = this.getIconEmoji();
        String channel = this.getChannel();
        String message = this.buildMessage(arguments);
        HttpClientWrapper clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(3000)).setSocketTimeout(Integer.valueOf(3000));
        if (this.getUseSystemProxy()) {
            clientWrapper.useSystemProxySettings();
        }
        HttpPost postMethod = new HttpPost(url);
        JSONObject jsonData = new JSONObject();
        jsonData.put((Object)"username", (Object)this.getUsername());
        if (iconUrl != null) {
            jsonData.put((Object)"icon_url", (Object)iconUrl);
        }
        if (iconEmoji != null) {
            jsonData.put((Object)"icon_emoji", (Object)iconEmoji);
        }
        if (channel != null) {
            jsonData.put((Object)"channel", (Object)channel);
        }
        jsonData.put((Object)"text", (Object)message);
        if (jsonData.containsKey((Object)"icon_url") && jsonData.containsKey((Object)"icon_emoji")) {
            LOG.warn("Both URL and emoji specified for icon. Sending both; behavior is undefined.");
        }
        LOG.debug("Prepared JSON POST data for webhook is: {}", (Object)jsonData.toJSONString());
        StringEntity entity = new StringEntity(jsonData.toJSONString(), ContentType.APPLICATION_JSON);
        postMethod.setEntity((HttpEntity)entity);
        postMethod.setHeader("Content-Type", "application/json");
        String contents = null;
        int statusCode = -1;
        try {
            CloseableHttpResponse response = clientWrapper.getClient().execute((HttpUriRequest)postMethod);
            statusCode = response.getStatusLine().getStatusCode();
            contents = EntityUtils.toString((HttpEntity)response.getEntity());
            LOG.debug("send: Contents is: {}", (Object)contents);
        }
        catch (IOException e) {
            LOG.error("send: I/O problem with webhook post/response", (Throwable)e);
            throw new RuntimeException("Problem with webhook post: " + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Closeable)clientWrapper);
        }
        if ("ok".equals(contents)) {
            LOG.debug("Got 'ok' back from webhook, indicating success.");
            statusCode = 0;
        } else {
            LOG.info("Got a non-ok response from webhook, attempting to dissect response.");
            LOG.error("Webhook returned non-OK response to notification post: {}", (Object)this.formatWebhookErrorResponse(statusCode, contents));
            statusCode = 1;
        }
        return statusCode;
    }

    protected String getUrl() {
        String url = this.getValueFromSwitchOrProp("Webhook URL", "-url", this.getUrlPropertyName());
        if (url == null) {
            LOG.error("No webhook URL specified as a notification command switch or via system property {}. Cannot continue.", (Object)this.getUrlPropertyName());
        }
        return url;
    }

    protected String getUsername() {
        String username = this.getValueFromSwitchOrProp("Bot username", "-username", this.getUsernamePropertyName());
        if (username == null) {
            LOG.warn("No bot username specified as a notification command switch or via system property {}. Using default value opennms.", (Object)this.getUsernamePropertyName());
            return "opennms";
        }
        return username;
    }

    protected String getIconUrl() {
        String iconurl = this.getValueFromSwitchOrProp("Icon URL", "-iconurl", this.getIconUrlPropertyName());
        if (iconurl == null) {
            LOG.info("No icon URL specified as a notification command switch or via system property {}. Not setting one.", (Object)this.getIconUrlPropertyName());
        }
        return iconurl;
    }

    protected boolean getUseSystemProxy() {
        String useSystemProxy = this.getValueFromSwitchOrProp("Use System Proxy", HttpClientWrapperConfigHelper.PARAMETER_KEYS.useSystemProxy.name(), this.getUseSystemProxyPropertyName());
        if (useSystemProxy == null) {
            LOG.info("useSystemProxy is not specified as a notification command switch or via system property {}. Setting it to true (use system proxy settings).", (Object)this.getUseSystemProxyPropertyName());
            useSystemProxy = "true";
        }
        return Boolean.parseBoolean(useSystemProxy);
    }

    protected String getIconEmoji() {
        String iconemoji = this.getValueFromSwitchOrProp("Icon Emoji", "-iconemoji", this.getIconEmojiPropertyName());
        if (iconemoji == null) {
            LOG.info("No icon emoji specified as a notification command switch or via system property {}. Not setting one.", (Object)this.getIconEmojiPropertyName());
        }
        if (iconemoji != null && !iconemoji.startsWith(":") && !iconemoji.endsWith(":")) {
            LOG.warn("Specified icon emoji '{}' is not colon-enclosed. Did you mean to do this?", (Object)iconemoji);
        }
        return iconemoji;
    }

    protected String getChannel() {
        String channel = this.getValueFromSwitchOrProp("Channel name", "-channel", this.getChannelPropertyName());
        if (channel == null) {
            LOG.info("No channel specified as a notification command switch or via system property {}. Not setting one.", (Object)this.getChannelPropertyName());
        }
        return channel;
    }

    protected String getValueFromSwitchOrProp(String what, String switchName, String propName) {
        if (Strings.isNullOrEmpty((String)switchName)) {
            LOG.error("Switch name must not be null or empty");
            return null;
        }
        if (!switchName.startsWith("-")) {
            LOG.warn("Specifying switch names (e.g. '{}') without a leading dash is deprecated. Please update your notification command definition to use '-{}' instead. See https://issues.opennms.org/browse/NMS-10552", (Object)switchName, (Object)switchName);
        }
        LOG.debug("Trying to get {} from notification switch '{}'", (Object)what, (Object)switchName);
        if (this.hasSwitchName(switchName) && this.hasSwitchValue(switchName)) {
            String val = this.getSwitchValue(switchName);
            LOG.info("Using {} value {} from notification switch {}", new Object[]{what, val, switchName});
            return val;
        }
        String alternateSwitchName = switchName.startsWith("-") ? switchName.substring(1) : "-" + switchName;
        LOG.debug("Trying to get {} from notification switch '{}'", (Object)what, (Object)alternateSwitchName);
        if (this.hasSwitchValue(alternateSwitchName) && this.hasSwitchValue(alternateSwitchName)) {
            String val = this.getSwitchValue(alternateSwitchName);
            LOG.info("Using {} value {} from notification switch '{}'", new Object[]{what, val, switchName});
            return val;
        }
        if (propName != null) {
            LOG.debug("Trying to get {} from system property '{}'", (Object)what, (Object)propName);
            String val = System.getProperty(propName);
            if (val != null) {
                LOG.info("Using {} value {} from system property '{}'", new Object[]{what, val, propName});
                return val;
            }
        }
        LOG.warn("Could not determine value for {} from notification command switch '{}' or system property '{}'", new Object[]{what, switchName, propName});
        return null;
    }

    private String getSwitchValue(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            if (!"".equals(arg.getValue())) {
                value = arg.getValue();
                continue;
            }
            if ("".equals(arg.getSubstitution())) continue;
            value = arg.getSubstitution();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }

    protected String buildMessage(List<Argument> args) {
        String subject = this.getValueFromSwitchOrProp("Subject", "-subject", null);
        String body = this.getValueFromSwitchOrProp("Message Body", "-tm", null);
        StringBuilder bldr = new StringBuilder();
        if ("".equals(subject) || "RESOLVED: ".equals(subject)) {
            subject = null;
        } else {
            bldr.append(this.decorateMessageSubject(subject));
        }
        if ("".equals(body) || "RESOLVED: ".equals(body)) {
            body = null;
        } else {
            bldr.append(this.decorateMessageBody(body));
        }
        return bldr.toString();
    }

    protected String getValue(String switchName) {
        return this.getValueFromSwitchOrProp(switchName, switchName, null);
    }

    protected String getValue(String switchName, String systemPropertyName) {
        return this.getValueFromSwitchOrProp(switchName, switchName, systemPropertyName);
    }

    private boolean hasSwitchName(String theSwitchName) {
        return this.m_arguments.stream().anyMatch(a -> a.getSwitch().equals(theSwitchName));
    }

    private boolean hasSwitchValue(String theSwitchName) {
        List values = this.m_arguments.stream().filter(a -> a.getSwitch().equals(theSwitchName)).flatMap(a -> Lists.newArrayList((Object[])new String[]{a.getValue(), a.getSubstitution()}).stream()).filter(value -> value != null && !"".equals(value)).collect(Collectors.toList());
        return !values.isEmpty();
    }
}

