/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.InsufficientInformationException;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.MockServiceCollector;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceCollectorRegistry;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.DefaultServiceCollectorRegistry;
import org.opennms.netmgt.collection.test.api.CollectorTestUtils;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.config.dao.outages.api.OverrideablePollOutagesDao;
import org.opennms.netmgt.config.dao.outages.api.ReadablePollOutagesDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.dao.mock.MockTransactionTemplate;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.mock.MockPersisterFactory;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-testPollerConfigDaos.xml"})
@JUnitConfigurationEnvironment
public class CollectdIntegrationTest {
    protected static final String TEST_KEY_PARM_NAME = "key";
    private static Map<String, CollectdIntegrationTest> m_tests = new HashMap<String, CollectdIntegrationTest>();
    private EventIpcManager m_eventIpcManager;
    private Collectd m_collectd;
    private EasyMockUtils m_mockUtils;
    private CollectdConfigFactory m_collectdConfigFactory;
    private CollectdConfiguration m_collectdConfiguration;
    private String m_key;
    private MockServiceCollector m_serviceCollector;
    private IpInterfaceDao m_ifaceDao;
    private NodeDao m_nodeDao;
    private FilterDao m_filterDao;
    @Rule
    public TestName m_testName = new TestName();
    @Autowired
    private OverrideablePollOutagesDao m_pollOutagesDao;

    @Before
    public void setUp() throws Exception {
        this.m_eventIpcManager = new MockEventIpcManager();
        EventIpcManagerFactory.setIpcManager((EventIpcManager)this.m_eventIpcManager);
        this.m_mockUtils = new EasyMockUtils();
        this.m_filterDao = (FilterDao)this.m_mockUtils.createMock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        ClassPathResource resource = new ClassPathResource("etc/poll-outages.xml");
        this.m_pollOutagesDao.overrideConfig(resource.getInputStream());
        File homeDir = resource.getFile().getParentFile().getParentFile();
        System.setProperty("opennms.home", homeDir.getAbsolutePath());
        this.m_key = this.m_testName.getMethodName() + System.nanoTime();
        m_tests.put(this.m_key, this);
        Collector collector = new Collector();
        collector.setService("SNMP");
        collector.setClassName(MockServiceCollector.class.getName());
        Parameter param = new Parameter();
        param.setKey(TEST_KEY_PARM_NAME);
        param.setValue(this.m_key);
        collector.addParameter(param);
        this.m_collectdConfigFactory = (CollectdConfigFactory)this.m_mockUtils.createMock(CollectdConfigFactory.class);
        this.m_collectdConfiguration = (CollectdConfiguration)this.m_mockUtils.createMock(CollectdConfiguration.class);
        EasyMock.expect((Object)this.m_collectdConfigFactory.getCollectdConfig()).andReturn((Object)this.m_collectdConfiguration).anyTimes();
        EasyMock.expect((Object)this.m_collectdConfiguration.getCollectors()).andReturn(Collections.singletonList(collector)).anyTimes();
        EasyMock.expect((Object)this.m_collectdConfiguration.getThreads()).andReturn((Object)1).anyTimes();
        this.m_ifaceDao = (IpInterfaceDao)this.m_mockUtils.createMock(IpInterfaceDao.class);
        this.m_nodeDao = (NodeDao)this.m_mockUtils.createMock(NodeDao.class);
        this.m_collectd = new Collectd(){

            protected void handleInsufficientInfo(InsufficientInformationException e) {
                Assert.fail((String)("Invalid event received: " + e.getMessage()));
            }
        };
        this.m_collectd.setPollOutagesDao((ReadablePollOutagesDao)this.m_pollOutagesDao);
        ThresholdingService mockThresholdingService = (ThresholdingService)this.m_mockUtils.createMock(ThresholdingService.class);
        ThresholdingSession mockThresholdingSession = (ThresholdingSession)this.m_mockUtils.createMock(ThresholdingSession.class);
        EasyMock.expect((Object)mockThresholdingService.createSession(EasyMock.anyInt(), EasyMock.anyString(), EasyMock.anyString(), (RrdRepository)EasyMock.anyObject(), (ServiceParameters)EasyMock.anyObject())).andReturn((Object)mockThresholdingSession);
        this.m_collectd.setThresholdingService(mockThresholdingService);
        OnmsServiceType snmp = new OnmsServiceType("SNMP");
        NetworkBuilder netBuilder = new NetworkBuilder();
        NetworkBuilder.NodeBuilder nodeBuilder = netBuilder.addNode("node1").setId(Integer.valueOf(1));
        NetworkBuilder.InterfaceBuilder ifaceBlder = netBuilder.addInterface("192.168.1.1").setId(2).setIsSnmpPrimary("P");
        ifaceBlder.addSnmpInterface(1);
        OnmsMonitoredService svc = netBuilder.addService(snmp);
        List initialIfs = Collections.emptyList();
        EasyMock.expect((Object)this.m_ifaceDao.findByServiceType(snmp.getName())).andReturn(initialIfs).anyTimes();
        this.m_filterDao.flushActiveIpAddressListCache();
        EasyMock.expect((Object)this.m_nodeDao.load((Serializable)Integer.valueOf(1))).andReturn((Object)nodeBuilder.getNode()).anyTimes();
        this.createGetPackagesExpectation(svc);
        EasyMock.expect((Object)this.m_ifaceDao.load((Serializable)Integer.valueOf(2))).andReturn((Object)ifaceBlder.getInterface()).anyTimes();
        this.m_mockUtils.replayAll();
        MockTransactionTemplate transTemplate = new MockTransactionTemplate();
        transTemplate.afterPropertiesSet();
        this.m_collectd.setCollectdConfigFactory(this.m_collectdConfigFactory);
        this.m_collectd.setEventIpcManager(this.m_eventIpcManager);
        this.m_collectd.setTransactionTemplate((TransactionTemplate)transTemplate);
        this.m_collectd.setIpInterfaceDao(this.m_ifaceDao);
        this.m_collectd.setNodeDao(this.m_nodeDao);
        this.m_collectd.setFilterDao(this.m_filterDao);
        this.m_collectd.setPersisterFactory((PersisterFactory)new MockPersisterFactory());
        this.m_collectd.setServiceCollectorRegistry((ServiceCollectorRegistry)new DefaultServiceCollectorRegistry());
        this.m_collectd.setLocationAwareCollectorClient(CollectorTestUtils.createLocationAwareCollectorClient());
        this.m_collectd.afterPropertiesSet();
    }

    public static void setServiceCollectorInTest(String testKey, MockServiceCollector collector) {
        CollectdIntegrationTest test = m_tests.get(testKey);
        Assert.assertNotNull((Object)test);
        test.setServiceCollector(collector);
    }

    private void setServiceCollector(MockServiceCollector collector) {
        this.m_serviceCollector = collector;
    }

    @After
    public void tearDown() {
        m_tests.remove(this.m_key);
    }

    @Test
    public void testIt() throws InterruptedException {
        this.m_collectd.start();
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeGainedService", "Test");
        bldr.setNodeid(1L);
        bldr.setInterface(InetAddressUtils.addr((String)"192.168.1.1"));
        bldr.setService("SNMP");
        this.m_collectd.onEvent(bldr.getEvent());
        Thread.sleep(2000L);
        Assert.assertNotNull((Object)this.m_serviceCollector);
        Assert.assertEquals((long)1L, (long)this.m_serviceCollector.getCollectCount());
        this.m_mockUtils.verifyAll();
    }

    private void createGetPackagesExpectation(OnmsMonitoredService svc) {
        String rule = "ipaddr = '" + InetAddressUtils.str((InetAddress)svc.getIpAddress()) + "'";
        Package pkg = new Package();
        pkg.setName("testPackage");
        Filter filter = new Filter();
        filter.setContent(rule);
        pkg.setFilter(filter);
        Service collector = new Service();
        collector.setName("SNMP");
        collector.setStatus("on");
        collector.setInterval(Long.valueOf(3000L));
        Parameter parm = new Parameter();
        parm.setKey(TEST_KEY_PARM_NAME);
        parm.setValue(this.m_key);
        collector.setParameters(Collections.singletonList(parm));
        pkg.addService(collector);
        EasyMock.expect((Object)this.m_collectdConfiguration.getPackages()).andReturn(Collections.singletonList(pkg));
        EasyMock.expect((Object)this.m_collectdConfigFactory.interfaceInPackage((OnmsIpInterface)EasyMock.anyObject(OnmsIpInterface.class), (Package)EasyMock.eq((Object)pkg))).andReturn((Object)true);
    }
}

