/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.datablock;

import java.util.LinkedList;
import java.util.ListIterator;
import org.opennms.netmgt.rtc.datablock.RTCNodeSvcTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTCNodeSvcTimesList
extends LinkedList<RTCNodeSvcTime> {
    private static final Logger LOG = LoggerFactory.getLogger(RTCNodeSvcTimesList.class);
    private static final long serialVersionUID = 2606739258065019820L;
    private final long m_rollingWindow;

    private void removeExpiredOutages() {
        long curTime = System.currentTimeMillis();
        this.removeExpiredOutages(curTime, this.m_rollingWindow);
    }

    private void removeExpiredOutages(long curTime, long rollingWindow) {
        RTCNodeSvcTime svcTime;
        long startTime = curTime - rollingWindow;
        ListIterator iter = this.listIterator();
        while (iter.hasNext() && (svcTime = (RTCNodeSvcTime)iter.next()).getLostTime() < startTime) {
            if (!svcTime.hasExpired(startTime)) continue;
            iter.remove();
        }
    }

    public RTCNodeSvcTimesList(long rollingWindow) {
        this.m_rollingWindow = rollingWindow;
    }

    public void addSvcTime(long losttime, long regainedtime) {
        this.removeExpiredOutages();
        if (regainedtime > 0L && regainedtime < losttime) {
            LOG.warn("RTCNodeSvcTimesList: Rejecting service time pair since regained time in milliseconds: {} less than lost time -> losttime in milliseconds: {}", (Object)regainedtime, (Object)losttime);
            return;
        }
        this.addLast(new RTCNodeSvcTime(losttime, regainedtime));
    }

    public void addSvcTime(long losttime) {
        this.removeExpiredOutages();
        this.addLast(new RTCNodeSvcTime(losttime));
    }

    public long getDownTime(long curTime, long rollingWindow) {
        this.removeExpiredOutages(curTime, rollingWindow);
        long outTime = 0L;
        for (RTCNodeSvcTime svcTime : this) {
            outTime += svcTime.getDownTime(curTime, rollingWindow);
        }
        return outTime;
    }
}

