/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.config.statsd.model.PackageReport;
import org.opennms.netmgt.config.statsd.model.StatsdPackage;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.BottomNAttributeStatisticVisitor;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.mock.MockResourceType;
import org.opennms.netmgt.model.ExternalValueAttribute;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.statsd.RelativeTime;
import org.opennms.netmgt.statsd.ReportDefinition;
import org.opennms.netmgt.statsd.ReportInstance;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class ReportDefinitionTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private NodeDao m_nodeDao = (NodeDao)this.m_mocks.createMock(NodeDao.class);
    private ResourceDao m_resourceDao = (ResourceDao)this.m_mocks.createMock(ResourceDao.class);
    private MeasurementFetchStrategy m_fetchStrategy = (MeasurementFetchStrategy)this.m_mocks.createMock(MeasurementFetchStrategy.class);
    private FilterDao m_filterDao = (FilterDao)this.m_mocks.createMock(FilterDao.class);

    protected void runTest() throws Throwable {
        super.runTest();
        this.m_mocks.verifyAll();
    }

    public void testBogusReportClass() throws Exception {
        this.m_mocks.replayAll();
        ReportDefinition def = new ReportDefinition();
        Class<?> clazz = Class.forName("java.lang.String");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            def.setReportClass(clazz);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSet() {
        this.m_mocks.replayAll();
        ReportDefinitionTest.createReportDefinition();
    }

    public void testReportWalking() throws Exception {
        EasyMock.expect((Object)this.m_resourceDao.findTopLevelResources()).andReturn(new ArrayList(0));
        ReportDefinition def = ReportDefinitionTest.createReportDefinition();
        def.setResourceAttributeKey("ifSpeed");
        def.setResourceAttributeValueMatch("100000000");
        ReportInstance report = def.createReport(this.m_nodeDao, this.m_resourceDao, this.m_fetchStrategy, this.m_filterDao);
        this.m_mocks.replayAll();
        report.walk();
        ReportDefinitionTest.assertEquals((String)"results size", (int)0, (int)report.getResults().size());
    }

    public void testUnfilteredResourceAttributeFilteringWithNoMatch() throws Exception {
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interfaceSnmp");
        RrdGraphAttribute attribute = new RrdGraphAttribute("IfInOctets", "something", "something else");
        OnmsResource resource = new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, Collections.singleton(attribute), ResourcePath.get((String[])new String[]{"foo"}));
        EasyMock.expect((Object)this.m_resourceDao.findTopLevelResources()).andReturn(Collections.singletonList(resource));
        ReportDefinition def = ReportDefinitionTest.createReportDefinition();
        def.setResourceAttributeKey("ifSpeed");
        def.setResourceAttributeValueMatch("100000000");
        ReportInstance report = def.createReport(this.m_nodeDao, this.m_resourceDao, this.m_fetchStrategy, this.m_filterDao);
        this.m_mocks.replayAll();
        report.walk();
        ReportDefinitionTest.assertEquals((String)"results size", (int)0, (int)report.getResults().size());
    }

    public void testUnfilteredResourceAttributeFilteringWithMatch() throws Exception {
        RrdGraphAttribute rrdAttribute = new RrdGraphAttribute("IfInOctets", "something", "something else");
        ExternalValueAttribute externalValueAttribute = new ExternalValueAttribute("ifSpeed", "100000000");
        HashSet<Object> attributes = new HashSet<Object>();
        attributes.add(rrdAttribute);
        attributes.add(externalValueAttribute);
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interfaceSnmp");
        OnmsResource resource = new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, attributes, ResourcePath.get((String[])new String[]{"foo"}));
        EasyMock.expect((Object)this.m_resourceDao.findTopLevelResources()).andReturn(Collections.singletonList(resource));
        ReportDefinition def = ReportDefinitionTest.createReportDefinition();
        def.setResourceAttributeKey(externalValueAttribute.getName());
        def.setResourceAttributeValueMatch(externalValueAttribute.getValue());
        ReportInstance report = def.createReport(this.m_nodeDao, this.m_resourceDao, this.m_fetchStrategy, this.m_filterDao);
        rrdAttribute.setResource(new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, Collections.singleton(rrdAttribute), ResourcePath.get((String[])new String[]{"foo"})));
        Source source = new Source();
        source.setLabel("result");
        source.setResourceId(rrdAttribute.getResource().getId().toString());
        source.setAttribute(rrdAttribute.getName());
        source.setAggregation("AVERAGE");
        FetchResults results = new FetchResults(new long[]{report.getStartTime()}, Collections.singletonMap("result", new double[]{100.0}), report.getEndTime() - report.getStartTime(), Collections.emptyMap(), null);
        EasyMock.expect((Object)this.m_fetchStrategy.fetch(report.getStartTime(), report.getEndTime(), 1L, 0, null, null, Collections.singletonList(source), false)).andReturn((Object)results);
        this.m_mocks.replayAll();
        report.walk();
        this.m_mocks.verifyAll();
        ReportDefinitionTest.assertEquals((String)"results size", (int)1, (int)report.getResults().size());
        this.m_mocks.replayAll();
    }

    public void testFilteredResourceAttributeFilteringWithNoMatch() throws Exception {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.setLabel("Node One");
        EasyMock.expect((Object)this.m_nodeDao.load((Serializable)Integer.valueOf(1))).andReturn((Object)node);
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interfaceSnmp");
        RrdGraphAttribute attribute = new RrdGraphAttribute("IfInOctets", "something", "something else");
        OnmsResource resource = new OnmsResource(node.getId().toString(), node.getLabel(), (OnmsResourceType)resourceType, Collections.singleton(attribute), ResourcePath.get((String[])new String[]{"foo"}));
        ReportDefinition def = ReportDefinitionTest.createReportDefinition();
        def.getReport().getPackage().setFilter("");
        def.setResourceAttributeKey("ifSpeed");
        def.setResourceAttributeValueMatch("100000000");
        ReportInstance report = def.createReport(this.m_nodeDao, this.m_resourceDao, this.m_fetchStrategy, this.m_filterDao);
        TreeMap<Integer, String> sortedNodeMap = new TreeMap<Integer, String>();
        sortedNodeMap.put(node.getId(), node.getLabel());
        EasyMock.expect((Object)this.m_filterDao.getNodeMap("")).andReturn(sortedNodeMap);
        EasyMock.expect((Object)this.m_resourceDao.getResourceForNode(node)).andReturn((Object)resource);
        this.m_mocks.replayAll();
        report.walk();
        ReportDefinitionTest.assertEquals((String)"results size", (int)0, (int)report.getResults().size());
    }

    public void testFilteredResourceAttributeFilteringWithMatch() throws Exception {
        RrdGraphAttribute rrdAttribute = new RrdGraphAttribute("IfInOctets", "something", "something else");
        ExternalValueAttribute externalValueAttribute = new ExternalValueAttribute("ifSpeed", "100000000");
        HashSet<Object> attributes = new HashSet<Object>();
        attributes.add(rrdAttribute);
        attributes.add(externalValueAttribute);
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.setLabel("Node One");
        EasyMock.expect((Object)this.m_nodeDao.load((Serializable)Integer.valueOf(1))).andReturn((Object)node);
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interfaceSnmp");
        OnmsResource resource = new OnmsResource(node.getId().toString(), node.getLabel(), (OnmsResourceType)resourceType, attributes, ResourcePath.get((String[])new String[]{"foo"}));
        ReportDefinition def = ReportDefinitionTest.createReportDefinition();
        def.getReport().getPackage().setFilter("");
        def.setResourceAttributeKey(externalValueAttribute.getName());
        def.setResourceAttributeValueMatch(externalValueAttribute.getValue());
        ReportInstance report = def.createReport(this.m_nodeDao, this.m_resourceDao, this.m_fetchStrategy, this.m_filterDao);
        TreeMap<Integer, String> sortedNodeMap = new TreeMap<Integer, String>();
        sortedNodeMap.put(node.getId(), node.getLabel());
        EasyMock.expect((Object)this.m_filterDao.getNodeMap("")).andReturn(sortedNodeMap);
        EasyMock.expect((Object)this.m_resourceDao.getResourceForNode(node)).andReturn((Object)resource);
        Source source = new Source();
        source.setLabel("result");
        source.setResourceId(resource.getId().toString());
        source.setAttribute(rrdAttribute.getName());
        source.setAggregation("AVERAGE");
        FetchResults results = new FetchResults(new long[]{report.getStartTime()}, Collections.singletonMap("result", new double[]{100.0}), report.getEndTime() - report.getStartTime(), Collections.emptyMap(), null);
        EasyMock.expect((Object)this.m_fetchStrategy.fetch(report.getStartTime(), report.getEndTime(), 1L, 0, null, null, Collections.singletonList(source), false)).andReturn((Object)results);
        this.m_mocks.replayAll();
        report.walk();
        ReportDefinitionTest.assertEquals((String)"results size", (int)1, (int)report.getResults().size());
    }

    private static ReportDefinition createReportDefinition() {
        ReportDefinition def = new ReportDefinition();
        def.setReport(ReportDefinitionTest.createPackageReport());
        def.setCount(Integer.valueOf(10));
        def.setConsolidationFunction("AVERAGE");
        def.setRelativeTime(RelativeTime.LASTHOUR);
        def.setResourceTypeMatch("interfaceSnmp");
        def.setAttributeMatch("IfInOctets");
        def.setReportClass(BottomNAttributeStatisticVisitor.class);
        def.afterPropertiesSet();
        return def;
    }

    private static PackageReport createPackageReport() {
        PackageReport packageReport = new PackageReport();
        packageReport.setDescription("a package!");
        packageReport.setEnabled(true);
        packageReport.setPackage(new StatsdPackage());
        packageReport.setReport(null);
        packageReport.setRetainInterval(Long.valueOf(86400000L));
        packageReport.setSchedule("hmm");
        return packageReport;
    }
}

