/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.mock.MockRpcClientFactory;
import org.opennms.core.test.MockPlatformTransactionManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.DefaultSnmpCollectionAgent;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.RrdPersisterFactory;
import org.opennms.netmgt.collection.support.CollectionSetVisitorWrapper;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.MibObject;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.mock.MockDataCollectionConfig;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValueFactory;
import org.opennms.test.FileAnticipator;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.transaction.PlatformTransactionManager;

public class SnmpAttributeTest {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private IpInterfaceDao m_ipInterfaceDao = (IpInterfaceDao)this.m_mocks.createMock(IpInterfaceDao.class);
    private FileAnticipator m_fileAnticipator = null;
    private File m_snmpDirectory = null;
    private RrdStrategy<Object, Object> m_rrdStrategy = (RrdStrategy)this.m_mocks.createMock(RrdStrategy.class);
    private FilesystemResourceStorageDao m_resourceStorageDao = (FilesystemResourceStorageDao)this.m_mocks.createMock(FilesystemResourceStorageDao.class);
    private LocationAwareSnmpClient m_locationAwareSnmpClient = new LocationAwareSnmpClientRpcImpl((RpcClientFactory)new MockRpcClientFactory());

    @Before
    public void setUp() throws IOException {
        this.m_fileAnticipator = new FileAnticipator();
    }

    @After
    public void tearDown() {
        this.m_mocks.verifyAll();
        this.m_fileAnticipator.deleteExpected();
        this.m_fileAnticipator.tearDown();
    }

    @Test
    public void testNumericAttributeFloatValueInString() throws Exception {
        String stringValue = "7.69";
        this.testPersisting(stringValue, new Snmp4JValueFactory().getOctetString(stringValue.getBytes()));
    }

    @Test
    public void testNumericAttributeCounterValue() throws Exception {
        int intValue = 769;
        this.testPersisting(Integer.toString(intValue), new Snmp4JValueFactory().getCounter32((long)intValue));
    }

    @Test
    public void testHexStringProtoCounter64ValueSmall() throws Exception {
        this.testPersisting("769", new Snmp4JValueFactory().getOctetString(new byte[]{0, 0, 0, 0, 0, 0, 3, 1}));
    }

    @Test
    public void testHexStringProtoCounter64ValueLT2_31() throws Exception {
        this.testPersisting("2000000000", new Snmp4JValueFactory().getOctetString(new byte[]{0, 0, 0, 0, 119, 53, -108, 0}));
    }

    @Test
    public void testHexStringProtoCounter64ValueGT2_31() throws Exception {
        this.testPersisting("5000000000", new Snmp4JValueFactory().getOctetString(new byte[]{0, 0, 0, 1, 42, 5, -14, 0}));
    }

    @Test
    public void testHexStringProtoCounter64ValueNear2_63() throws Exception {
        this.testPersisting("9223372036854775000", new Snmp4JValueFactory().getOctetString(new byte[]{127, -1, -1, -1, -1, -1, -4, -40}));
    }

    @Test
    public void testNumericAttributeHexStringValueInString() throws Exception {
        String stringValue = "769";
        byte[] bytes = new byte[]{0, 0, 0, 0, 0, 0, 3, 1};
        this.testPersisting(stringValue, new Snmp4JValueFactory().getOctetString(bytes));
    }

    @Ignore
    private void testPersisting(String matchValue, SnmpValue snmpValue) throws Exception {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(3));
        OnmsIpInterface ipInterface = new OnmsIpInterface();
        ipInterface.setId(Integer.valueOf(1));
        ipInterface.setNode(node);
        ipInterface.setIpAddress(InetAddressUtils.addr((String)"192.168.1.1"));
        EasyMock.expect((Object)this.m_ipInterfaceDao.load((Serializable)Integer.valueOf(1))).andReturn((Object)ipInterface).times(5);
        EasyMock.expect((Object)this.m_rrdStrategy.getDefaultFileExtension()).andReturn((Object)".myLittleEasyMockedStrategyAndMe").anyTimes();
        EasyMock.expect((Object)this.m_rrdStrategy.createDefinition((String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), EasyMock.anyInt(), this.isAList(RrdDataSource.class), this.isAList(String.class))).andReturn(new Object());
        this.m_rrdStrategy.createFile(EasyMock.isA(Object.class));
        EasyMock.expect((Object)this.m_rrdStrategy.openFile((String)EasyMock.isA(String.class))).andReturn(new Object());
        this.m_rrdStrategy.updateFile(EasyMock.isA(Object.class), (String)EasyMock.isA(String.class), EasyMock.matches((String)(".*:" + matchValue)));
        this.m_rrdStrategy.closeFile(EasyMock.isA(Object.class));
        this.m_mocks.replayAll();
        SnmpCollectionAgent agent = DefaultSnmpCollectionAgent.create((Integer)ipInterface.getId(), (IpInterfaceDao)this.m_ipInterfaceDao, (PlatformTransactionManager)new MockPlatformTransactionManager());
        OnmsSnmpCollection snmpCollection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)new MockDataCollectionConfig(), this.m_locationAwareSnmpClient);
        NodeResourceType resourceType = new NodeResourceType(agent, snmpCollection);
        NodeInfo nodeInfo = resourceType.getNodeInfo();
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.3.6.1.4.1.12238.55.9997.4.1.2.9.116.101.109.112.95.117.108.107.111");
        mibObject.setInstance("1");
        mibObject.setAlias("temp_ulko");
        mibObject.setType("gauge");
        NumericAttributeType attributeType = new NumericAttributeType((ResourceType)resourceType, snmpCollection.getName(), mibObject, new AttributeGroupType("foo", "ignore"));
        attributeType.storeResult(new SnmpCollectionSet(agent, snmpCollection, this.m_locationAwareSnmpClient), null, new SnmpResult(mibObject.getSnmpObjId(), new SnmpInstId(mibObject.getInstance()), snmpValue));
        RrdRepository repository = this.createRrdRepository();
        repository.setRraList(Collections.singletonList("RRA:AVERAGE:0.5:1:2016"));
        RrdPersisterFactory persisterFactory = new RrdPersisterFactory();
        persisterFactory.setRrdStrategy(this.m_rrdStrategy);
        persisterFactory.setResourceStorageDao((ResourceStorageDao)this.m_resourceStorageDao);
        Persister persister = persisterFactory.createPersister(new ServiceParameters(Collections.emptyMap()), repository);
        final AtomicInteger count = new AtomicInteger(0);
        nodeInfo.visit((CollectionSetVisitor)new CollectionSetVisitorWrapper((CollectionSetVisitor)persister){

            public void visitAttribute(CollectionAttribute attribute) {
                super.visitAttribute(attribute);
                count.incrementAndGet();
            }
        });
        Assert.assertEquals((long)1L, (long)count.get());
    }

    public void test8DigitDecimalNumericAttributeStringValue() throws Exception {
        String longValue = "49197860";
        this.testPersisting(new Double(longValue).toString(), new Snmp4JValueFactory().getOctetString(longValue.getBytes(StandardCharsets.UTF_8)));
    }

    private <T> List<T> isAList(Class<T> clazz) {
        return (List)EasyMock.isA(List.class);
    }

    private RrdRepository createRrdRepository() throws IOException {
        RrdRepository repository = new RrdRepository();
        repository.setRrdBaseDir(this.getSnmpRrdDirectory());
        repository.setHeartBeat(600);
        repository.setStep(300);
        repository.setRraList(Collections.singletonList("RRA:AVERAGE:0.5:1:100"));
        return repository;
    }

    private File getSnmpRrdDirectory() throws IOException {
        if (this.m_snmpDirectory == null) {
            this.m_snmpDirectory = this.m_fileAnticipator.tempDir("snmp");
        }
        return this.m_snmpDirectory;
    }
}

