/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.io.InputStream;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.RTCConfigFactory;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.rtc.AvailabilityService;
import org.opennms.netmgt.rtc.HttpUtils;
import org.opennms.netmgt.rtc.datablock.HttpPostInfo;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.netmgt.xml.rtc.EuiLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventListener(name="RTC:DataSender", logPrefix="rtc")
public class DataSender
implements Fiber {
    private static final Logger LOG = LoggerFactory.getLogger(DataSender.class);
    private final Map<String, Set<HttpPostInfo>> m_catUrlMap = new HashMap<String, Set<HttpPostInfo>>();
    final BlockingQueue<Runnable> m_queue;
    private final ExecutorService m_dsrPool;
    private final int POST_ERROR_LIMIT;
    private int m_status;
    private final AvailabilityService m_dataMgr;

    public DataSender(AvailabilityService dataMgr, RTCConfigFactory configFactory) {
        this.m_dataMgr = dataMgr;
        this.m_queue = new LinkedBlockingDeque<Runnable>(Math.max(4 * configFactory.getSenders(), 32));
        this.m_dsrPool = new ThreadPoolExecutor(1, configFactory.getSenders(), 30L, TimeUnit.SECONDS, this.m_queue, (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName(), configFactory.getSenders()));
        this.POST_ERROR_LIMIT = configFactory.getErrorsBeforeUrlUnsubscribe();
    }

    public synchronized void start() {
        this.m_status = 2;
    }

    public synchronized void stop() {
        this.m_status = 3;
        LOG.info("DataSender - shutting down the data sender pool");
        try {
            this.m_dsrPool.shutdown();
        }
        catch (Throwable t) {
            LOG.error("Error shutting down data sender pool", t);
        }
        this.m_status = 4;
        LOG.info("DataSender shutdown complete");
    }

    public String getName() {
        return "OpenNMS.RTC.DataSender";
    }

    public int getStatus() {
        return this.m_status;
    }

    public synchronized void subscribe(final String url, final String catlabel, final String user, final String passwd) {
        HttpPostInfo postInfo;
        final RTCCategory cat = this.m_dataMgr.getCategories().get(catlabel);
        if (cat == null) {
            LOG.warn("RTC: No information available for category: {}", (Object)catlabel);
            return;
        }
        try {
            postInfo = new HttpPostInfo(url, catlabel, user, passwd);
        }
        catch (MalformedURLException mue) {
            LOG.warn("ERROR subscribing: Invalid URL '{}' - Data WILL NOT be SENT to the specified url", (Object)url);
            return;
        }
        Set<HttpPostInfo> urlList = this.m_catUrlMap.get(catlabel);
        if (urlList == null) {
            urlList = new HashSet<HttpPostInfo>();
            this.m_catUrlMap.put(catlabel, urlList);
        }
        if (!urlList.add(postInfo)) {
            LOG.debug("Already subscribed to URL: {}\tcatlabel: {}\tuser: {} - IGNORING LATEST subscribe event", new Object[]{url, catlabel, user});
        } else {
            LOG.debug("Subscribed to URL: {}\tcatlabel: {}\tuser:{}", new Object[]{url, catlabel, user});
        }
        try {
            this.m_dsrPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    InputStream inp = null;
                    try {
                        int bytesRead;
                        LOG.debug("DataSender: posting data to: {}", (Object)url);
                        EuiLevel euidata = DataSender.this.m_dataMgr.getEuiLevel(cat);
                        String marshaledUeiData = JaxbUtils.marshal((Object)euidata);
                        try (StringReader inr = new StringReader(marshaledUeiData);){
                            inp = HttpUtils.post(postInfo.getURL(), inr, user, passwd, 8192, 60000);
                        }
                        byte[] tmp = new byte[1024];
                        while ((bytesRead = inp.read(tmp)) != -1) {
                            if (!LOG.isDebugEnabled() || bytesRead <= 0) continue;
                            LOG.debug("DataSender: post response: {}", (Object)new String(tmp, 0, bytesRead));
                        }
                        LOG.debug("DataSender: posted data for category: {}", (Object)catlabel);
                        IOUtils.closeQuietly((InputStream)inp);
                    }
                    catch (ConnectException e) {
                        LOG.warn("DataSender:  Unable to send category '{}' to URL '{}': {}", new Object[]{catlabel, url, e.getMessage()});
                    }
                    catch (Throwable t) {
                        LOG.warn("DataSender:  Unable to send category '{}' to URL '{}'", new Object[]{catlabel, url, t});
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly(inp);
                    }
                    finally {
                        IOUtils.closeQuietly(inp);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOG.warn("Unable to queue datasender. The task was rejected by the pool. Current queue size: {}.", (Object)this.m_queue.size(), (Object)e);
        }
    }

    public synchronized void unsubscribe(String urlStr) {
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException mue) {
            LOG.warn("ERROR unsubscribing: Invalid URL: {}", (Object)urlStr);
            return;
        }
        for (String key : this.m_catUrlMap.keySet()) {
            Set<HttpPostInfo> value = this.m_catUrlMap.get(key);
            if (value == null) continue;
            Iterator<HttpPostInfo> postSet = value.iterator();
            while (postSet.hasNext()) {
                HttpPostInfo postInfo = postSet.next();
                if (!url.toExternalForm().equals(postInfo.getURL().toExternalForm())) continue;
                postSet.remove();
            }
        }
        LOG.debug("Unsubscribed URL: {}", (Object)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendData() {
        LOG.debug("In DataSender sendData()");
        for (RTCCategory cat : this.m_dataMgr.getCategories().values()) {
            EuiLevel euidata;
            String catlabel = cat.getLabel();
            LOG.debug("DataSender:sendData(): Category '{}'", (Object)catlabel);
            Set<HttpPostInfo> urlList = this.m_catUrlMap.get(catlabel);
            if (urlList == null || urlList.size() <= 0) {
                LOG.debug("DataSender: category '{}' has no listeners", (Object)catlabel);
                continue;
            }
            LOG.debug("DataSender: category '{}' has listeners - converting to xml...", (Object)catlabel);
            try {
                euidata = this.m_dataMgr.getEuiLevel(cat);
            }
            catch (Throwable t) {
                LOG.warn("DataSender: unable to convert data to xml for category: '{}'", (Object)catlabel, (Object)t);
                continue;
            }
            if (urlList == null || urlList.size() <= 0) continue;
            Iterator<HttpPostInfo> urlIter = urlList.iterator();
            while (urlIter.hasNext()) {
                HttpPostInfo postInfo = urlIter.next();
                InputStream inp = null;
                try {
                    int bytesRead;
                    LOG.debug("DataSender: posting data to: {}", (Object)postInfo.getURLString());
                    String marshaledUeiData = JaxbUtils.marshal((Object)euidata);
                    try (StringReader inr = new StringReader(marshaledUeiData);){
                        inp = HttpUtils.post(postInfo.getURL(), inr, postInfo.getUser(), postInfo.getPassword(), 8192, -1);
                    }
                    LOG.debug("DataSender: posted data for category: {}", (Object)catlabel);
                    byte[] tmp = new byte[1024];
                    while ((bytesRead = inp.read(tmp)) != -1) {
                        if (!LOG.isDebugEnabled() || bytesRead <= 0) continue;
                        LOG.debug("DataSender: post response: {}", (Object)new String(tmp, 0, bytesRead));
                    }
                    postInfo.clearErrors();
                }
                catch (Throwable t) {
                    try {
                        LOG.warn("DataSender: unable to send data for category: {} due to {}: {}", new Object[]{catlabel, t.getClass().getName(), t.getMessage(), t});
                        postInfo.incrementErrors();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inp);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inp);
                }
                IOUtils.closeQuietly((InputStream)inp);
                if (this.POST_ERROR_LIMIT <= 0 || postInfo.getErrors() < this.POST_ERROR_LIMIT) continue;
                urlIter.remove();
                LOG.warn("URL {} UNSUBSCRIBED due to reaching error limit {}", (Object)postInfo.getURLString(), (Object)postInfo.getErrors());
            }
        }
    }

    public synchronized void notifyToSend() {
        try {
            this.m_dsrPool.execute(new SendRequest());
        }
        catch (RejectedExecutionException e) {
            LOG.warn("Unable to queue datasender. The task was rejected by the pool. Current queue size: {}.", (Object)this.m_queue.size(), (Object)e);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/rtc/subscribe")
    public void handleRtcSubscribe(Event event) {
        List list = event.getParmCollection();
        if (list == null) {
            LOG.warn("{} ignored - info incomplete (null event parms)", (Object)event.getUei());
            return;
        }
        String url = null;
        String clabel = null;
        String user = null;
        String passwd = null;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : list) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (parmName.equals("url")) {
                url = parmContent;
                continue;
            }
            if (parmName.equals("catlabel")) {
                clabel = parmContent;
                continue;
            }
            if (parmName.equals("user")) {
                user = parmContent;
                continue;
            }
            if (!parmName.equals("passwd")) continue;
            passwd = parmContent;
        }
        if (url == null || clabel == null || user == null || passwd == null) {
            LOG.warn("{} did not have all required information. Values contained url: {} catlabel: {} user: {} passwd: {}", new Object[]{event.getUei(), url, clabel, user, passwd});
        } else {
            this.subscribe(url, clabel, user, passwd);
            LOG.debug("{} subscribed {}: {}: {}", new Object[]{event.getUei(), url, clabel, user});
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/rtc/unsubscribe")
    public void handleRtcUnsubscribe(Event event) {
        List list = event.getParmCollection();
        if (list == null) {
            LOG.warn("{} ignored - info incomplete (null event parms)", (Object)event.getUei());
            return;
        }
        String url = null;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : list) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (!parmName.equals("url")) continue;
            url = parmContent;
        }
        if (url == null) {
            LOG.warn("{} did not have required information.  Value of url: {}", (Object)event.getUei(), url);
        } else {
            this.unsubscribe(url);
            LOG.debug("{} unsubscribed {}", (Object)event.getUei(), url);
        }
    }

    private class SendRequest
    implements Runnable {
        private SendRequest() {
        }

        @Override
        public void run() {
            DataSender.this.sendData();
        }
    }
}

