/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public final class HttpPostMonitor
extends AbstractServiceMonitor {
    private static final int DEFAULT_PORT = 80;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    public static final String DEFAULT_MIMETYPE = "text/xml";
    public static final String DEFAULT_CHARSET = "utf-8";
    public static final String DEFAULT_URI = "/";
    public static final String DEFAULT_SCHEME = "http";
    public static final boolean DEFAULT_SSLFILTER = false;
    public static final String PARAMETER_SCHEME = "scheme";
    public static final String PARAMETER_PORT = "port";
    public static final String PARAMETER_URI = "uri";
    public static final String PARAMETER_PAYLOAD = "payload";
    public static final String PARAMETER_MIMETYPE = "mimetype";
    public static final String PARAMETER_CHARSET = "charset";
    public static final String PARAMETER_BANNER = "banner";
    public static final String PARAMETER_SSLFILTER = "usesslfiler";
    public static final String PARAMETER_USERNAME = "auth-username";
    public static final String PARAMETER_PASSWORD = "auth-password";
    private static final Logger LOG = LoggerFactory.getLogger(HttpPostMonitor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        tracker = new TimeoutTracker(parameters, 0, 3000);
        port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)80);
        strURI = ParameterMap.getKeyedString(parameters, (String)"uri", (String)"/");
        strUser = ParameterMap.getKeyedString(parameters, (String)"auth-username", null);
        strPasswd = ParameterMap.getKeyedString(parameters, (String)"auth-password", null);
        strBannerMatch = ParameterMap.getKeyedString(parameters, (String)"banner", null);
        strScheme = ParameterMap.getKeyedString(parameters, (String)"scheme", (String)"http");
        strPayload = ParameterMap.getKeyedString(parameters, (String)"payload", null);
        strMimetype = ParameterMap.getKeyedString(parameters, (String)"mimetype", (String)"text/xml");
        strCharset = ParameterMap.getKeyedString(parameters, (String)"charset", (String)"utf-8");
        boolSSLFilter = ParameterMap.getKeyedBoolean(parameters, (String)"usesslfiler", (boolean)false);
        ipAddr = svc.getAddress();
        hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        HttpPostMonitor.LOG.debug("poll: address = {}, port = {}, {}", new Object[]{hostAddress, port, tracker});
        serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() != false) {
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                if (serviceStatus.isAvailable() != false) return serviceStatus;
                                clientWrapper = null;
                                tracker.startAttempt();
                                clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(tracker.getSoTimeout())).setSocketTimeout(Integer.valueOf(tracker.getSoTimeout())).setRetries(Integer.valueOf(0));
                                if (boolSSLFilter) {
                                    clientWrapper.trustSelfSigned(strScheme);
                                }
                                if (strUser != null && strPasswd != null) {
                                    clientWrapper.addBasicCredentials(strUser, strPasswd);
                                }
                                try {
                                    postReq = new StringEntity(strPayload, ContentType.create((String)strMimetype, (String)strCharset));
                                }
                                catch (UnsupportedCharsetException e) {
                                    serviceStatus = PollStatus.unavailable("Unsupported encoding encountered while constructing POST body " + e);
                                    IOUtils.closeQuietly((Closeable)clientWrapper);
                                    return serviceStatus;
                                }
                                ub = new URIBuilder();
                                ub.setScheme(strScheme);
                                ub.setHost(hostAddress);
                                ub.setPort(port);
                                ub.setPath(strURI);
                                HttpPostMonitor.LOG.debug("HttpPostMonitor: Constructed URL is {}", (Object)ub);
                                post = new HttpPost(ub.build());
                                post.setEntity((HttpEntity)postReq);
                                response = clientWrapper.execute((HttpUriRequest)post);
                                HttpPostMonitor.LOG.debug("HttpPostMonitor: Status Line is {}", (Object)response.getStatusLine());
                                if (response.getStatusLine().getStatusCode() <= 399) break block16;
                                HttpPostMonitor.LOG.info("HttpPostMonitor: Got response status code {}", (Object)response.getStatusLine().getStatusCode());
                                HttpPostMonitor.LOG.debug("HttpPostMonitor: Received server response: {}", (Object)response.getStatusLine());
                                HttpPostMonitor.LOG.debug("HttpPostMonitor: Failing on bad status code");
                                serviceStatus = PollStatus.unavailable("HTTP(S) Status code " + response.getStatusLine().getStatusCode());
                                IOUtils.closeQuietly((Closeable)clientWrapper);
                                return serviceStatus;
                            }
                            HttpPostMonitor.LOG.debug("HttpPostMonitor: Response code is valid");
                            responseTime = tracker.elapsedTimeInMillis();
                            entity = response.getEntity();
                            responseStream = entity.getContent();
                            Strresponse = IOUtils.toString((InputStream)responseStream);
                            if (Strresponse != null) break block17;
                            IOUtils.closeQuietly((Closeable)clientWrapper);
                            break block20;
                        }
                        HttpPostMonitor.LOG.debug("HttpPostMonitor: banner = {}", (Object)Strresponse);
                        HttpPostMonitor.LOG.debug("HttpPostMonitor: responseTime= {}ms", (Object)responseTime);
                        if (Strings.isNullOrEmpty((String)strBannerMatch) || !strBannerMatch.startsWith("~")) ** GOTO lbl80
                        if (Strresponse.matches(strBannerMatch.substring(1))) break block18;
                        serviceStatus = PollStatus.unavailable("Banner does not match Regex '" + strBannerMatch + "'");
                        IOUtils.closeQuietly((Closeable)clientWrapper);
                        return serviceStatus;
                    }
                    try {
                        serviceStatus = PollStatus.available(responseTime);
                        break block19;
lbl80:
                        // 1 sources

                        if (Strresponse.indexOf(strBannerMatch) > -1) {
                            serviceStatus = PollStatus.available(responseTime);
                            break block19;
                        }
                        serviceStatus = PollStatus.unavailable("Did not find expected Text '" + strBannerMatch + "'");
                    }
                    catch (URISyntaxException e) {
                        reason = "URISyntaxException for URI: " + strURI + " " + e.getMessage();
                        HttpPostMonitor.LOG.debug(reason, (Throwable)e);
                        serviceStatus = PollStatus.unavailable(reason);
                        {
                            catch (Throwable var27_29) {
                                IOUtils.closeQuietly(clientWrapper);
                                throw var27_29;
                            }
                        }
                        IOUtils.closeQuietly((Closeable)clientWrapper);
                        return serviceStatus;
                        catch (Exception e) {
                            reason = "Exception: " + e.getMessage();
                            HttpPostMonitor.LOG.debug(reason, (Throwable)e);
                            serviceStatus = PollStatus.unavailable(reason);
                            IOUtils.closeQuietly((Closeable)clientWrapper);
                            return serviceStatus;
                        }
                    }
                    IOUtils.closeQuietly((Closeable)clientWrapper);
                    return serviceStatus;
                }
                IOUtils.closeQuietly((Closeable)clientWrapper);
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

