/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.util.Map;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class AvailabilityMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(AvailabilityMonitor.class);
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 3, 3000);
        timeoutTracker.reset();
        while (timeoutTracker.shouldRetry()) {
            try {
                timeoutTracker.startAttempt();
                if (svc.getAddress().isReachable(timeoutTracker.getSoTimeout())) {
                    return PollStatus.available(timeoutTracker.elapsedTimeInMillis());
                }
            }
            catch (IOException e) {
                LOG.debug("Unable to contact {}", (Object)svc.getIpAddr(), (Object)e);
            }
            timeoutTracker.nextAttempt();
        }
        String reason = svc + " failed to respond";
        LOG.debug(reason);
        return PollStatus.unavailable(reason);
    }
}

