/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.IpNetToMediaTableTracker;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryIpNetToMedia
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryIpNetToMedia.class);

    public NodeDiscoveryIpNetToMedia(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        LOG.debug("run: collecting : {}", (Object)this.getPeer());
        IpNetToMediaTableTracker ipNetToMediaTableTracker = new IpNetToMediaTableTracker(){

            @Override
            public void processIpNetToMediaRow(IpNetToMediaTableTracker.IpNetToMediaRow row) {
                IpNetToMedia macep = row.getIpNetToMedia();
                if (macep.getPhysAddress() != null && (macep.getIpNetToMediaType() == IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC || macep.getIpNetToMediaType() == IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_STATIC)) {
                    NodeDiscoveryIpNetToMedia.this.m_linkd.getQueryManager().store(NodeDiscoveryIpNetToMedia.this.getNodeId(), macep);
                }
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(this.getPeer(), (CollectionTracker)ipNetToMediaTableTracker).withDescription("ipNetToMedia").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: Agent error while scanning the ipNetToMedia table", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        this.m_linkd.getQueryManager().reconcileIpNetToMedia(this.getNodeId(), now);
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable IpNetToMediaLinkNodeDiscovery ip=" + InetAddressUtils.str((InetAddress)this.getTarget()) + " port=" + this.getPort() + " community=" + this.getReadCommunity() + " package=" + this.getPackageName();
    }

    @Override
    public String getName() {
        return "IpNetToMediaLinkDiscovery";
    }
}

