/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.CdpCacheTableTracker;
import org.opennms.netmgt.enlinkd.snmp.CdpGlobalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.CdpInterfacePortNameGetter;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryCdp
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryCdp.class);

    public NodeDiscoveryCdp(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        LOG.debug("run: collecting : {}", (Object)this.getPeer());
        CdpGlobalGroupTracker cdpGlobalGroup = new CdpGlobalGroupTracker();
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(this.getPeer(), (CollectionTracker)cdpGlobalGroup).withDescription("cdpGlobalGroup").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: Agent error while scanning the cdpGlobalGroup table", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: Cdp cdpGlobalGroup collection interrupted, exiting", (Throwable)e);
            return;
        }
        if (cdpGlobalGroup.getCdpDeviceId() == null) {
            LOG.info("run: cdp mib not supported on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        CdpElement cdpElement = cdpGlobalGroup.getCdpElement();
        this.m_linkd.getQueryManager().store(this.getNodeId(), cdpElement);
        if (cdpElement.getCdpGlobalRun() == OspfElement.TruthValue.FALSE) {
            LOG.info("run: cdp disabled on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        final ArrayList links = new ArrayList();
        CdpCacheTableTracker cdpCacheTable = new CdpCacheTableTracker(){

            @Override
            public void processCdpCacheRow(CdpCacheTableTracker.CdpCacheRow row) {
                links.add(row.getLink());
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(this.getPeer(), (CollectionTracker)cdpCacheTable).withDescription("cdpCacheTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.error("run: collection execution failed, exiting", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.error("run: Cdp Linkd collection interrupted, exiting", (Throwable)e);
            return;
        }
        CdpInterfacePortNameGetter cdpInterfacePortNameGetter = new CdpInterfacePortNameGetter(this.getPeer(), this.m_linkd.getLocationAwareSnmpClient(), this.getLocation());
        for (CdpLink link : links) {
            this.m_linkd.getQueryManager().store(this.getNodeId(), cdpInterfacePortNameGetter.get(link));
        }
        this.m_linkd.getQueryManager().reconcileCdp(this.getNodeId(), now);
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable CdpLinkNodeDiscovery ip=" + InetAddressUtils.str((InetAddress)this.getTarget()) + " port=" + this.getPort() + " community=" + this.getReadCommunity() + " package=" + this.getPackageName();
    }

    @Override
    public String getName() {
        return "CdpLinksDiscovery";
    }
}

