/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.opennms.netmgt.model.topology.SimpleConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDiscoveryBridgeTopology
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryBridgeTopology.class);
    Map<Bridge, List<BridgeMacLink>> m_notYetParsedBFTMap;
    BroadcastDomain m_domain;
    List<BridgeMacLink> m_rootBridgeBFT = new ArrayList<BridgeMacLink>();
    List<BridgeElement> m_bridgeelements = new ArrayList<BridgeElement>();
    Map<Integer, Set<String>> m_nodeToBridgeMacIdMap = new HashMap<Integer, Set<String>>();

    public List<BridgeElement> getBridgeelements() {
        return this.m_bridgeelements;
    }

    public void setBridgeElements(List<BridgeElement> bridgeelements) {
        this.m_nodeToBridgeMacIdMap.clear();
        for (BridgeElement element : bridgeelements) {
            if (!this.m_nodeToBridgeMacIdMap.containsKey(element.getNode().getId())) {
                this.m_nodeToBridgeMacIdMap.put(element.getNode().getId(), new HashSet());
            }
            if (!InetAddressUtils.isValidBridgeAddress((String)element.getBaseBridgeAddress())) continue;
            this.m_nodeToBridgeMacIdMap.get(element.getNode().getId()).add(element.getBaseBridgeAddress());
        }
        this.m_bridgeelements = bridgeelements;
    }

    public List<BridgeMacLink> getRootBridgeBFT() {
        return this.m_rootBridgeBFT;
    }

    public void setRootBridgeBFT(List<BridgeMacLink> rootBridgeBFT) {
        this.m_rootBridgeBFT = rootBridgeBFT;
    }

    public BroadcastDomain getDomain() {
        return this.m_domain;
    }

    public void setDomain(BroadcastDomain domain) {
        this.m_domain = domain;
    }

    public Map<Bridge, List<BridgeMacLink>> getNotYetParsedBFTMap() {
        return this.m_notYetParsedBFTMap;
    }

    public void addUpdatedBFT(Bridge bridge, List<BridgeMacLink> notYetParsedBFTMap) {
        if (this.m_notYetParsedBFTMap == null) {
            this.m_notYetParsedBFTMap = new HashMap<Bridge, List<BridgeMacLink>>();
        }
        this.m_notYetParsedBFTMap.put(bridge, notYetParsedBFTMap);
    }

    public NodeDiscoveryBridgeTopology(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void var6_12;
        HashSet<String> retainedSet;
        if (!this.m_linkd.getQueryManager().hasUpdatedBft(this.getNodeId())) {
            LOG.info("run: node: {}, no bft.Exiting Bridge Topology Discovery", (Object)this.getNodeId());
            return;
        }
        List<BridgeMacLink> links = this.m_linkd.getQueryManager().getBridgeTopologyUpdateBFT(this.getNodeId());
        if (links == null || links.size() == 0) {
            LOG.debug("run: node: {}. no updates macs found.", (Object)this.getNodeId());
            return;
        }
        Date now = new Date();
        HashSet<String> incomingSet = new HashSet<String>();
        List<BridgeMacLink> list = links;
        synchronized (list) {
            for (BridgeMacLink bridgeMacLink : links) {
                incomingSet.add(bridgeMacLink.getMacAddress());
            }
        }
        LOG.debug("run: node: {}. macs found: {}", (Object)this.getNodeId(), incomingSet);
        HashSet<Integer> nodeswithupdatedbftonbroadcastdomain = new HashSet<Integer>();
        nodeswithupdatedbftonbroadcastdomain.add(this.getNodeId());
        Map<Integer, List<BridgeMacLink>> nodeBftMap = this.m_linkd.getQueryManager().getUpdateBftMap();
        LOG.info("run: node: {}, getting nodes with updated bft on broadcast domain. Start", (Object)this.getNodeId());
        for (Integer n : nodeBftMap.keySet()) {
            if (n.intValue() == this.getNodeId()) continue;
            retainedSet = new HashSet<String>();
            for (BridgeMacLink link : nodeBftMap.get(n)) {
                retainedSet.add(link.getMacAddress());
            }
            LOG.debug("run: node: {}, parsing updated bft node: {}, macs {}", new Object[]{this.getNodeId(), n, retainedSet});
            retainedSet.retainAll(incomingSet);
            LOG.debug("run: node: {}, node: {} - common mac address set: {}", new Object[]{this.getNodeId(), n, retainedSet});
            if (retainedSet.size() <= 10 && !((double)retainedSet.size() >= (double)incomingSet.size() * 0.1)) continue;
            nodeswithupdatedbftonbroadcastdomain.add(n);
            LOG.info("run: node: {}, node: {} - put on same broadcast domain, common macs: {} ", new Object[]{this.getNodeId(), n, retainedSet});
        }
        LOG.info("run: node: {}, getting nodes with updated bft on broadcast domain. End", (Object)this.getNodeId());
        LOG.info("run: node: {}, getting broadcast domain. Start", (Object)this.getNodeId());
        for (BroadcastDomain broadcastDomain : this.m_linkd.getQueryManager().getAllBroadcastDomains()) {
            LOG.debug("run: node: {}, parsing domain with nodes: {}, macs: {}", new Object[]{this.getNodeId(), broadcastDomain.getBridgeNodesOnDomain(), broadcastDomain.getMacsOnDomain()});
            retainedSet = new HashSet(broadcastDomain.getMacsOnDomain());
            retainedSet.retainAll(incomingSet);
            LOG.debug("run: node: {}, retained: {}", (Object)this.getNodeId(), retainedSet);
            if (retainedSet.size() > 10 || (double)retainedSet.size() >= (double)incomingSet.size() * 0.1) {
                this.m_domain = broadcastDomain;
                LOG.debug("run: node: {}, domain found!", (Object)this.getNodeId());
                continue;
            }
            for (Integer curNodeId : nodeswithupdatedbftonbroadcastdomain) {
                if (!broadcastDomain.containBridgeId(curNodeId.intValue())) continue;
                LOG.debug("run: remove node: {}, on not other domain {}!", (Object)curNodeId, (Object)broadcastDomain);
                if (!broadcastDomain.getLock((Object)this)) {
                    LOG.info("run: broadcast domain {}: is locked for calculation cannot clear topology for node {}....scheduling with time interval {}", new Object[]{broadcastDomain, curNodeId, this.getInitialSleepTime()});
                    this.schedule();
                    return;
                }
                NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.m_linkd, this.m_linkd.getNode(curNodeId));
                ndbt.setDomain(broadcastDomain);
                ndbt.clearTopologyForBridge(broadcastDomain.getBridge(curNodeId.intValue()));
                this.m_linkd.getQueryManager().store(broadcastDomain, now);
                this.m_linkd.getQueryManager().save(broadcastDomain.getRootBridgeId(), ndbt.getRootBridgeBFT());
                broadcastDomain.removeBridge(curNodeId.intValue());
                broadcastDomain.releaseLock((Object)this);
            }
        }
        boolean bl = false;
        if (this.m_domain == null) {
            LOG.info("run: node: {} Creating a new Domain", (Object)this.getNodeId());
            this.m_domain = new BroadcastDomain();
            this.m_domain.getLock((Object)this);
            this.m_linkd.getQueryManager().save(this.m_domain);
        } else {
            if (!this.m_domain.getLock((Object)this)) {
                LOG.info("run: broadcast domain: is locked for calculation either on node {}....scheduling with time interval {}", (Object)this.getNodeId(), (Object)this.getInitialSleepTime());
                this.schedule();
                return;
            }
            if (!this.m_domain.hasRootBridge()) {
                boolean bl2 = true;
                LOG.error("run: node: {}, broadcast domain has no root bridge. Clearing domain", (Object)this.getNodeId());
            } else if (this.m_linkd.getQueryManager().getBridgeTopologyRootBFT(this.m_domain.getRootBridgeId()) == null) {
                boolean bl3 = true;
                LOG.warn("run: node: {}, broadcast domain has root bridge {}, with null bft. Clearing domain", (Object)this.getNodeId(), (Object)this.m_domain.getRootBridgeId());
            } else {
                this.m_rootBridgeBFT = this.m_linkd.getQueryManager().getBridgeTopologyRootBFT(this.m_domain.getRootBridgeId());
            }
        }
        if (var6_12 != false) {
            LOG.info("run: node: {} Creating a new Domain", (Object)this.getNodeId());
            this.m_domain.clearTopology();
            this.m_linkd.getQueryManager().store(this.m_domain, now);
            this.m_domain.clear();
            this.m_domain.releaseLock((Object)this);
            this.m_domain = new BroadcastDomain();
            this.m_domain.getLock((Object)this);
            this.m_linkd.getQueryManager().save(this.m_domain);
        }
        LOG.info("run: node: {}, getting broadcast domain. End", (Object)this.getNodeId());
        for (Integer curNode : nodeswithupdatedbftonbroadcastdomain) {
            this.sendStartEvent(curNode);
        }
        for (Integer curNodeId : nodeBftMap.keySet()) {
            if (nodeswithupdatedbftonbroadcastdomain.contains(curNodeId)) {
                this.m_domain.addBridge(new Bridge(curNodeId));
                continue;
            }
            this.m_domain.removeBridge(curNodeId.intValue());
        }
        this.m_linkd.getQueryManager().cleanBroadcastDomains();
        this.m_notYetParsedBFTMap = new HashMap<Bridge, List<BridgeMacLink>>();
        this.setBridgeElements(this.m_linkd.getQueryManager().getBridgeElements(this.m_domain.getBridgeNodesOnDomain()));
        for (Integer nodeid : nodeswithupdatedbftonbroadcastdomain) {
            LOG.debug("run: node: {}, getting update bft for node {} on domain", (Object)this.getNodeId(), (Object)nodeid);
            List<BridgeMacLink> bft = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(nodeid);
            if (bft == null || bft.isEmpty()) {
                LOG.warn("run: node: {}, no update bft for node {} on domain", (Object)this.getNodeId(), (Object)nodeid);
                continue;
            }
            this.m_notYetParsedBFTMap.put(this.m_domain.getBridge(nodeid.intValue()), bft);
        }
        if (this.m_notYetParsedBFTMap.isEmpty()) {
            LOG.info("run: node: {}, broadcast domain has no topology updates. No more action is needed.", (Object)this.getNodeId());
            return;
        }
        LOG.info("run: node: {}, start: broadcast domain topology calculation.", (Object)this.getNodeId());
        try {
            this.calculate();
        }
        catch (Exception exception) {
            LOG.error("run: node: {}, got exception", (Throwable)exception);
        }
        LOG.info("run: node: {}, stop: broadcast domain topology calculated.", (Object)this.getNodeId());
        LOG.info("run: node: {}, saving broadcast domain root bridge: {} bft.", (Object)this.getNodeId(), (Object)this.m_domain.getRootBridgeId());
        this.m_linkd.getQueryManager().save(this.m_domain.getRootBridgeId(), this.m_rootBridgeBFT);
        LOG.info("run: node: {}, saving broadcast domain topology.", (Object)this.getNodeId());
        this.m_linkd.getQueryManager().store(this.m_domain, now);
        LOG.info("run: node: {}, saved broadcast domain topology.", (Object)this.getNodeId());
        for (Integer curNode : nodeswithupdatedbftonbroadcastdomain) {
            this.sendCompletedEvent(curNode);
        }
        this.m_domain.releaseLock((Object)this);
        LOG.info("run: node: {}, releaseLock broadcast domain for nodes: {}.", (Object)this.getNodeId(), (Object)this.m_domain.getBridgeNodesOnDomain());
    }

    @Override
    protected void runCollection() {
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable DiscoveryBridgeTopology node=" + this.getNodeId();
    }

    @Override
    public String getName() {
        return "DiscoveryBridgeTopology";
    }

    protected void calculate() {
        LOG.info("calculate: start:  calculate topology");
        for (Bridge xBridge : this.m_notYetParsedBFTMap.keySet()) {
            LOG.info("calculate: bridge: {} has an updated bft. Clear bridge topology", (Object)xBridge.getId());
            this.clearTopologyForBridge(xBridge);
        }
        Bridge electedRoot = this.electRootBridge();
        if (electedRoot == null || electedRoot.getId() == null) {
            LOG.error("calculate: electedRoot should not be null");
            return;
        }
        this.setUpRoot(electedRoot);
        HashSet<Bridge> nodetobeparsed = new HashSet<Bridge>(this.m_notYetParsedBFTMap.keySet());
        for (Bridge xBridge : nodetobeparsed) {
            LOG.info("calculate: start: calculate topology for nodeid {}", (Object)xBridge.getId());
            this.calculate(electedRoot, this.m_rootBridgeBFT, xBridge, new ArrayList<BridgeMacLink>((Collection)this.m_notYetParsedBFTMap.remove(xBridge)));
            LOG.info("calculate: stop: calculate topology for nodeid {}", (Object)xBridge.getId());
        }
        LOG.info("calculate: stop:  calculate topology");
    }

    private void calculate(Bridge root, List<BridgeMacLink> rootbft, Bridge xBridge, List<BridgeMacLink> xbft) {
        BridgeTopologyHelper rx = new BridgeTopologyHelper(root, rootbft, xBridge, xbft);
        Integer rxDesignatedPort = rx.getFirstBridgeConnectionPort();
        if (rxDesignatedPort == null) {
            LOG.info("calculate: level 0: cannot found X -> Y simple connection:  X Bridge: {}, Y Bridge: {}", (Object)root.getId(), (Object)xBridge.getId());
            this.m_domain.clearTopology();
            return;
        }
        Integer xrDesignatedPort = rx.getSecondBridgeConnectionPort();
        if (xrDesignatedPort == null) {
            LOG.info("calculate: level 0: cannot found Y -> X simple connection: Y Bridge: {} X Bridge: {}", (Object)xBridge.getId(), (Object)root.getId());
            this.m_domain.clearTopology();
            return;
        }
        LOG.info("calculate: level 0: found simple connection:  nodeid {}, port {} <--> nodeid {}, port {}", new Object[]{root.getId(), rxDesignatedPort, xBridge.getId(), xrDesignatedPort});
        LOG.info("calculate: level 0: set root port {} for X bridge: {}", (Object)xrDesignatedPort, (Object)xBridge.getId());
        xBridge.setRootPort(xrDesignatedPort);
        xBridge.setRootBridge(false);
        SharedSegment topSegment = this.m_domain.getSharedSegment(root.getId(), rxDesignatedPort);
        if (topSegment == null) {
            LOG.error("calculate: level 0: not found: top segment:  for nodeid {}, port {}", (Object)this.m_domain.getRootBridgeId(), (Object)rxDesignatedPort);
            this.m_domain.clearTopology();
            return;
        }
        this.findBridgesTopo(rx, topSegment, xBridge, xbft, 0);
    }

    private void findBridgesTopo(BridgeTopologyHelper rx, SharedSegment topSegment, Bridge xBridge, List<BridgeMacLink> xBFT, int level) {
        if (++level == 30) {
            LOG.warn("calculate: level {}: bridge: {}, too many iteration on topology exiting.....", (Object)level, (Object)xBridge.getId());
            return;
        }
        LOG.info("calculate: level {}: bridge: {}, top segment: designated port {}, designated root {}", new Object[]{level, xBridge.getId(), topSegment.getDesignatedPort(), topSegment.getDesignatedBridge()});
        HashSet<Integer> portsAdded = new HashSet<Integer>();
        ArrayList<Map<Integer, List<BridgeMacLink>>> throughSets = new ArrayList<Map<Integer, List<BridgeMacLink>>>();
        HashMap<Integer, List<BridgeMacLink>> bftSets = new HashMap<Integer, List<BridgeMacLink>>();
        for (Bridge bridge : this.m_domain.getBridgeOnSharedSegment(topSegment)) {
            bftSets.put(bridge.getId(), this.getBFT(bridge));
        }
        for (Bridge bridge : this.m_domain.getBridgeOnSharedSegment(topSegment)) {
            Integer yBridgeId = bridge.getId();
            if (yBridgeId.intValue() == topSegment.getDesignatedBridge().intValue()) continue;
            LOG.debug("calculate: level {}: bridge: {}, check simple connection with Bridge Y {} found on topSegment", new Object[]{level, xBridge.getId(), bridge.getId()});
            Integer yrDesignatedPort = bridge.getRootPort();
            LOG.info("calculate: level {}: bridge: {}, found Y designated port:  Y bridge: {}, port: {}", new Object[]{level, xBridge.getId(), yBridgeId, yrDesignatedPort});
            BridgeTopologyHelper yx = new BridgeTopologyHelper(bridge, (List)bftSets.get(yBridgeId), xBridge, xBFT);
            Integer xyDesignatedPort = yx.getSecondBridgeConnectionPort();
            Integer yxDesignatedPort = yx.getFirstBridgeConnectionPort();
            LOG.info("calculate: level {}: found simple connection:  X bridge {}, port {} <--> Y bridge {}, port {}", new Object[]{level, xBridge.getId(), xyDesignatedPort, yBridgeId, yxDesignatedPort});
            if (xyDesignatedPort == rx.getSecondBridgeConnectionPort() && yxDesignatedPort != yrDesignatedPort) {
                LOG.info("calculate: level {}: X Bridge: {} is a leaf of Y Bridge: {}, going one level down", new Object[]{level, xBridge.getId(), bridge.getId()});
                this.findBridgesTopo(yx, this.m_domain.getSharedSegment(yBridgeId, yxDesignatedPort), xBridge, xBFT, level);
                return;
            }
            if (yxDesignatedPort == yrDesignatedPort && xyDesignatedPort != rx.getSecondBridgeConnectionPort()) {
                LOG.info("calculate: level {}: Y bridge: {} is a leaf of X Bridge: {}, creating shared segment for port {}", new Object[]{level, bridge.getId(), xBridge.getId(), xyDesignatedPort});
                SharedSegment leafSegment = new SharedSegment(this.m_domain, yx.getSimpleConnection().getDlink());
                leafSegment.setBridgeMacLinks(yx.getSimpleConnection().getLinks());
                leafSegment.setDesignatedBridge(xBridge.getId());
                this.m_domain.add(leafSegment);
                portsAdded.add(xyDesignatedPort);
                LOG.info("calculate: level {}: removing Y through set {} macs from top segment", (Object)level, (Object)yx.getFirstBridgeTroughSet().size());
                topSegment.removeMacs(yx.getFirstBridgeTroughSet());
                LOG.info("calculate: level {}: removing Y Bridge {} from top segment", (Object)level, (Object)bridge.getId());
                topSegment.removeBridge(yBridgeId.intValue());
            }
            if (xyDesignatedPort != rx.getSecondBridgeConnectionPort() && yxDesignatedPort != yrDesignatedPort) {
                LOG.error("findBridgesTopo: level {}: topology mismatch. Clearing...topology", (Object)level);
                this.m_domain.clearTopology();
                return;
            }
            throughSets.add(yx.getFirstBridgeTroughSet());
        }
        LOG.info("calculate: level {}: bridge: {}, removing X through set {} macs from top segment", new Object[]{level, xBridge.getId(), rx.getSecondBridgeTroughSet().size()});
        topSegment.removeMacs(rx.getSecondBridgeTroughSet());
        topSegment.assign(rx.getSimpleConnection().getLinks(), rx.getSimpleConnection().getDlink());
        LOG.info("calculate: level {}: bridge: {}, assigning links to top segment: bridge {} port: {}, mac size: {}, bft size: {}", new Object[]{level, xBridge.getId(), topSegment.getDesignatedBridge(), topSegment.getDesignatedPort(), topSegment.getMacsOnSegment().size(), topSegment.getBridgeMacLinks().size()});
        LOG.info("calculate: level {}: bridge: {}, removing {} Y through sets from top segment", new Object[]{level, xBridge.getId(), throughSets.size()});
        for (Map map : throughSets) {
            topSegment.removeMacs(map);
        }
        for (Integer n : rx.getSecondBridgeTroughSet().keySet()) {
            if (portsAdded.contains(n)) continue;
            SharedSegment xleafSegment = new SharedSegment(this.m_domain);
            xleafSegment.setBridgeMacLinks(rx.getSecondBridgeTroughSet().get(n));
            xleafSegment.setDesignatedBridge(xBridge.getId());
            LOG.info("calculate: level {}: adding shared segment to topology: root bridge {} port: {}, mac size: {}, bft size: {}", new Object[]{level, xleafSegment.getDesignatedBridge(), xleafSegment.getDesignatedPort(), xleafSegment.getMacsOnSegment().size(), xleafSegment.getBridgeMacLinks().size()});
            this.m_domain.add(xleafSegment);
        }
    }

    private Bridge electRootBridge() {
        if (this.m_domain.getBridges().size() == 1) {
            LOG.debug("calculate: electRootBridge: only one bridge in topology, electing to root");
            return (Bridge)this.m_domain.getBridges().iterator().next();
        }
        HashSet<String> rootBridgeIds = new HashSet<String>();
        for (BridgeElement bridge : this.m_bridgeelements) {
            if (!InetAddressUtils.isValidStpBridgeId((String)bridge.getStpDesignatedRoot()) || bridge.getBaseBridgeAddress().equals(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)bridge.getStpDesignatedRoot()))) continue;
            rootBridgeIds.add(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)bridge.getStpDesignatedRoot()));
            LOG.info("calculate: electRootBridge: found stp root {} on the BroadcastDomain: ", (Object)bridge.getStpDesignatedRoot());
        }
        for (String rootBridgeId : rootBridgeIds) {
            for (BridgeElement bridgeElement : this.m_bridgeelements) {
                LOG.debug("calculate: electRootBridge: searching for stp root, stp root address: {}, against bridge: {}", (Object)rootBridgeId, (Object)bridgeElement.getBaseBridgeAddress());
                if (!bridgeElement.getBaseBridgeAddress().equals(rootBridgeId)) continue;
                LOG.debug("calculate: electRootBridge: found stp root bridge: {}", (Object)bridgeElement.getBaseBridgeAddress());
                return this.m_domain.getBridge(bridgeElement.getNode().getId().intValue());
            }
        }
        int size = 0;
        if (this.m_rootBridgeBFT != null) {
            size = this.m_rootBridgeBFT.size();
        }
        Bridge rootBridge = null;
        for (Bridge bridge : this.m_notYetParsedBFTMap.keySet()) {
            if (size >= this.m_notYetParsedBFTMap.get(bridge).size()) continue;
            rootBridge = bridge;
            size = this.m_notYetParsedBFTMap.get(bridge).size();
        }
        if (rootBridge != null) {
            LOG.debug("calculate: electRootBridge: elected bridge {} with max bft size \"{}\" in topology", (Object)rootBridge.getId(), (Object)size);
            return rootBridge;
        }
        if (this.m_domain.hasRootBridge()) {
            LOG.debug("calculate: electRootBridge: mantaining old root bridge: {}", (Object)this.m_domain.getRootBridgeId());
            return this.m_domain.getRootBridge();
        }
        return (Bridge)this.m_domain.getBridges().iterator().next();
    }

    private void loadFirstLevelSharedSegment(List<BridgeMacLink> electedRootBFT) {
        HashMap<Integer, SharedSegment> rootleafs = new HashMap<Integer, SharedSegment>();
        for (BridgeMacLink link : electedRootBFT) {
            if (link.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) continue;
            if (rootleafs.containsKey(link.getBridgePort())) {
                ((SharedSegment)rootleafs.get(link.getBridgePort())).add(link);
                continue;
            }
            rootleafs.put(link.getBridgePort(), new SharedSegment(this.m_domain, link));
        }
        for (SharedSegment rootleaf : rootleafs.values()) {
            LOG.info("calculate: adding shared segment to topology: root bridge {} port: {}, mac size: {}, bft size: {}", new Object[]{rootleaf.getDesignatedBridge(), rootleaf.getDesignatedPort(), rootleaf.getMacsOnSegment().size(), rootleaf.getBridgeMacLinks().size()});
            this.m_domain.add(rootleaf);
        }
    }

    private void setUpRoot(Bridge electedRoot) {
        if (electedRoot.isRootBridge() && !this.m_notYetParsedBFTMap.containsKey(electedRoot)) {
            LOG.info("calculate: elected root bridge: {}, is old root bridge with old bft", (Object)electedRoot.getId());
        } else if (electedRoot.isRootBridge() && this.m_notYetParsedBFTMap.containsKey(electedRoot)) {
            LOG.info("calculate: elected root bridge: {}, is old root bridge with new bft", (Object)electedRoot.getId());
            this.m_rootBridgeBFT = new ArrayList<BridgeMacLink>((Collection)this.m_notYetParsedBFTMap.remove(electedRoot));
            LOG.debug("calculate: updated new bft for root bridge {}  size:  {}", (Object)electedRoot.getId(), (Object)this.m_rootBridgeBFT.size());
            if (this.m_domain.getTopology().isEmpty()) {
                LOG.info("calculate: elected root bridge: {}, clean topology found. Adding level 0 shared segments", (Object)electedRoot.getId());
                this.loadFirstLevelSharedSegment(this.m_rootBridgeBFT);
            }
        } else if (!electedRoot.isRootBridge() && this.m_notYetParsedBFTMap.containsKey(electedRoot)) {
            LOG.info("calculate: elected root bridge: {}, is new root bridge and has new bft", (Object)electedRoot.getId());
            ArrayList<BridgeMacLink> electedRootBFT = new ArrayList<BridgeMacLink>((Collection)this.m_notYetParsedBFTMap.remove(electedRoot));
            if (this.m_domain.getTopology().isEmpty()) {
                LOG.info("calculate: new elected root bridge: {}, is the first bridge in topology. Adding level 0 shared segments", (Object)electedRoot.getId());
                this.loadFirstLevelSharedSegment(electedRootBFT);
                electedRoot.setRootBridge(true);
                electedRoot.setRootPort(null);
            } else {
                LOG.info("calculate: find topology of new elected root bridge:  {} with old root as root bridge: {}", (Object)electedRoot.getId(), (Object)this.m_domain.getRootBridgeId());
                this.calculate(this.m_domain.getRootBridge(), this.m_rootBridgeBFT, electedRoot, electedRootBFT);
                this.m_domain.hierarchySetUp(electedRoot);
            }
            this.m_rootBridgeBFT = electedRootBFT;
            LOG.debug("calculate: set bft for root bridge {}  size:  {}", (Object)electedRoot.getId(), (Object)this.m_rootBridgeBFT.size());
        } else if (!electedRoot.isRootBridge() && !this.m_notYetParsedBFTMap.containsKey(electedRoot)) {
            LOG.info("calculate: elected root bridge: {}, is new root bridge with old bft", (Object)electedRoot.getId());
            this.m_domain.hierarchySetUp(electedRoot);
            this.m_rootBridgeBFT = this.getBFT(electedRoot);
            LOG.debug("calculate: set bft for root bridge {}  size:  {}", (Object)electedRoot.getId(), (Object)this.m_rootBridgeBFT.size());
        }
    }

    public void clearTopologyForBridge(Bridge bridge) {
        if (bridge.isRootBridge()) {
            LOG.debug("calculate: clearTopologyForBridge: bridge {}, is root bridge. setting up a new hierarchy before clean", (Object)bridge.getId());
            for (SharedSegment segment : this.m_domain.getSharedSegmentOnTopologyForBridge(bridge.getId())) {
                Integer newRootId = segment.getFirstNoDesignatedBridge();
                if (newRootId == null) continue;
                Bridge newRootBridge = null;
                for (Bridge curBridge : this.m_domain.getBridges()) {
                    if (curBridge.getId().intValue() != newRootId.intValue()) continue;
                    newRootBridge = curBridge;
                    break;
                }
                if (newRootBridge == null) continue;
                this.m_rootBridgeBFT = this.getBFT(newRootBridge);
                this.m_domain.hierarchySetUp(newRootBridge);
                break;
            }
        }
        LOG.debug("calculate: clearTopologyForBridge: bridge {}, bridge root port {}", (Object)bridge.getId(), (Object)bridge.getRootPort());
        SharedSegment topsegment = this.m_domain.getSharedSegment(bridge.getId(), bridge.getRootPort());
        if (topsegment != null) {
            LOG.debug("calculate: clearTopologyForBridge: removing bridge {}: top segment nodes {}, macs {}, designated {}, port {}", new Object[]{bridge.getId(), topsegment.getBridgeIdsOnSegment(), topsegment.getMacsOnSegment(), topsegment.getDesignatedBridge(), topsegment.getDesignatedPort()});
            topsegment.removeBridge(bridge.getId().intValue());
            LOG.debug("calculate: clearTopologyForBridge: removed bridge {}: top segment nodes {}, macs {}, designated {}, port {}", new Object[]{bridge.getId(), topsegment.getBridgeIdsOnSegment(), topsegment.getMacsOnSegment(), topsegment.getDesignatedBridge(), topsegment.getDesignatedPort()});
        } else {
            LOG.debug("calculate: clearTopologyForBridge {}: no top segment found", (Object)bridge.getId());
        }
        for (SharedSegment segment : this.m_domain.removeSharedSegmentOnTopologyForBridge(bridge.getId())) {
            LOG.debug("calculate: clearTopologyForBridge merging bridge {} on top for segment: nodes {}, macs {}, designated {}, port {}", new Object[]{bridge.getId(), segment.getBridgeIdsOnSegment(), segment.getMacsOnSegment(), segment.getDesignatedBridge(), segment.getDesignatedPort()});
            if (topsegment == null) continue;
            topsegment.mergeBridge(segment, bridge.getId());
        }
    }

    public List<BridgeMacLink> getBFT(Bridge bridge) {
        LOG.debug("calculate: getBFT: bridge: {}, bridge root port {}", (Object)bridge.getId(), (Object)bridge.getRootPort());
        HashMap bft = new HashMap();
        Integer bridgeId = bridge.getId();
        ArrayList<BridgeMacLink> links = new ArrayList<BridgeMacLink>();
        OnmsNode node = new OnmsNode();
        node.setId(bridgeId);
        for (SharedSegment segment : this.m_domain.getTopology()) {
            Set macs = segment.getMacsOnSegment();
            if (macs == null || macs.isEmpty()) continue;
            Integer bridgeport = this.goUp(segment, bridge, 0);
            LOG.info("calculate: getBFT: bridge: {}, assigning macs {} to port {}", new Object[]{bridgeId, macs, bridgeport});
            if (!bft.containsKey(bridgeport)) {
                bft.put(bridgeport, new HashSet());
            }
            ((Set)bft.get(bridgeport)).addAll(macs);
        }
        for (Integer bridgePort : bft.keySet()) {
            for (String mac : (Set)bft.get(bridgePort)) {
                BridgeMacLink link = new BridgeMacLink();
                link.setNode(node);
                link.setBridgePort(bridgePort);
                link.setMacAddress(mac);
                link.setBridgeDot1qTpFdbStatus(BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
                links.add(link);
            }
        }
        return links;
    }

    private Integer goUp(SharedSegment down, Bridge bridge, int level) {
        if (level == 30) {
            LOG.warn("calculate: level {}: bridge: {}, too many iteration on topology exiting.....", (Object)level, (Object)bridge.getId());
            this.m_domain.clearTopology();
            return -1;
        }
        LOG.debug("calculate: goUp: level: {}, checking up segment designated bridge {}, designated port {}, bridge {}, with root port {}", new Object[]{level, down.getDesignatedBridge(), down.getDesignatedPort(), bridge.getId(), bridge.getRootPort()});
        Integer upBridgeId = down.getDesignatedBridge();
        if (upBridgeId.intValue() == bridge.getId().intValue()) {
            LOG.debug("calculate: goUp: level: {}, return bridge {}, designated port {}", new Object[]{level, down.getDesignatedBridge(), down.getDesignatedPort()});
            return down.getDesignatedPort();
        }
        if (upBridgeId.intValue() == this.m_domain.getRootBridgeId().intValue()) {
            LOG.debug("calculate: goUp: level: {}, got root bridge, returning bridge {}, root port {}", new Object[]{level, bridge.getId(), bridge.getRootPort()});
            return bridge.getRootPort();
        }
        Bridge upBridge = null;
        for (Bridge cbridge : this.m_domain.getBridges()) {
            if (cbridge.getId().intValue() == bridge.getId().intValue()) continue;
            LOG.debug("calculate: goUp: level: {}, searching bridge {}, parsing bridge {}", new Object[]{level, down.getDesignatedBridge(), cbridge.getId()});
            if (cbridge.getId().intValue() != upBridgeId.intValue()) continue;
            LOG.debug("calculate: goUp: level: {}, searching bridge {}, found bridge {}, with root port {}", new Object[]{level, down.getDesignatedBridge(), cbridge.getId(), cbridge.getRootPort()});
            upBridge = cbridge;
            break;
        }
        if (upBridge == null) {
            LOG.debug("calculate: goUp: level: {}, searching bridge {}, no bridge found!!!", (Object)level, (Object)down.getDesignatedBridge());
            return null;
        }
        SharedSegment up = this.m_domain.getSharedSegment(upBridge.getId(), upBridge.getRootPort());
        if (up == null) {
            LOG.debug("calculate: goUp: level: {}, no shared segment found on bridge {}, root port {}!!!", (Object)level, (Object)down.getDesignatedBridge());
            return null;
        }
        return this.goUp(up, bridge, ++level);
    }

    private class BridgeTopologyHelper {
        Integer m_xy;
        Integer m_yx;
        Map<String, BridgeMacLink> xmactoport = new HashMap<String, BridgeMacLink>();
        Map<String, BridgeMacLink> ymactoport = new HashMap<String, BridgeMacLink>();
        Map<Integer, List<BridgeMacLink>> m_throughSetX = new HashMap<Integer, List<BridgeMacLink>>();
        Map<Integer, List<BridgeMacLink>> m_throughSetY = new HashMap<Integer, List<BridgeMacLink>>();
        SimpleConnection m_simpleconnection;
        Set<String> xmacs = new HashSet<String>();
        Set<String> ymacs = new HashSet<String>();

        public BridgeTopologyHelper(Bridge xBridge, List<BridgeMacLink> xBFT, Bridge yBridge, List<BridgeMacLink> yBFT) {
            LOG.debug("BridgeTopologyHelper: searching simple connection between bridgeX: {} and bridgeY", (Object)xBridge.getId(), (Object)yBridge.getId());
            LOG.debug("BridgeTopologyHelper: bridgeX has bft size {}", (Object)xBFT.size());
            LOG.debug("BridgeTopologyHelper: bridgeY has bft size {}", (Object)yBFT.size());
            for (BridgeMacLink xlink : xBFT) {
                if (xBridge.getId().intValue() == xlink.getNode().getId().intValue() && xlink.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    this.xmactoport.put(xlink.getMacAddress(), xlink);
                    if (!this.m_throughSetX.containsKey(xlink.getBridgePort())) {
                        this.m_throughSetX.put(xlink.getBridgePort(), new ArrayList());
                    }
                    this.m_throughSetX.get(xlink.getBridgePort()).add(xlink);
                }
                if (xBridge.getId().intValue() != xlink.getNode().getId().intValue() || xlink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) continue;
                this.xmacs.add(xlink.getMacAddress());
            }
            for (BridgeMacLink ylink : yBFT) {
                if (yBridge.getId().intValue() == ylink.getNode().getId().intValue() && ylink.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    this.ymactoport.put(ylink.getMacAddress(), ylink);
                    if (!this.m_throughSetY.containsKey(ylink.getBridgePort())) {
                        this.m_throughSetY.put(ylink.getBridgePort(), new ArrayList());
                    }
                    this.m_throughSetY.get(ylink.getBridgePort()).add(ylink);
                }
                if (yBridge.getId().intValue() != ylink.getNode().getId().intValue() || ylink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) continue;
                this.ymacs.add(ylink.getMacAddress());
            }
            this.xmacs.addAll((Collection<String>)NodeDiscoveryBridgeTopology.this.m_nodeToBridgeMacIdMap.get(xBridge.getId()));
            this.ymacs.addAll((Collection<String>)NodeDiscoveryBridgeTopology.this.m_nodeToBridgeMacIdMap.get(yBridge.getId()));
            boolean cond1X = this.condition1BridgeX();
            boolean cond1Y = this.condition1BridgeY();
            if (!cond1X || !cond1Y) {
                HashSet<String> commonlearnedmacs = new HashSet<String>(this.xmactoport.keySet());
                commonlearnedmacs.retainAll(new HashSet<String>(this.ymactoport.keySet()));
                LOG.debug("BridgeTopologyHelper: common (learned mac) size: {} for X: {}, Y: {}", new Object[]{commonlearnedmacs.size(), xBridge.getId(), yBridge.getId()});
                if (cond1X && !cond1Y) {
                    this.condition2BridgeX(commonlearnedmacs);
                }
                if (!cond1X && cond1Y) {
                    this.condition2BridgeY(commonlearnedmacs);
                }
                if (!cond1X && !cond1Y) {
                    this.condition3(commonlearnedmacs);
                }
                if (this.m_xy == null || this.m_xy == null) {
                    this.condition3(commonlearnedmacs);
                }
                if (this.m_xy == null || this.m_xy == null) {
                    return;
                }
            }
            LOG.debug("BridgeTopologyHelper: found port m_xy: {} on X: {}", (Object)this.m_xy, (Object)xBridge.getId());
            LOG.debug("BridgeTopologyHelper: found port m_yx: {} on Y: {}", (Object)this.m_yx, (Object)yBridge.getId());
            BridgeMacLink xylink = null;
            BridgeMacLink yxlink = null;
            ArrayList<BridgeMacLink> connectionsOnSegment = new ArrayList<BridgeMacLink>();
            for (BridgeMacLink bridgeMacLink : xBFT) {
                if (bridgeMacLink.getBridgePort() != this.m_xy || bridgeMacLink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) continue;
                if (!this.ymactoport.containsKey(bridgeMacLink.getMacAddress()) || this.m_yx == this.ymactoport.get(bridgeMacLink.getMacAddress()).getBridgePort()) {
                    connectionsOnSegment.add(bridgeMacLink);
                }
                if (xylink != null) continue;
                xylink = bridgeMacLink;
            }
            int xlinks = connectionsOnSegment.size();
            LOG.debug("BridgeTopologyHelper: added {}, links on simple connection for X: {}", (Object)xlinks, (Object)xBridge.getId());
            for (BridgeMacLink ylink : yBFT) {
                if (ylink.getBridgePort() != this.m_yx || ylink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) continue;
                if (!this.xmactoport.containsKey(ylink.getMacAddress()) || this.m_xy == this.xmactoport.get(ylink.getMacAddress()).getBridgePort()) {
                    connectionsOnSegment.add(ylink);
                }
                if (yxlink != null) continue;
                yxlink = ylink;
            }
            int n = connectionsOnSegment.size() - xlinks;
            LOG.info("BridgeTopologyHelper: added {}, links on simple connection for Y: {}", (Object)n, (Object)yBridge.getId());
            BridgeBridgeLink blink = new BridgeBridgeLink();
            if (xylink != null && yxlink != null) {
                blink.setNode(yxlink.getNode());
                blink.setBridgePort(yxlink.getBridgePort());
                blink.setBridgePortIfIndex(yxlink.getBridgePortIfIndex());
                blink.setBridgePortIfName(yxlink.getBridgePortIfName());
                blink.setVlan(yxlink.getVlan());
                blink.setDesignatedNode(xylink.getNode());
                blink.setDesignatedPort(xylink.getBridgePort());
                blink.setDesignatedPortIfIndex(xylink.getBridgePortIfIndex());
                blink.setDesignatedPortIfName(xylink.getBridgePortIfName());
                blink.setDesignatedVlan(xylink.getVlan());
            }
            this.m_simpleconnection = new SimpleConnection(connectionsOnSegment, blink);
            this.m_throughSetX.remove(this.m_xy);
            this.m_throughSetY.remove(this.m_yx);
        }

        private void condition3(Set<String> commonlearnedmacs) {
            String mac1 = null;
            String mac2 = null;
            Integer yp1 = null;
            Integer yp2 = null;
            Integer xp1 = null;
            Integer xp2 = null;
            for (String mac : commonlearnedmacs) {
                LOG.debug("BridgeTopologyHelper: condition3: parsing common BFT mac: {}", (Object)mac);
                if (mac1 == null) {
                    mac1 = mac;
                    yp1 = this.ymactoport.get(mac).getBridgePort();
                    xp1 = this.xmactoport.get(mac).getBridgePort();
                    LOG.debug("BridgeTopologyHelper: condition3: mac1: {} xp1: {} yp1: {} ", new Object[]{mac1, xp1, yp1});
                    continue;
                }
                if (this.ymactoport.get(mac).getBridgePort() == yp1 && this.xmactoport.get(mac).getBridgePort() == xp1) continue;
                if (mac2 == null) {
                    mac2 = mac;
                    yp2 = this.ymactoport.get(mac).getBridgePort();
                    xp2 = this.xmactoport.get(mac).getBridgePort();
                    LOG.debug("BridgeTopologyHelper: condition3: mac2: {} xp2: {} yp2: {} ", new Object[]{mac2, xp2, yp2});
                    continue;
                }
                if (this.ymactoport.get(mac).getBridgePort() == yp2 && this.xmactoport.get(mac).getBridgePort() == xp2) continue;
                Integer yp3 = this.ymactoport.get(mac).getBridgePort();
                Integer xp3 = this.xmactoport.get(mac).getBridgePort();
                LOG.debug("BridgeTopologyHelper: condition3: mac3: {} x3: {} yp3: {} ", new Object[]{mac, xp3, yp3});
                if (xp1 == xp2 && xp1 != xp3 && (yp1 != yp3 || yp2 != yp3)) {
                    this.m_xy = xp1;
                    this.m_yx = yp3;
                    return;
                }
                if (yp1 == yp2 && yp1 != yp3 && (xp1 != xp3 || xp2 != xp3)) {
                    this.m_yx = yp1;
                    this.m_xy = xp3;
                    return;
                }
                if (xp1 == xp3 && xp1 != xp2 && (yp1 != yp2 || yp2 != yp3)) {
                    this.m_xy = xp1;
                    this.m_yx = yp2;
                    return;
                }
                if (yp1 == yp3 && yp1 != yp2 && (xp1 != xp2 || xp2 != xp3)) {
                    this.m_yx = yp1;
                    this.m_xy = xp2;
                    return;
                }
                if (xp3 == xp2 && xp1 != xp3 && (yp1 != yp3 || yp2 != yp1)) {
                    this.m_xy = xp2;
                    this.m_yx = yp1;
                    return;
                }
                if (yp3 != yp2 || yp1 == yp3 || xp1 == xp3 && xp2 == xp1) continue;
                this.m_yx = yp2;
                this.m_xy = xp1;
                return;
            }
            if (mac2 == null) {
                this.m_xy = xp1;
                this.m_yx = yp1;
            }
        }

        private void condition2BridgeX(Set<String> commonlearnedmacs) {
            LOG.info("BridgeTopologyHelper: condition2BridgeX: found m_yx: {}, search m_xy using common macs size: {} ", (Object)this.m_yx, (Object)commonlearnedmacs.size());
            String mac1 = null;
            String mac2 = null;
            Integer p1 = null;
            Integer xy1 = null;
            Integer p2 = null;
            Integer xy2 = null;
            for (String mac : commonlearnedmacs) {
                LOG.debug("BridgeTopologyHelper: condition2BridgeX: parsing common BFT mac: {} portX: {}, portY: {} ", new Object[]{mac, this.xmactoport.get(mac).getBridgePort(), this.ymactoport.get(mac).getBridgePort()});
                if (mac1 == null) {
                    mac1 = mac;
                    p1 = this.ymactoport.get(mac).getBridgePort();
                    xy1 = this.xmactoport.get(mac).getBridgePort();
                    LOG.debug("BridgeTopologyHelper: condition2BridgeX: mac1: {} xy1: {} p1: {} ", new Object[]{mac1, xy1, p1});
                    continue;
                }
                if (this.ymactoport.get(mac).getBridgePort().intValue() == p1.intValue()) continue;
                if (this.xmactoport.get(mac).getBridgePort().intValue() == xy1.intValue()) {
                    LOG.debug("BridgeTopologyHelper: condition2BridgeX: xy1 bridge port {}", (Object)this.ymactoport.get(mac).getBridgePort());
                    this.m_xy = xy1;
                    return;
                }
                if (mac2 == null) {
                    mac2 = mac;
                    p2 = this.ymactoport.get(mac).getBridgePort();
                    xy2 = this.xmactoport.get(mac).getBridgePort();
                    LOG.debug("BridgeTopologyHelper: condition2BridgeX: mac2: {} xy2: {} p2: {} ", new Object[]{mac2, xy2, p2});
                    continue;
                }
                if (this.ymactoport.get(mac).getBridgePort().intValue() == p2.intValue() || this.xmactoport.get(mac).getBridgePort().intValue() != xy2.intValue()) continue;
                LOG.debug("BridgeTopologyHelper: condition2BridgeX: xy2 bridge port {}", (Object)this.ymactoport.get(mac).getBridgePort());
                this.m_xy = xy2;
                return;
            }
            if (xy2 == null) {
                this.m_xy = xy1;
            }
        }

        private void condition2BridgeY(Set<String> commonlearnedmacs) {
            LOG.info("BridgeTopologyHelper: condition2BridgeY: found m_xy: {}, search m_yx using common macs size: {} ", (Object)this.m_xy, (Object)commonlearnedmacs.size());
            String mac1 = null;
            String mac2 = null;
            Integer p1 = null;
            Integer yx1 = null;
            Integer p2 = null;
            Integer yx2 = null;
            for (String mac : commonlearnedmacs) {
                LOG.debug("BridgeTopologyHelper: condition2BridgeY: parsing common BFT mac: {} portX: {}, portY: {} ", new Object[]{mac, this.xmactoport.get(mac).getBridgePort(), this.ymactoport.get(mac).getBridgePort()});
                if (mac1 == null) {
                    mac1 = mac;
                    p1 = this.xmactoport.get(mac).getBridgePort();
                    yx1 = this.ymactoport.get(mac).getBridgePort();
                    LOG.debug("BridgeTopologyHelper: condition2BridgeY: mac1: {} yx1: {} p1: {} ", new Object[]{mac1, yx1, p1});
                    continue;
                }
                if (this.xmactoport.get(mac).getBridgePort() == p1) continue;
                if (this.ymactoport.get(mac).getBridgePort() == yx1) {
                    LOG.debug("BridgeTopologyHelper: condition2BridgeY: yx1 bridge port {}", (Object)this.ymactoport.get(mac).getBridgePort());
                    this.m_yx = yx1;
                    return;
                }
                if (mac2 == null) {
                    mac2 = mac;
                    p2 = this.xmactoport.get(mac).getBridgePort();
                    yx2 = this.ymactoport.get(mac).getBridgePort();
                    LOG.debug("BridgeTopologyHelper: condition2BridgeY: mac2: {} yx2: {} p2: {} ", new Object[]{mac2, yx2, p2});
                    continue;
                }
                if (this.xmactoport.get(mac).getBridgePort().intValue() == p2.intValue() || this.ymactoport.get(mac).getBridgePort().intValue() != yx2.intValue()) continue;
                LOG.debug("BridgeTopologyHelper: condition2BridgeY: yx2 bridge port {}", (Object)this.ymactoport.get(mac).getBridgePort());
                this.m_yx = yx2;
                return;
            }
            if (yx2 == null) {
                this.m_yx = yx1;
            }
        }

        private boolean condition1BridgeX() {
            LOG.info("BridgeTopologyHelper: condition1BridgeX: bridge X macs size {} ", (Object)this.xmacs.size());
            for (String xmac : this.xmacs) {
                LOG.debug("BridgeTopologyHelper: condition1BridgeX: bridge X mac: {} ", (Object)xmac);
                if (!this.ymactoport.containsKey(xmac)) continue;
                this.m_yx = this.ymactoport.get(xmac).getBridgePort();
                LOG.info("BridgeTopologyHelper: condition1BridgeX: found X mac: {} on Y port: {}", (Object)xmac, (Object)this.m_yx);
                return true;
            }
            return false;
        }

        private boolean condition1BridgeY() {
            LOG.info("BridgeTopologyHelper: condition1BridgeY: bridge Y macs size {} ", (Object)this.ymacs.size());
            for (String ymac : this.ymacs) {
                LOG.debug("BridgeTopologyHelper: condition1BridgeY: bridge Y mac: {} ", (Object)ymac);
                if (!this.xmactoport.containsKey(ymac)) continue;
                this.m_xy = this.xmactoport.get(ymac).getBridgePort();
                LOG.info("BridgeTopologyHelper: condition1BridgeY: found Y mac: {} on X port: {}", (Object)ymac, (Object)this.m_xy);
                return true;
            }
            return false;
        }

        public Integer getFirstBridgeConnectionPort() {
            return this.m_xy;
        }

        public Integer getSecondBridgeConnectionPort() {
            return this.m_yx;
        }

        public SimpleConnection getSimpleConnection() {
            return this.m_simpleconnection;
        }

        public Map<Integer, List<BridgeMacLink>> getFirstBridgeTroughSet() {
            return this.m_throughSetX;
        }

        public Map<Integer, List<BridgeMacLink>> getSecondBridgeTroughSet() {
            return this.m_throughSetY;
        }
    }
}

