/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlrpcUtil {
    private static final Logger LOG = LoggerFactory.getLogger(XmlrpcUtil.class);

    public static void createAndSendXmlrpcNotificationEvent(long txNo, String sourceUei, String message, int status, String generator) {
        LOG.debug("createAndSendXmlrpcNotificationEvent:  txNo= {}\n uei = {}\n message = {}\n status = {}", new Object[]{txNo, sourceUei, message, status});
        String hostAddress = InetAddressUtils.getLocalHostAddressAsString();
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/xmlrpcNotification", generator);
        bldr.setHost(hostAddress);
        bldr.addParam("txno", txNo);
        bldr.addParam("sourceUei", sourceUei);
        bldr.addParam("eventMessage", message);
        bldr.addParam("eventStatus", status);
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(bldr.getEvent());
            LOG.debug("createdAndSendXmlrpcNotificationEvent: successfully sent XMLRPC notification event for txno: {} / {} {}", new Object[]{txNo, sourceUei, status});
        }
        catch (Throwable t) {
            LOG.warn("run: unexpected throwable exception caught during send to middleware", t);
            int failureFlag = 2;
            EventBuilder bldr2 = new EventBuilder("uei.opennms.org/internal/capsd/xmlrpcNotification", generator);
            bldr2.setHost(hostAddress);
            bldr2.addParam("txno", txNo);
            bldr2.addParam("sourceUei", sourceUei);
            bldr2.addParam("eventMessage", message);
            bldr2.addParam("eventStatus", failureFlag);
            try {
                EventIpcManagerFactory.getIpcManager().sendNow(bldr2.getEvent());
                LOG.debug("createdAndSendXmlrpcNotificationEvent: successfully sent XMLRPC notification event for txno: {} / {} {}", new Object[]{txNo, sourceUei, failureFlag});
            }
            catch (Throwable te) {
                LOG.warn("run: unexpected throwable exception caught during send to middleware", te);
            }
        }
    }
}

