/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.netmgt.config.XmlrpcdConfigFactory;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcServer;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.netmgt.xmlrpcd.XmlRpcNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventQueueProcessor
implements Runnable,
PausableFiber {
    private static final Logger LOG = LoggerFactory.getLogger(EventQueueProcessor.class);
    private FifoQueue<Event> m_eventQ;
    private int m_maxQSize;
    private XmlRpcNotifier m_notifier;
    private AtomicInteger m_status = new AtomicInteger(0);
    private Thread m_worker;
    private boolean m_useGenericMessages;

    EventQueueProcessor(FifoQueue<Event> eventQ, XmlrpcServer[] rpcServers, int retries, int elapseTime, boolean verifyServer, String localServer, int maxQSize) {
        this.m_eventQ = eventQ;
        this.m_maxQSize = maxQSize;
        this.m_notifier = new XmlRpcNotifier(Arrays.copyOf(rpcServers, rpcServers.length), retries, elapseTime, verifyServer, localServer);
        this.m_useGenericMessages = XmlrpcdConfigFactory.getInstance().getConfiguration().getGenericMsgs();
    }

    private void processEvent(Event event) {
        String uei = event.getUei();
        if (uei == null) {
            LOG.debug("Event received with null UEI, ignoring event");
            return;
        }
        LOG.debug("About to process event: {}", (Object)event.getUei());
        LOG.debug(event.toString());
        if (this.m_useGenericMessages) {
            if (!this.m_notifier.sendEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/nodes/nodeLostService")) {
            if (!this.m_notifier.sendServiceDownEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/nodes/interfaceDown")) {
            if (!this.m_notifier.sendInterfaceDownEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/nodes/nodeDown")) {
            if (!this.m_notifier.sendNodeDownEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/nodes/nodeUp")) {
            if (!this.m_notifier.sendNodeUpEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/nodes/interfaceUp")) {
            if (!this.m_notifier.sendInterfaceUpEvent(event)) {
                this.pushBackEvent(event);
            }
        } else if (uei.equals("uei.opennms.org/nodes/nodeRegainedService") && !this.m_notifier.sendServiceUpEvent(event)) {
            this.pushBackEvent(event);
        }
        if (uei.equals("uei.opennms.org/internal/capsd/xmlrpcNotification")) {
            this.xmlrpcNotificationEventHandler(event);
        }
    }

    private void xmlrpcNotificationEventHandler(Event event) {
        boolean validParameters;
        long txNo = -1L;
        String sourceUei = null;
        String notification = null;
        int status = -1;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : event.getParmCollection()) {
            String temp;
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            LOG.debug("ParmName: {} /parmContent: {}", (Object)parmName, (Object)parmContent);
            if (parmName.equals("txno")) {
                temp = parmContent;
                try {
                    txNo = Long.valueOf(temp);
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("Parameter {} cannot be non-numeric", (Object)"txno", (Object)nfe);
                    txNo = -1L;
                }
                continue;
            }
            if (parmName.equals("sourceUei")) {
                sourceUei = parmContent;
                continue;
            }
            if (parmName.equals("eventMessage")) {
                notification = parmContent;
                continue;
            }
            if (!parmName.equals("eventStatus")) continue;
            temp = parmContent;
            try {
                status = Integer.valueOf(temp);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Parameter {} cannot be non-numeric", (Object)"eventStatus", (Object)nfe);
                status = -1;
            }
        }
        boolean bl = validParameters = txNo != -1L && sourceUei != null && notification != null && status != -1;
        if (!validParameters) {
            LOG.error("Invalid parameters.");
            return;
        }
        switch (status) {
            case 0: {
                if (this.m_notifier.notifyReceivedEvent(txNo, sourceUei, notification)) break;
                this.pushBackEvent(event);
                break;
            }
            case 1: {
                if (this.m_notifier.notifySuccess(txNo, sourceUei, notification)) break;
                this.pushBackEvent(event);
                break;
            }
            case 2: {
                if (this.m_notifier.notifyFailure(txNo, sourceUei, notification)) break;
                this.pushBackEvent(event);
            }
        }
    }

    private void pushBackEvent(Event event) {
        try {
            if (this.m_eventQ.size() < this.m_maxQSize) {
                this.m_eventQ.add((Object)event);
                LOG.debug("Push the event back to queue.");
            }
            this.m_notifier.createConnection();
        }
        catch (FifoQueueException e) {
            LOG.error("Failed to push the event back to queue", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error("Failed to push the event back to queue", (Throwable)e);
        }
    }

    private synchronized boolean statusOK() {
        boolean exitThread = false;
        boolean exitCheck = false;
        block9: while (!exitCheck) {
            if (!this.m_worker.isAlive() && this.m_status.get() != 3) {
                LOG.warn("{} terminated abnormally", (Object)this.getName());
                this.m_status.set(3);
            }
            switch (this.m_status.get()) {
                case 3: {
                    exitCheck = true;
                    exitThread = true;
                    this.m_status.set(4);
                    continue block9;
                }
                case 5: {
                    this.pause();
                    continue block9;
                }
                case 7: {
                    this.resume();
                    continue block9;
                }
                case 6: {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this.m_status.set(3);
                    }
                    continue block9;
                }
                case 2: {
                    exitCheck = true;
                    continue block9;
                }
            }
        }
        return !exitThread;
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber is running or has already run");
        }
        this.m_status.set(1);
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        LOG.info("{} started", (Object)this.getName());
    }

    public synchronized void pause() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        this.m_status.set(6);
        this.notifyAll();
    }

    public synchronized void resume() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        this.m_status.set(2);
        this.notifyAll();
    }

    public synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never run");
        }
        this.m_status.set(3);
        this.m_worker.interrupt();
        this.notifyAll();
    }

    public String getName() {
        return "EventQueueProcessor";
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status.set(4);
        }
        return this.m_status.get();
    }

    @Override
    public void run() {
        this.m_status.set(2);
        while (this.statusOK()) {
            Event event = null;
            try {
                event = (Event)this.m_eventQ.remove(1000L);
            }
            catch (InterruptedException iE) {
                LOG.debug("Caught interrupted exception, transitioning to STOP_PENDING status", (Throwable)iE);
                event = null;
                this.m_status.set(3);
            }
            catch (FifoQueueException qE) {
                LOG.debug("Caught FIFO queue exception.", (Throwable)qE);
                event = null;
                this.m_status.set(3);
            }
            if (event != null && this.statusOK()) {
                try {
                    this.processEvent(event);
                }
                catch (Throwable t) {
                    LOG.error("Unexpected error processing event.", t);
                }
            }
            if (event == null || this.statusOK()) continue;
            LOG.error("EventQueueProcessor not OK, exiting with status: {}", (Object)this.m_status.get());
        }
    }
}

