/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.util.Date;
import java.util.SortedSet;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.RrdDao;
import org.opennms.netmgt.dao.support.AttributeMatchingResourceVisitor;
import org.opennms.netmgt.dao.support.ResourceAttributeFilteringResourceVisitor;
import org.opennms.netmgt.dao.support.ResourceTypeFilteringResourceVisitor;
import org.opennms.netmgt.dao.support.ResourceWalker;
import org.opennms.netmgt.dao.support.RrdStatisticAttributeVisitor;
import org.opennms.netmgt.model.AttributeStatistic;
import org.opennms.netmgt.model.AttributeStatisticVisitor;
import org.opennms.netmgt.model.AttributeStatisticVisitorWithResults;
import org.opennms.netmgt.model.AttributeVisitor;
import org.opennms.netmgt.model.ResourceVisitor;
import org.opennms.netmgt.statsd.AbstractReportInstance;
import org.springframework.beans.factory.InitializingBean;

public abstract class BaseReportInstance
extends AbstractReportInstance
implements InitializingBean {
    private final AttributeStatisticVisitorWithResults m_attributeStatisticVisitor;
    private final RrdStatisticAttributeVisitor m_rrdVisitor = new RrdStatisticAttributeVisitor();
    private final AttributeMatchingResourceVisitor m_attributeVisitor = new AttributeMatchingResourceVisitor();
    private final ResourceTypeFilteringResourceVisitor m_resourceTypeVisitor = new ResourceTypeFilteringResourceVisitor();
    private String m_resourceAttributeKey;
    private String m_resourceAttributeValueMatch;
    private ResourceAttributeFilteringResourceVisitor m_resourceAttributeVisitor;

    protected BaseReportInstance(AttributeStatisticVisitorWithResults visitor) {
        this.m_attributeStatisticVisitor = visitor;
    }

    public abstract ResourceWalker getWalker();

    public void setResourceDao(ResourceDao resourceDao) {
        this.getWalker().setResourceDao(resourceDao);
    }

    public void setRrdDao(RrdDao rrdDao) {
        this.m_rrdVisitor.setRrdDao(rrdDao);
    }

    @Override
    public void walk() {
        this.setJobStartedDate(new Date());
        this.getWalker().walk();
        this.setJobCompletedDate(new Date());
    }

    @Override
    public SortedSet<AttributeStatistic> getResults() {
        return this.m_attributeStatisticVisitor.getResults();
    }

    @Override
    public String getResourceTypeMatch() {
        return this.m_resourceTypeVisitor.getResourceTypeMatch();
    }

    @Override
    public void setResourceTypeMatch(String resourceType) {
        this.m_resourceTypeVisitor.setResourceTypeMatch(resourceType);
    }

    @Override
    public String getAttributeMatch() {
        return this.m_attributeVisitor.getAttributeMatch();
    }

    @Override
    public void setAttributeMatch(String attr) {
        this.m_attributeVisitor.setAttributeMatch(attr);
    }

    @Override
    public long getStartTime() {
        return this.m_rrdVisitor.getStartTime();
    }

    @Override
    public void setStartTime(long start) {
        this.m_rrdVisitor.setStartTime(Long.valueOf(start));
    }

    @Override
    public long getEndTime() {
        return this.m_rrdVisitor.getEndTime();
    }

    @Override
    public void setEndTime(long end) {
        this.m_rrdVisitor.setEndTime(Long.valueOf(end));
    }

    @Override
    public String getConsolidationFunction() {
        return this.m_rrdVisitor.getConsolidationFunction();
    }

    @Override
    public void setConsolidationFunction(String cf) {
        this.m_rrdVisitor.setConsolidationFunction(cf);
    }

    @Override
    public int getCount() {
        return this.m_attributeStatisticVisitor.getCount();
    }

    @Override
    public void setCount(int count) {
        this.m_attributeStatisticVisitor.setCount(Integer.valueOf(count));
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.m_rrdVisitor.setStatisticVisitor((AttributeStatisticVisitor)this.m_attributeStatisticVisitor);
        this.m_attributeVisitor.setAttributeVisitor((AttributeVisitor)this.m_rrdVisitor);
        if (this.m_resourceAttributeKey != null && this.m_resourceAttributeValueMatch != null) {
            this.m_resourceAttributeVisitor = new ResourceAttributeFilteringResourceVisitor();
            this.m_resourceAttributeVisitor.setDelegatedVisitor((ResourceVisitor)this.m_attributeVisitor);
            this.m_resourceAttributeVisitor.setResourceAttributeKey(this.m_resourceAttributeKey);
            this.m_resourceAttributeVisitor.setResourceAttributeValueMatch(this.m_resourceAttributeValueMatch);
            this.m_resourceAttributeVisitor.afterPropertiesSet();
            this.m_resourceTypeVisitor.setDelegatedVisitor((ResourceVisitor)this.m_resourceAttributeVisitor);
        } else {
            this.m_resourceTypeVisitor.setDelegatedVisitor((ResourceVisitor)this.m_attributeVisitor);
        }
        this.getWalker().setVisitor((ResourceVisitor)this.m_resourceTypeVisitor);
        this.m_attributeStatisticVisitor.afterPropertiesSet();
        this.m_rrdVisitor.afterPropertiesSet();
        this.m_attributeVisitor.afterPropertiesSet();
        this.m_resourceTypeVisitor.afterPropertiesSet();
        this.getWalker().afterPropertiesSet();
    }

    @Override
    public void setResourceAttributeKey(String resourceAttributeKey) {
        this.m_resourceAttributeKey = resourceAttributeKey;
    }

    @Override
    public void setResourceAttributeValueMatch(String resourceAttributeValueMatch) {
        this.m_resourceAttributeValueMatch = resourceAttributeValueMatch;
    }

    @Override
    public String getResourceAttributeKey() {
        return this.m_resourceAttributeKey;
    }

    @Override
    public String getResourceAttributeValueMatch() {
        return this.m_resourceAttributeValueMatch;
    }
}

