/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.netmgt.config.RTCConfigFactory;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.rtc.DataManager;
import org.opennms.netmgt.rtc.DataUpdater;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

@EventListener(name="RTC:BroadcastEventProcessor", logPrefix="rtc")
public class BroadcastEventProcessor
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastEventProcessor.class);
    private ExecutorService m_updater;
    @Autowired
    private DataManager m_dataManager;
    @Autowired
    private RTCConfigFactory m_configFactory;

    public void afterPropertiesSet() throws Exception {
        this.m_updater = Executors.newFixedThreadPool(this.m_configFactory.getUpdaters(), (ThreadFactory)new LogPreservingThreadFactory(this.getClass().getSimpleName(), this.m_configFactory.getUpdaters()));
    }

    @EventHandler(ueis={"uei.opennms.org/nodes/nodeGainedService", "uei.opennms.org/nodes/nodeLostService", "uei.opennms.org/nodes/interfaceDown", "uei.opennms.org/nodes/nodeDown", "uei.opennms.org/nodes/nodeUp", "uei.opennms.org/nodes/nodeCategoryMembershipChanged", "uei.opennms.org/nodes/interfaceUp", "uei.opennms.org/nodes/nodeRegainedService", "uei.opennms.org/nodes/serviceDeleted", "uei.opennms.org/nodes/serviceUnmanaged", "uei.opennms.org/nodes/interfaceReparented", "uei.opennms.org/nodes/assetInfoChanged"})
    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        LOG.debug("About to start processing recd. event");
        try {
            String uei = event.getUei();
            if (uei == null) {
                return;
            }
            this.m_updater.execute(new DataUpdater(this.m_dataManager, event));
            LOG.debug("Event {} added to updater queue", (Object)uei);
        }
        catch (RejectedExecutionException ex) {
            LOG.error("Failed to process event", (Throwable)ex);
            return;
        }
        catch (Throwable t) {
            LOG.error("Failed to process event", t);
            return;
        }
    }
}

