/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.Querier;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.dao.api.PathOutageManager;

public class PathOutageManagerJdbcImpl
implements PathOutageManager {
    private static final String GET_CRITICAL_PATHS = "SELECT DISTINCT node.nodelabel, pathoutage.criticalpathip, pathoutage.criticalpathservicename FROM pathoutage, ipinterface, node WHERE pathoutage.nodeid = node.nodeid ORDER BY node.nodelabel, pathoutage.criticalpathip, pathoutage.criticalpathservicename";
    private static final String GET_CRITICAL_PATH_BY_NODEID = "SELECT criticalpathip, criticalpathservicename FROM pathoutage WHERE nodeid=?";
    private static final String GET_NODES_IN_PATH = "SELECT DISTINCT pathoutage.nodeid FROM pathoutage, ipinterface WHERE pathoutage.criticalpathip=? AND pathoutage.criticalpathservicename=? AND pathoutage.nodeid=ipinterface.nodeid AND ipinterface.ismanaged!='D' ORDER BY nodeid";
    private static final String COUNT_MANAGED_SVCS = "SELECT count(*) FROM ifservices WHERE status ='A' and nodeid=?";
    private static final String COUNT_OUTAGES = "SELECT count(*) FROM outages WHERE svcregainedeventid IS NULL and nodeid=?";
    private static final String COUNT_NODES_IN_PATH = "SELECT count(DISTINCT pathoutage.nodeid) FROM pathoutage, ipinterface WHERE pathoutage.criticalpathip=? AND pathoutage.criticalpathservicename=? AND pathoutage.nodeid=ipinterface.nodeid AND ipinterface.ismanaged!='D'";
    private static final String GET_NODELABEL_BY_IP = "SELECT nodelabel FROM node WHERE nodeid IN (SELECT nodeid FROM ipinterface WHERE ipaddr=? AND ismanaged!='D')";
    private static final String GET_NODEID_BY_IP = "SELECT nodeid FROM ipinterface WHERE ipaddr=? AND ismanaged!='D' ORDER BY nodeid DESC LIMIT 1";
    private static final String GET_NODELABEL_BY_NODEID = "SELECT nodelabel FROM node WHERE nodeid=?";
    private static final String GET_CRITICAL_PATH_STATUS = "SELECT count(*) FROM outages WHERE ipaddr=? AND ifregainedservice IS NULL AND serviceid=(SELECT serviceid FROM service WHERE servicename=?)";
    private static final String IS_CRITICAL_PATH_MANAGED = "SELECT count(*) FROM ifservices WHERE ipaddr=? AND status='A' AND serviceid=(SELECT serviceid FROM service WHERE servicename=?)";
    private static final String GET_DEPENDENCY_NODES_BY_NODEID = "select po.nodeid from pathoutage po left join ipinterface intf on po.criticalpathip=intf.ipaddr where intf.nodeid=?";
    private static final String GET_NODES_IN_PATHS = "SELECT DISTINCT pathoutage.nodeid FROM pathoutage, ipinterface WHERE pathoutage.criticalpathip=? AND pathoutage.nodeid=ipinterface.nodeid AND ipinterface.ismanaged!='D' ORDER BY nodeid";

    public static PathOutageManager getInstance() {
        return new PathOutageManagerJdbcImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> getAllCriticalPaths() throws SQLException {
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(PathOutageManagerJdbcImpl.class, new Object[]{conn});
        ArrayList<String[]> paths = new ArrayList<String[]>();
        try {
            PreparedStatement stmt = conn.prepareStatement(GET_CRITICAL_PATHS);
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                String[] path = new String[]{rs.getString(1), rs.getString(2), rs.getString(3)};
                paths.add(path);
            }
            ArrayList<String[]> arrayList = paths;
            return arrayList;
        }
        finally {
            d.cleanUp();
        }
    }

    public String getPrettyCriticalPath(int nodeID) throws SQLException {
        String[] path = this.queryForCriticalPath(nodeID);
        if (path[0] == null) {
            return "Not Configured";
        }
        return path[0] + " " + path[1];
    }

    private final String[] queryForCriticalPath(int nodeId) {
        final String[] cpath = new String[2];
        Querier querier = new Querier(DataSourceFactory.getInstance(), GET_CRITICAL_PATH_BY_NODEID){

            public void processRow(ResultSet rs) throws SQLException {
                cpath[0] = rs.getString(1);
                cpath[1] = rs.getString(2);
            }
        };
        querier.execute(new Object[]{nodeId});
        return cpath;
    }

    public String[] getCriticalPath(int nodeId) {
        String[] cpath = this.queryForCriticalPath(nodeId);
        if (cpath[0] == null || "".equals(cpath[0].trim())) {
            cpath[0] = OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathIp();
            cpath[1] = "ICMP";
        } else if (cpath[1] == null || "".equals(cpath[1].trim())) {
            cpath[1] = "ICMP";
        }
        return cpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getNodesInPath(String criticalPathIp, String criticalPathServiceName) throws SQLException {
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(PathOutageManagerJdbcImpl.class, new Object[]{conn});
        TreeSet<Integer> pathNodes = new TreeSet<Integer>();
        try {
            PreparedStatement stmt = conn.prepareStatement(GET_NODES_IN_PATH);
            d.watch((Object)stmt);
            stmt.setString(1, criticalPathIp);
            stmt.setString(2, criticalPathServiceName);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                pathNodes.add(rs.getInt(1));
            }
        }
        finally {
            d.cleanUp();
        }
        return pathNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLabelAndStatus(String nodeIDStr, Connection conn) throws SQLException {
        DBUtils d = new DBUtils(PathOutageManagerJdbcImpl.class);
        try {
            int countManagedSvcs = 0;
            int countOutages = 0;
            String[] result = new String[3];
            result[1] = "Cleared";
            result[2] = "Unmanaged";
            int nodeID = WebSecurityUtils.safeParseInt((String)nodeIDStr);
            PreparedStatement stmt = conn.prepareStatement(GET_NODELABEL_BY_NODEID);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                result[0] = rs.getString(1);
            }
            rs.close();
            stmt.close();
            stmt = conn.prepareStatement(COUNT_MANAGED_SVCS);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                countManagedSvcs = rs.getInt(1);
            }
            rs.close();
            stmt.close();
            if (countManagedSvcs > 0) {
                stmt = conn.prepareStatement(COUNT_OUTAGES);
                d.watch((Object)stmt);
                stmt.setInt(1, nodeID);
                rs = stmt.executeQuery();
                d.watch((Object)rs);
                while (rs.next()) {
                    countOutages = rs.getInt(1);
                }
                rs.close();
                stmt.close();
                if (countManagedSvcs == countOutages) {
                    result[1] = "Critical";
                    result[2] = "All Services Down";
                } else if (countOutages == 0) {
                    result[1] = "Normal";
                    result[2] = "All Services Up";
                } else {
                    result[1] = "Minor";
                    result[2] = "Some Services Down";
                }
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCriticalPathData(String criticalPathIp, String criticalPathServiceName) throws SQLException {
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(PathOutageManagerJdbcImpl.class, new Object[]{conn});
        String[] result = new String[4];
        int nodeCount = 0;
        int count = 0;
        try {
            PreparedStatement stmt0 = conn.prepareStatement(GET_NODELABEL_BY_IP);
            d.watch((Object)stmt0);
            stmt0.setString(1, criticalPathIp);
            ResultSet rs0 = stmt0.executeQuery();
            d.watch((Object)rs0);
            while (rs0.next()) {
                ++count;
                result[0] = rs0.getString(1);
            }
            if (count > 1) {
                result[0] = "(" + count + " nodes have this IP)";
            }
            rs0.close();
            stmt0.close();
            count = 0;
            PreparedStatement stmt1 = conn.prepareStatement(GET_NODEID_BY_IP);
            d.watch((Object)stmt1);
            stmt1.setString(1, criticalPathIp);
            ResultSet rs1 = stmt1.executeQuery();
            d.watch((Object)rs1);
            while (rs1.next()) {
                result[1] = rs1.getString(1);
            }
            rs1.close();
            stmt1.close();
            PreparedStatement stmt2 = conn.prepareStatement(COUNT_NODES_IN_PATH);
            d.watch((Object)stmt2);
            stmt2.setString(1, criticalPathIp);
            stmt2.setString(2, criticalPathServiceName);
            ResultSet rs2 = stmt2.executeQuery();
            d.watch((Object)rs2);
            while (rs2.next()) {
                nodeCount = rs2.getInt(1);
            }
            result[2] = Integer.toString(nodeCount);
            rs2.close();
            stmt2.close();
            PreparedStatement stmt = conn.prepareStatement(IS_CRITICAL_PATH_MANAGED);
            d.watch((Object)stmt);
            stmt.setString(1, criticalPathIp);
            stmt.setString(2, criticalPathServiceName);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            stmt.close();
            if (count > 0) {
                PreparedStatement stmt3 = conn.prepareStatement(GET_CRITICAL_PATH_STATUS);
                d.watch((Object)stmt3);
                stmt3.setString(1, criticalPathIp);
                stmt3.setString(2, criticalPathServiceName);
                ResultSet rs3 = stmt3.executeQuery();
                d.watch((Object)rs3);
                while (rs3.next()) {
                    count = rs3.getInt(1);
                }
                result[3] = count > 0 ? "Critical" : "Normal";
                while (rs3.next()) {
                    result[3] = rs3.getString(1);
                }
                rs3.close();
                stmt3.close();
            } else {
                result[3] = "Cleared";
            }
        }
        finally {
            d.cleanUp();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getAllNodesDependentOnAnyServiceOnInterface(String criticalpathip) throws SQLException {
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(PathOutageManagerJdbcImpl.class, new Object[]{conn});
        TreeSet<Integer> pathNodes = new TreeSet<Integer>();
        try {
            PreparedStatement stmt = conn.prepareStatement(GET_NODES_IN_PATHS);
            d.watch((Object)stmt);
            stmt.setString(1, criticalpathip);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                pathNodes.add(rs.getInt(1));
            }
        }
        finally {
            d.cleanUp();
        }
        return pathNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getAllNodesDependentOnAnyServiceOnNode(int nodeid) throws SQLException {
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(PathOutageManagerJdbcImpl.class, new Object[]{conn});
        TreeSet<Integer> pathNodes = new TreeSet<Integer>();
        try {
            PreparedStatement stmt = conn.prepareStatement(GET_DEPENDENCY_NODES_BY_NODEID);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                pathNodes.add(rs.getInt(1));
            }
        }
        finally {
            d.cleanUp();
        }
        return pathNodes;
    }
}

